(in-package :user)

(defvar anytest-implementation)
(defvar anytest-proxy)

(defun anytest-invoke(&optional filename)
  (setq filename (or filename "anytest.ior"))
  (setq anytest-implementation (make-instance 'anytest-implementation))
  (orblink:write-ior-to-file anytest-implementation filename)
  (setq anytest-proxy (orblink:read-ior-from-file filename))
  `(
    (0 . ,(op:testany anytest-proxy 0))
    (1 . ,(op:testany anytest-proxy 1))
    (255 . ,(op:testany anytest-proxy 255))
    (256 . ,(op:testany anytest-proxy 256))
    (257 . ,(op:testany anytest-proxy 256))
    (65535 . ,(op:testany anytest-proxy 65535))
    (65536 . , (op:testany anytest-proxy 65536))
    (100000000 . ,(op:testany anytest-proxy 100000000))
    (-1 . ,(op:testany anytest-proxy -1))
    (-65535 . ,(op:testany anytest-proxy -65535))
    (-65536 . ,(op:testany anytest-proxy -65536))
    (-100000000 . ,(op:testany anytest-proxy -100000000))
    (t . ,(op:testany anytest-proxy t))
    (nil  . ,(op:testany anytest-proxy nil))
    ("string" . ,(op:testany anytest-proxy "string"))
    (1.343  . ,(op:testany anytest-proxy 1.343))
    (-34598.343 . ,(op:testany anytest-proxy -34598.343))
    (#\z  . ,(op:testany anytest-proxy #\z))
    ((anytest:structexample :foo 3) .,(op:testany anytest-proxy (anytest:structexample :foo 3)))
    ))
