
(in-package :db.ac)


  
   
(defmacro defclass* (&rest list)  
  `(defclass-prepare ',list))

(defun defclass-prepare (list)
  (let* ((class-name (first list))
         (supers (second list))
         (direct-slots (third list))
         (direct-slots-edited nil)
         e accessor
         slot-name)
    
    (dolist (s direct-slots)	  
      (setf e
        (if (symbolp s)
            (list s)
          (copy-tree s)))			; otherwise original might be corrupted
      (setf slot-name (car e))
      
      (setf accessor (getf (cdr e) :accessor))
      
      (when (not accessor)
        (setf accessor slot-name)
        (nconc e (list :accessor accessor)))
      
      ; handle initform
      (when (not (member :initform e))        
        (nconc e (list :initform nil)))
      
      ; handle initarg
      (when (not (member :initarg e))
        (nconc e (list :initarg (read-from-string
                                 (format nil ":~s" slot-name)))))
      
      
      (push e direct-slots-edited))
    
    (setf direct-slots-edited
      (nreverse (remove nil direct-slots-edited)))	; essential rebuild-defclass to work
    
    (let* ((form `(defclass ,class-name ,supers
                    ,direct-slots-edited
                    (:metaclass persistent-class)))
           (funname (intern (format nil "~a-~a" :make class-name)))
           
           (maker `(defmacro ,funname (&rest args)
                     `(make-instance ',',class-name ,@args))))
      ;(setf *steve* funname)
      ;(pprint maker)
      (eval maker)
      ;(pprint form)
      (eval form))))

;;;;;;;;;;;;;;;

(defun retrieve (class-name slot value &key oid all)
  (retrieve-from-index (find-class class-name) slot value
		       :oid oid :all all))


;; concatenating a list of args into a string, slow but secure...

(defun str+ (&rest list)
  (format nil "~{~a~}" list))

;; hashtable printer

(defun htprint (x)
  (maphash #'(lambda (a b)(print (list a b))) x))

;; defun <>

(defun <> (a b)
  (not (equal a b)))

(defun string<> (a b)
  (not (string= a b)))

#| 
both the next versions will print fine except when a slot is an object or 
has a list or vectors with objects in it

; steve's version
(defmacro defprinter (class &rest args)
  `(defmethod print-object ((self ,class) stream)
     (print-unreadable-object (self stream :type t)
       ,@(loop for accessors on args
	     as accessor = (car accessors)
			   ;; collect `(princ ',accessors stream)
			   ;; collect `(write-char #\space stream)
	     collect `(princ (,accessors self) stream)
	     if (cdr accessors)
	     collect `(write-char #\space stream)
	     and
	     collect `(pprint-newline :fill stream)))))

; jans' version
(defmacro defprinter (class &rest args)
  `(defmethod print-object ((self ,class) stream)
     (print-unreadable-object (self stream :type t)
       (do ((accessors ',args (cdr accessors)))
	   ((null accessors))
	 (let ((val (funcall (car accessors) self)))
	   (princ val stream)
	   (when (cdr accessors)
	     (write-char #\space stream)
      (pprint-newline :fill stream)))))))

|#

(defmacro defprinter (class &rest args)
  `(defmethod print-object ((self ,class) stream)
     (print-unreadable-object (self stream :type t)
       (do ((accessors ',args (cdr accessors)))
           ((null accessors))
         (let ((val (funcall (car accessors) self)))
           (cond ((typep val 'string)                  
                  (princ val stream))
                 ((typep val 'standard-object)
                  (format stream "<~a #> " (type-of val)))
                 ((arrayp val)                  
                  (dotimes (i (min 5 (length val)))
                    (princ "#<" stream)
                    (cond ((typep (aref val i) 'standard-object)
                           (format stream "<~a #> " (type-of (aref val i)))
                           (t (princ (aref val i) stream)))))
                  (if (< 5 (length val))
                      (princ "...>" stream)
                    (princ ">" stream)))
                 ((null val)
                  (princ nil stream))
                 ((listp val)
                  (let ((c 5)
                        (early nil ))
                    (princ "(" stream)
                    (dolist (e val)
                      (when (= c 0) 
                        (setf early t)
                        (return))
                      (if (typep e 'standard-object)
                          (format stream "<~a #> " (type-of e))
                        (princ e stream))
                      (decf c))
                    (if early
                        (princ "...)" stream)
                      (princ ")" stream))))
                 (t (princ val stream))))
         (when (cdr accessors)
           (write-char #\space stream))))))


;;;;;;;;;;;

(eval-when (load compile eval)
  (progn
    (export 'defclass* :db.ac)
    (export 'open-database :db.ac)
    (export 'close-database :db.ac)
    (export 'retrieve :db.ac)
    (export 'str+ :db.ac)
    (export 'defprinter :db.ac)))
