; :cd ~/lisp/allegrocache/v10/demo

(load "exampleload.cl")

(in-package :example)

(open-file-database "./test.db"
		    :if-does-not-exist :create
		    :if-exists :supersede)

(defclass* person ()
  (id :index :any)
  (first-name :index :any)
  (last-name :index :any)
  (city :index :any)
  birth-date
  children
  (age :index :any)
  sex
  relationship)

(defclass* relationship ()
  p1 p2 start-date end-date relationship-type)

(defclass* city ()
  (name :index :any)
  inhabitants 
  country)

(defprinter person
    first-name last-name)

(defprinter
    city name)

(defprinter
    relationship p1 p2)

;=====
(setf family '(( 1 Mary Smith      London       1932-04-16 female  (5))
               ( 2 John Doe        London       1934-07-10 male    (5))

               ( 3 Nora Wild       Manchester   1928-06-13 female  (6 9 10))
               ( 4 Hans Night      Manchester   1926-05-12 male    (6 9 10))

               ( 5 Jans Doe        Moraga       1958-07-29 male    (7 8))
               ( 6 Cornelia Night  Moraga 1956-12-18 female  (7 8))
               ( 7 Boudey Doe      Moraga       1992-09-01 male    nil)
               ( 8 Hans Doe        Moraga       1994-10-11 male    nil)

               ( 9 Ernestine Night Amsterdam    1958-07-26 female  nil)
               (10 Johnny Night    Harlem       1962-01-01 male    (11))

               (11 Suze Night      Harlem       2004-01-01 female  nil)))

(setf relationship '((1 1 2 married 1958-04-01)
		         (2 3 4 married 1955-05-01)
		         (3 5 6 married 1994-04-04)))

(setf cities '(  (1 London     5000000 England)
	          (2 Manchester 3000000 England)
	          (3 Moraga       16000 Usa)
	          (4 Amsterdam  1000000 Netherlands)
	          (5 Harlem      150000 USA)))

(defun fill-family-database ()
  (dolist (e family)
    (make-instance 'person :id (nth 0 e) 
      :first-name (nth 1 e) :last-name (nth 2 e) :city (nth 3 e)
      :birth-date (nth 4 e) :sex (nth 5 e) :children (nth 6 e)
      :age (- 2005 (read-from-string (symbol-name (nth 4 e))
				     :start 0 :end 4))))
  (doclass (e (find-class 'person))
           (setf (children e)
             (mapcar #'(lambda (x) (retrieve-from-index 'person 'id x))
               (children e))))
  (dolist (r relationship)
    (make-instance 'relationship
      :p1 (retrieve-from-index 'person 'id (nth 1 r))  
      :p2 (retrieve-from-index 'person 'id (nth 2 r))
      :relationship-type (nth 3 r) :start-date (nth 4 r)))
  (dolist (c cities)
    (make-instance 'city :name (nth 1 c) :inhabitants (nth 2 c) 
      :country (nth 3 c))))
    
(fill-family-database)

(commit)

; change class

(defclass* city ()
  (name :index :any)
   inhabitants country
   mayor) 
        

(make-instance 'city :name 'Oakland 
                     :inhabitants 700000
                     :mayor 'JerryBrown)

(commit)

(mayor (retrieve-from-index 'city 'name 'Oakland))
(mayor (retrieve-from-index 'city 'name 'London))

        
; low level retrieve

(doclass (e 'person)
   (print e))

(retrieve-from-index 'person 'first-name 'Jans)

(retrieve-from-index-range 'person 'age 0 20)

; Prolog as one retrieval language

(<-- (father ?x ?y)
     (db person ?x sex male children ?c)
     (member ?y ?c))

(show-all2 father)

(<-- (mother ?x ?y)
     (db person ?x sex female children ?c)
     (member ?y ?c))

(<-- (parent ?x ?y)
     (father ?x ?y))

(<- (parent ?x ?y)      
     (mother ?x ?y))
   
(<-- (grandparent ?x ?y)
     (parent ?x ?z)
     (parent ?z ?y))

(<-- (grandchild ?x ?y)
     (grandparent ?y ?x))

(<-- (ancestor ?x ?y)
     (parent ?x ?y))

(<-  (ancestor ?x ?y)
     (parent ?x ?z)        
     (ancestor ?z ?y))

(<-- (descendent ?x ?y)
     (ancestor ?y ?x))

(<-- (parent-child-in-different-country ?x ?y)     
     (db person ?x city ?n1)
     (parent ?x ?y)
     (db city ?c1 name ?n1 country ?country1)     
     (db person ?y city ?n2)
     (db city ?c2 name ?n2 country ?country2)
     (not (= ?country1 ?country2)))

(<-- (female ?x)
     (db person ?x sex female))

(<-- (male ?x)
     (db person ?x sex male))

(<-- (aunt ?x ?y) 
     (father ?z ?x)
     (female ?x)
     (father ?z ?w)
     (not (= ?x ?w))
     (parent ?w ?y))

(<-- (uncle ?x ?y) 
     (father ?z ?x)
     (male ?x)
     (father ?z ?w)
     (not (= ?x ?w))
     (parent ?w ?y))

      
(<-- (nephew ?x ?y)
     (aunt ?y ?x)
     (male ?x))

(<- (nephew ?x ?y)
    (uncle ?y ?x)
    (male ?x))

(<-- (niece ?x ?y)
     (aunt ?y ?x)
     (female ?x))         

(<- (niece ?x ?y)
    (uncle ?y ?x)
    (female ?x))


; using names instead of instances..

(<-- (father2 ?x ?y)
     (db person ?x1 first-name ?x sex male 
         children ?c)
     (member ?y1 ?c)
     (db person ?y1 first-name ?y))

;; some fun metaprogramming...

(load "metarelations.cl")

(clear-relations)

(register-relations 
 'father 'mother 'parent 'grandparent 'grandchild
 'ancestor 'descendent 'parent-child-in-different-country
 'aunt 'uncle 'nephew 'niece)


(<-- (person ?x)
     (db person ?x))
      

(defun show-all-relations ()
  (prolog (person ?x)
          (person ?y)
          (not (= ?x ?y))
          (bagof ?r (relation ?x ?y ?r) ?bag)
          (lisp (format t "~%~s ~s -> ~s ~s :: ~s"
                  (first-name ?x) (last-name ?y)
                  (first-name ?y) (last-name ?y)
                  ?bag))))

(compile 'show-all-relations)

(show-all-relations)

;; maps

(setf m1 (open-map "square" 
                   :if-does-not-exist :create
		           :if-exists :open))

(setf (map-value m1 'eurolisp2005) 'Amsterdam)

(map-value m1 'eurolisp2005)

(setf foo (list
           1.001
           "a relatively short string"
           '(1 2 3)
           'horse
           #(1 2 3)
           (retrieve-from-index 'person 'first-name 'Jans)
           m1
           ))

; everything that can be stored in allegrocache can be used as a key for a map. So 
; in the following example we take every item in foo both as a key and as a value..

(dolist (e foo)
  (setf (map-value m1 e) e))


(dolist (e foo)
  (print (map-value m1 e)))


(map-map #'(lambda (k v)
	     (print (list k v)))
	 m1)

(commit)

;; sets

(setf set (make-instance 'ac-set))

(push set foo)

(dolist (e foo)
  (add-to-set set e))

(commit)

(doset (var set)
   (print var))

(remove-from-set set '(1 2 3))

(doset (var set) (print var))

;a typical usages of sets as slots of objects..

(setf p1 (make-instance 'person
	   :first-name 'fritz :last-name 'kunze
	   :children (make-instance 'ac-set)))

(add-to-set (children p1)
            (make-instance 'person 
              :first-name 'michael 
              :last-name 'kunze))

(add-to-set (children p1)
            (make-instance 'person 
              :first-name 'lauren 
              :last-name 'kunze))


(doset (ch (children p1))
    (print (first-name ch)))

(commit)


;;; frames : forbidden to use...

(start-frame-system)

(defframe 'animal :isa 'living-thing)

(defframe 'mammal :isa 'animal :legs 4 :eyes 2)

(defframe 'dog :isa 'mammal)

(defframe 'fido :isa 'dog)

(fsv! 'fido :owner 'jans)

(fsv 'fido :legs)

; fido has an accident

(fsv! 'fido :legs 3)
(fsv! 'fido :eyes 1)
(fsv! 'fido :dead 'yes)

(fsv 'fido :legs)

(commit)

;;; xml

(objectify-xml :file #P"sersamp2005.xml" 
               :persistent t)

(dump-schema-pretty)

(doclass (e 'db.ac::ac-class)
         (print (db.ac::ac-class-name e)))

(doclass (e 's::|DateCreated|)
   (print (s::|Year| e)))



;;; 


(close-database :db *allegrocache*)
