(in-package :example)

(defvar *frames*)

(defun start-frame-system ()
  (setf *frames* (make-hash-table :size 100)))


(eval-when (compile load eval)

  (defun set-multivalued (sym)
    (setf (get sym :multivalued) t))

  
  (set-multivalued :isa)

  (defclass* frame ()
    (name :index :any-unique)
    __slots__)
  
  (defprinter frame __slots__)

  ) ; end eval-when


(defun defframe (name &rest list)
  (let ((fr (make-instance 'frame :name name)))
    (setf (gethash name *frames*) fr)
    (do* ((l list (cddr l))
	  (s (first l) (first l))
	  (v (second l) (second l)))
	((null l))
      (if (get s :multivalued) (setf v (list v)))
      (push (cons s v) (__slots__ fr)))
    fr))

(defun get-frame-from-symbol (frame)
  (let ((temp nil))
    (cond ((typep frame 'frame)
	   frame)
	  ((atom frame)
	   (setf temp (gethash frame *frames*))
	   (when (not temp)
	     (setf temp (retrieve-from-index 'frame 'name frame))	     
	     (when (not temp)
	       (error "~a is not a frame in database or memory" frame)))
	   (setf (gethash frame *frames*) temp)
	   temp)
	  (t (error "no frame ~s" frame)))))
  

(defun fsv (frame attribute)
  (let ((fr (get-frame-from-symbol frame)))   
    (let* ((temp (assoc attribute (__slots__ fr))))
      (if* temp
	 then (values (cdr temp) t)	      
	 else
	      (let ((temp (assoc :isa (__slots__ fr)))
		    (res nil))
		(when temp
		  ;(print (list "hier is " temp))
		  (dolist (e (cdr temp))
		    (if (setf res (fsv e attribute))
			(return res)))
		  res))))))

(defun fsv! (frame attribute value)  
  (let ((fr (get-frame-from-symbol frame)))
    (let* ((temp (assoc attribute (__slots__ fr))))
      (cond ((get attribute :multivalued)
	     (if* temp
		then (setf (cdr temp)(cons value (cdr temp)))
		     value
		else (push (cons attribute (list value)) (__slots__ fr))
		     value))
	    (t (if* temp
		  then (setf (cdr temp) value)
		       value
		  else (push (cons attribute value) (__slots__ fr))
		       value))))))


(defun fsv-push (frame attribute value)
  (let ((fr (get-frame-from-symbol frame)))
    (let* ((temp (assoc attribute (__slots__ fr))))
      (if* temp
	 then (setf (cdr temp) (cons value (cdr temp)))
	      value
	 else (push (cons attribute (list value)) (__slots__ fr))
	      value))))





	   
