;; useful utilities

(defpackage :db.allegrocache.utils
  (:use :common-lisp :excl 
	:db.quicktab
	:db.btree
	:db.allegrocache
	)
  (:nicknames :db.ac.utils)
  (:export
   #:defclass*
   #:defprinter
   
   #:*default-defprinter*
   #:*default-print-defclass*-expansion*
   ))

(in-package :db.allegrocache.utils)

(defvar *default-print-defclass*-expansion* t)
(defvar *default-defprinter* nil) ; default value of :defprinter

;; options
;;   print         *default-print..expansion*) show expansion
;;   defprinter    (nil) define defprinter too
;;   conc-name     (nil) accessors are classname-slotname
;;   init          (t)   initialize slots to nil 
;;   make	   (nil) generate a make-class macro
;;

(defmacro defclass* (class-name superclasses &rest slots)
  (defclass-prepare class-name superclasses slots))

(defun defclass-prepare (class-name supers direct-slots)
  (let* ((direct-slots-edited nil)
         e accessor
         slot-name
	 ;; options
	 (print *default-print-defclass*-expansion*)
	 (defprinter *default-defprinter*)
	 (conc-name  nil)
	 (init       t)
	 (make     nil)
	 ;; end
	 
	 )

    
    ; scan supers list looking for options
    (let (newsupers)
      (do ((sup supers (cdr sup)))
	  ((null sup))
	(if* (keywordp (car sup))
	   then ; starting options
		(loop
		  (let ((val (cadr sup)))
		    (ecase (car sup)
		      (:print (setq print val))
		      (:defprinter (setq defprinter val))
		      (:conc-name  (setq conc-name val))
		      (:init       (setq init val))
		      (:make       (setq make val))
		      )
		  
		    (if* (null (setq sup (cddr sup)))
		       then (return))))
		(return)
	   else (push (car sup) newsupers)))
      
      (setq supers (nreverse newsupers)))

		
		  

    ; direct slots can be expressed as 
    ;  1. (a b c d e)    - defstruct/defprinter form
    ;  2. ((a b c d e))  - defclass form
    ; where each of a,b,c .. can be  name or (name :arg val :arg2  val)
    ; we have to distinguish the cases
    ;
    (if* (or (cdr direct-slots)  ; case 1
	     (atom (car direct-slots))  
	     (keywordp (cadr (car direct-slots))))
       then ; case 1
	    nil
       else ; case 2
	    (setq direct-slots (car direct-slots)))
    
    
    (dolist (s direct-slots)	  
      (setf e
	(if* (symbolp s)
	   then (list s)
	   else (copy-tree s)))  ; otherwise original might be corrupted
      (setf slot-name (car e))
      
      (setf accessor (getf (cdr e) :accessor))
      
      (if* (not accessor)
	 then (if* conc-name
		 then (setq accessor 
			(intern (format nil "~a-~a"
					class-name slot-name)))
		 else (setf accessor slot-name))
	      (nconc e (list :accessor accessor)))
           
      ; handle initform.
      ;; give each slot a nil initform... is this a good idea??
      (if* (and (eq e (getf (cdr e) :initform e))
		init)
	 then (nconc e (list :initform nil)))
      
      ; handle initarg
      (if* (eq e (getf (cdr e) :initarg e))
	 then (nconc e (list :initarg 
			     (excl::make-keyword  slot-name))))
      
      
      (push e direct-slots-edited))
    
    (setf direct-slots-edited
      (nreverse (remove nil direct-slots-edited)))	; essential rebuild-defclass to work

    (let* ((form `(defclass ,class-name ,supers
		    ,direct-slots-edited
		    (:metaclass persistent-class)))
	   (funname (intern (format nil "make-~a" class-name)))
	   (maker `(defmacro ,funname (&rest args)
		     `(make-instance ',',class-name ,@args))))
      
      
      (if* print 
	 then (pprint form)
	      (if* make then (pprint maker)))
      
      `(progn ,form
	      ,(if* make then maker)
	      ,(if* defprinter
		  then `(defprinter ,class-name
			    ,@(mapcar #'(lambda (x)
					  (if* (atom x)
					     then x
					     else (car x)))
				      direct-slots)))
	      ))))

;;;;;;;;;;;;;;;















(defmacro defprinter (class &rest args)
  `(defmethod print-object ((self ,class) stream)
     (print-unreadable-object (self stream :type t)
       (format stream "[~s]~a "
	       (db.ac::db-object-oid self)
	       (if* (db.ac::db-object-modified self)
		  then "*" 
		  else ""))
			      
       (do ((accessors ',args (cdr accessors)))
           ((null accessors))
         (let ((val (and (slot-boundp self (car accessors))
			 (slot-value  self (car accessors)))))
           (typecase val
	     (standard-object
	      (format stream "<~a #> " 
		      (type-of val)
		      
		      ))
	     #+ignore (array
		       (dotimes (i (min 5 (length val)))
			 (princ "#<" stream)
			 (typecase (aref val i) 
			   (standard-object
			    (format stream "<~a #> " (type-of (aref val i))))
			   (t (format stream "~a" (aref val i)))))
		       (if* (< 5 (length val))
			  then (princ "...>" stream)
			  else (princ ">" stream)))
	     ((array cons)
	      (let ((*print-length* 5))
		(format stream "~s" val)))
	     (t (format stream "~s"  val))))
         (if* (cdr accessors)
	    then (write-char #\space stream))))))







 
