/*
 * Decompiled with CFR 0.152.
 */
package com.franz.ag;

import com.franz.ag.AllegroGraphConnection;
import com.franz.ag.AllegroGraphException;
import com.franz.ag.BlankNode;
import com.franz.ag.Cursor;
import com.franz.ag.EncodedLiteral;
import com.franz.ag.GeoExtension;
import com.franz.ag.Literal;
import com.franz.ag.NamespaceRegistry;
import com.franz.ag.Node;
import com.franz.ag.SNAExtension;
import com.franz.ag.Triple;
import com.franz.ag.UPI;
import com.franz.ag.ValueNode;
import com.franz.ag.ValueObject;
import com.franz.ag.impl.AGFactory;
import com.franz.ag.impl.CursorImpl;
import com.franz.ag.impl.LiteralImpl;
import com.franz.ag.impl.NodeImpl;
import com.franz.ag.impl.ResourceNodeImpl;
import com.franz.ag.impl.TripleImpl;
import com.franz.ag.impl.ValueNodeImpl;
import com.franz.ag.util.AGInner;
import com.franz.agbase.AllegroGraphBuilder;
import com.franz.agbase.LiteralNode;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.util.AGBase;
import com.franz.agbase.util.AGInternals;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class AllegroGraph
extends AGInner
implements ValueFactory {
    private static final String version = "3.1UserSept30";
    private static String[] versionLabels = new String[]{"AllegroGraph Version ", "      protocol level "};
    private static String xsiPrefix = "http://www.w3.org/2001/XMLSchema#";
    private URI[] xsiCache = new URI[]{null, null, null, null, null, null, null};
    private static final int XS_BOOLEAN = 0;
    private static final int XS_BYTE = 1;
    private static final int XS_SHORT = 2;
    private static final int XS_INT = 3;
    private static final int XS_LONG = 4;
    private static final int XS_FLOAT = 5;
    private static final int XS_DOUBLE = 6;
    private SNAExtension sna = null;
    private GeoExtension geo = null;

    public static String version() {
        return version;
    }

    public static String[] versions() {
        return new String[]{version, "7"};
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = AllegroGraph.versions();
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println(versionLabels[i] + stringArray2[i]);
        }
    }

    public void setLookAhead(int n) {
        if (n <= -1) {
            throw new IllegalArgumentException("setLookAhead cannot be negative " + n);
        }
        this.defaultLookAhead = n;
    }

    public int getLookAhead() {
        return this.defaultLookAhead;
    }

    AllegroGraph(AllegroGraphConnection allegroGraphConnection, String string, String string2, String string3) throws AllegroGraphException {
        this.agbase = new AllegroGraphBuilder(allegroGraphConnection.baseConn, string, string2, string3);
        this.ags = allegroGraphConnection;
        this.storeName = string2;
        this.storeDirectory = string3;
        this.tsx = this.agbase.tsx;
    }

    void connect(AllegroGraphConnection allegroGraphConnection, String string) throws AllegroGraphException {
        this.agbase.connect(allegroGraphConnection.baseConn, string);
        this.ags = allegroGraphConnection;
        this.tsx = this.agbase.tsx;
    }

    public synchronized void setAttribute(StoreAttribute storeAttribute, Object object) {
        if (this.tsx > -1) {
            throw new IllegalStateException("Allready connected");
        }
        if (this.tsx < -1) {
            throw new IllegalStateException("Closed triple store");
        }
        this.agbase.setAttribute(storeAttribute.value(), object);
    }

    public synchronized void setAttribute(String string, Object object) {
        if (this.tsx > -1) {
            throw new IllegalStateException("Allready connected");
        }
        if (this.tsx < -1) {
            throw new IllegalStateException("Closed triple store");
        }
        this.agbase.setAttribute(string, object);
    }

    public void syncTripleStore() throws AllegroGraphException {
        this.verifyEnabled().syncTripleStore(this);
    }

    public synchronized boolean closeTripleStore() throws AllegroGraphException {
        return this.closeTripleStore(true);
    }

    public synchronized boolean closeTripleStore(boolean bl) throws AllegroGraphException {
        boolean bl2 = this.agbase.closeTripleStore(bl);
        this.tsx = -2;
        return bl2;
    }

    public long loadNTriples(String string) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, string, null, null, null, null, null);
    }

    public long loadNTriples(String string, Object object) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, string, this.ntripleContext(object), null, null, null, null);
    }

    public long loadNTriples(String[] stringArray) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, stringArray, null, null, null, null, null);
    }

    public long loadNTriples(String[] stringArray, Object object) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, stringArray, this.ntripleContext(object), null, null, null, null);
    }

    public long loadNTriples(Object object, Object object2, Boolean bl, String string, Object[] objectArray) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, object, this.ntripleContext(object2), null, objectArray, bl, string);
    }

    public long parseNTriples(String string) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, null, null, string, null, null, null);
    }

    public long parseNTriples(String string, Object object) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, null, this.ntripleContext(object), string, null, null, null);
    }

    public long parseNTriples(String string, Object object, Boolean bl, Object[] objectArray) throws AllegroGraphException {
        return this.verifyEnabled().loadNTriples(this, null, this.ntripleContext(object), string, objectArray, bl, null);
    }

    public long loadRDF(String string) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, string, null, null, false);
    }

    public long loadRDF(String string, Object object) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, string, this.ntripleContext(object), null, false);
    }

    public long loadRDF(String string, Object object, String string2) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, string, this.ntripleContext(object), string2, false);
    }

    public long loadRDF(String[] stringArray) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, stringArray, null, null, false);
    }

    public long loadRDF(String[] stringArray, Object object, String string) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, stringArray, this.ntripleContext(object), string, false);
    }

    public long loadRDF(String[] stringArray, Object object, String string, boolean bl) throws AllegroGraphException {
        return this.verifyEnabled().loadRDF(this, stringArray, this.ntripleContext(object), string, bl);
    }

    public long numberOfTriples() throws AllegroGraphException {
        return this.verifyEnabled().numberOfTriples(this);
    }

    public void indexNewTriples() throws AllegroGraphException {
        try {
            this.verifyEnabled().indexTriples(this, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.throwIndexError(illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public void indexNewTriples(boolean bl) throws AllegroGraphException {
        try {
            this.verifyEnabled().indexTriples(this, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.throwIndexError(illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    void throwIndexError(Throwable throwable) throws AllegroGraphException {
        String string = throwable.toString();
        if (-1 == string.indexOf("too-many-index-chunks-error ")) {
            return;
        }
        String string2 = " will create ";
        int n = string.indexOf(string2);
        if (n == -1) {
            return;
        }
        int n2 = string.indexOf(" ", n + string2.length());
        if (n2 == -1) {
            return;
        }
        throw new AllegroGraphException("too-many-index-chunks-error: " + string.substring(n, n2) + " files");
    }

    public void indexAllTriples() throws AllegroGraphException {
        try {
            this.verifyEnabled().indexAll(this, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.throwIndexError(illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public void indexAllTriples(boolean bl) throws AllegroGraphException {
        try {
            this.verifyEnabled().indexAll(this, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.throwIndexError(illegalArgumentException);
            throw illegalArgumentException;
        }
    }

    public ValueObject newValue(UPI uPI) {
        ValueObject valueObject = null;
        if (!UPIImpl.canReference(uPI)) {
            throw new IllegalStateException("AllegroGraph Id cannot be registered:" + uPI);
        }
        try {
            Object[] objectArray = this.verifyEnabled().getParts(this, uPI);
            valueObject = this.newValue(uPI, (Integer)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
        }
        catch (AllegroGraphException allegroGraphException) {
            this.failCreate("ValueObject", allegroGraphException);
        }
        if (valueObject == null) {
            this.failCreate("ValueObject", null);
        }
        return valueObject;
    }

    void failCreate(String string, Throwable throwable) {
        throw new IllegalStateException("Cannot create " + string + " -- " + throwable);
    }

    public String[] getParts(UPI uPI) throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().getParts(this, uPI);
        return new String[]{this.typeToString((Integer)objectArray[0]), (String)objectArray[1], (String)objectArray[2]};
    }

    public UPIImpl[] getTripleParts(long l) throws AllegroGraphException {
        UPIImpl[] uPIImplArray = this.verifyEnabled().getTripleParts(this, l);
        if (uPIImplArray == null) {
            throw new AllegroGraphException("Id is not a triple: " + l);
        }
        return uPIImplArray;
    }

    public void getParts(UPI[] uPIArray, String[] stringArray, String[] stringArray2, String[] stringArray3) throws AllegroGraphException {
        int[] nArray = new int[uPIArray.length];
        this.verifyEnabled().getParts(this, uPIArray, nArray, stringArray2, stringArray3);
        for (int i = 0; i < uPIArray.length; ++i) {
            stringArray[i] = this.typeToString(nArray[i]);
        }
    }

    public int getSelectLimit() {
        return this.selectLimit;
    }

    public void setSelectLimit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("setSelectLimit argument must be non-negative.");
        }
        this.selectLimit = n;
    }

    public BNode createBNode() {
        return this.createBNode(null);
    }

    public BNode createBNode(String string) {
        BlankNode blankNode = null;
        AllegroGraphException allegroGraphException = null;
        if (string == null) {
            string = "";
        }
        try {
            blankNode = AGFactory.makeBlankNode(this, this.verifyEnabled().newBlankNode(this, string), string);
        }
        catch (AllegroGraphException allegroGraphException2) {
            allegroGraphException = allegroGraphException2;
        }
        if (blankNode == null) {
            this.failCreate("BlankNode", allegroGraphException);
        }
        return blankNode;
    }

    public BlankNode[] createBNodes(int n) throws AllegroGraphException {
        UPIImpl[] uPIImplArray = this.verifyEnabled().newBlankNodes(this, n);
        BlankNode[] blankNodeArray = new BlankNode[n];
        for (int i = 0; i < n; ++i) {
            blankNodeArray[i] = AGFactory.makeBlankNode(this, uPIImplArray[i], null);
        }
        return blankNodeArray;
    }

    public EncodedLiteral createEncodedLiteral(long l, String string) {
        return AGFactory.makeEncodedLiteral(this, l, string);
    }

    public EncodedLiteral createEncodedLiteral(double d, String string) {
        return AGFactory.makeEncodedLiteral(this, d, string);
    }

    public EncodedLiteral createEncodedLiteral(String string, String string2) {
        return AGFactory.makeEncodedLiteral(this, string, string2);
    }

    public org.openrdf.model.Literal createLiteral(String string) {
        return AGFactory.makeLiteral(this, null, string, null, null, LiteralImpl.LANG_NONE, null);
    }

    public org.openrdf.model.Literal addLiteral(String string) {
        return (org.openrdf.model.Literal)((Object)CursorImpl.newValueNode(this, this.agbase.addLiteral(string)));
    }

    public org.openrdf.model.Literal createLiteral(String string, String string2) {
        return AGFactory.makeLiteral(this, null, string, null, null, LiteralImpl.LANG_KNOWN, string2);
    }

    public org.openrdf.model.Literal addLiteral(String string, String string2) {
        return (org.openrdf.model.Literal)((Object)CursorImpl.newValueNode(this, this.agbase.addLiteral(string, string2)));
    }

    public org.openrdf.model.Literal createTypedLiteral(String string, String string2) {
        return AGFactory.makeLiteral(this, null, string, null, string2, LiteralImpl.LANG_NONE, null);
    }

    public org.openrdf.model.Literal addTypedLiteral(String string, String string2) {
        Literal literal = null;
        AllegroGraphException allegroGraphException = null;
        try {
            UPIImpl uPIImpl = this.verifyEnabled().newLiteral((AGBase)this, string, string2, null);
            literal = AGFactory.makeLiteral(this, uPIImpl, string, null, string2, LiteralImpl.LANG_NONE, null);
        }
        catch (AllegroGraphException allegroGraphException2) {
            allegroGraphException = allegroGraphException2;
        }
        if (literal == null) {
            this.failCreate("typedLiteral", allegroGraphException);
        }
        return literal;
    }

    public org.openrdf.model.Literal createTypedLiteral(String string, UPIImpl uPIImpl) {
        return AGFactory.makeLiteral(this, null, string, uPIImpl, null, LiteralImpl.LANG_NONE, null);
    }

    public org.openrdf.model.Literal addTypedLiteral(String string, UPI uPI) {
        Literal literal = null;
        AllegroGraphException allegroGraphException = null;
        try {
            UPIImpl uPIImpl = this.verifyEnabled().newLiteral((AGBase)this, string, uPI, null);
            literal = AGFactory.makeLiteral(this, uPIImpl, string, uPI, null, LiteralImpl.LANG_NONE, null);
        }
        catch (AllegroGraphException allegroGraphException2) {
            allegroGraphException = allegroGraphException2;
        }
        if (literal == null) {
            this.failCreate("typedLiteral", allegroGraphException);
        }
        return literal;
    }

    public org.openrdf.model.Literal addTypedLiteral(String string, URI uRI) {
        UPI uPI;
        if (uRI instanceof NodeImpl && (uPI = ((NodeImpl)uRI).queryAGId()) != null) {
            return this.addTypedLiteral(string, uPI);
        }
        return this.addTypedLiteral(string, uRI.toString());
    }

    public org.openrdf.model.Literal createLiteral(String string, URI uRI) {
        NodeImpl nodeImpl;
        UPI uPI;
        if (uRI instanceof NodeImpl && UPIImpl.canReference(uPI = (nodeImpl = (NodeImpl)uRI).queryAGId())) {
            return AGFactory.makeLiteral(this, null, string, uPI, nodeImpl.queryURI(), LiteralImpl.LANG_NONE, null);
        }
        return AGFactory.makeLiteral(this, null, string, null, uRI.toString(), LiteralImpl.LANG_NONE, null);
    }

    public org.openrdf.model.Literal addLiteral(String string, URI uRI) {
        return (org.openrdf.model.Literal)((Object)CursorImpl.newValueNode(this, this.agbase.addTypedLiteral(string, uRI.getURI())));
    }

    public org.openrdf.model.Literal[] addLiterals(String[] stringArray, String[] stringArray2, String[] stringArray3) throws AllegroGraphException {
        LiteralNode[] literalNodeArray = this.agbase.addLiterals(stringArray, stringArray2, stringArray3);
        org.openrdf.model.Literal[] literalArray = new org.openrdf.model.Literal[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            literalArray[i] = (org.openrdf.model.Literal)((Object)CursorImpl.newValueNode(this, literalNodeArray[i]));
        }
        return literalArray;
    }

    public URI createURI(String string) {
        return AGFactory.makeNode(this, null, string);
    }

    public Node addURI(String string) throws AllegroGraphException {
        return AGFactory.makeNode(this, this.verifyEnabled().newResource(this, string), string);
    }

    public UPI[] addURIIds(String[] stringArray) throws AllegroGraphException {
        return this.verifyEnabled().newResources(this, stringArray);
    }

    public URI[] addURIs(String[] stringArray) throws AllegroGraphException {
        URI[] uRIArray = new URI[stringArray.length];
        UPIImpl[] uPIImplArray = this.verifyEnabled().newResources(this, stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            uRIArray[i] = AGFactory.makeNode(this, uPIImplArray[i], stringArray[i]);
        }
        return uRIArray;
    }

    public URI createURI(String string, String string2) {
        return this.createURI(string + string2);
    }

    public Cursor getStatements(Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.agCursor(this.verifyEnabled().getTriples(this.agbase, AllegroGraph.validRefOrWild(object), AllegroGraph.validRefOrWild(object2), AllegroGraph.validRefOrWild(object3), UPIImpl.nullUPI(), this.defaultLookAhead));
    }

    public Cursor getStatements(boolean bl, Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.agCursor(this.verifyEnabled().getInfTriples(this.agbase, AllegroGraph.validRefOrWild(object), AllegroGraph.validRefOrWild(object2), AllegroGraph.validRefOrWild(object3), UPIImpl.nullUPI(), this.defaultLookAhead, bl));
    }

    public Cursor getStatements(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        return this.agCursor(this.verifyEnabled().getTriples(this.agbase, AllegroGraph.validRefOrWild(object), AllegroGraph.validRefOrWild(object2), AllegroGraph.validRefOrWild(object3), AllegroGraph.anyContextRef(object4, 3), this.defaultLookAhead));
    }

    public Cursor getStatements(boolean bl, Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        return this.agCursor(this.verifyEnabled().getInfTriples(this.agbase, AllegroGraph.validRefOrWild(object), AllegroGraph.validRefOrWild(object2), AllegroGraph.validRefOrWild(object3), AllegroGraph.anyContextRef(object4, 3), this.defaultLookAhead, bl));
    }

    public Cursor getStatements(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws AllegroGraphException {
        return this.agCursor(this.verifyEnabled().getTriples(this.agbase, AllegroGraph.validRangeRef(object), AllegroGraph.validRangeRef(object2), AllegroGraph.validRangeRef(object3), AllegroGraph.anyContextRef(object5, 5), null, null, AllegroGraph.validRangeRef(object4), AllegroGraph.anyContextRef(object6, 6), this.defaultLookAhead));
    }

    public Cursor getStatements(boolean bl, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) throws AllegroGraphException {
        return this.agCursor(this.verifyEnabled().getInfTriples(this.agbase, AllegroGraph.validRangeRef(object), AllegroGraph.validRangeRef(object2), AllegroGraph.validRangeRef(object3), AllegroGraph.anyContextRef(object5, 5), null, null, AllegroGraph.validRangeRef(object4), AllegroGraph.anyContextRef(object6, 6), this.defaultLookAhead, bl));
    }

    public Cursor getStatements(boolean bl, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) throws AllegroGraphException {
        return this.agCursor(this.verifyEnabled().getInfTriples(this.agbase, AllegroGraph.validRangeRef(object), AllegroGraph.validRangeRef(object3), AllegroGraph.validRangeRef(object5), AllegroGraph.anyContextRef(object7, 5), AllegroGraph.validRangeRef(object2), AllegroGraph.validRangeRef(object4), AllegroGraph.validRangeRef(object6), AllegroGraph.anyContextRef(object8, 6), this.defaultLookAhead, bl));
    }

    public boolean hasStatement(Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.hasStatement(object, object2, object3, (Object)"");
    }

    public boolean hasStatement(boolean bl, Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.hasStatement(bl, object, object2, object3, "");
    }

    public boolean hasStatement(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        return this.verifyEnabled().hasTriple(this, AllegroGraph.validRefOrWild(object), AllegroGraph.validRefOrWild(object2), AllegroGraph.validRefOrWild(object3), AllegroGraph.anyContextRef(object4, 3));
    }

    public boolean hasStatement(boolean bl, Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        return this.verifyEnabled().hasInfTriple(this, AllegroGraph.validRefOrWild(object), AllegroGraph.validRefOrWild(object2), AllegroGraph.validRefOrWild(object3), AllegroGraph.anyContextRef(object4, 3), bl);
    }

    public void addStatement(Object object, Object object2, Object object3) throws AllegroGraphException {
        this.addStatement(object, object2, object3, null);
    }

    public void addStatement(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        this.verifyEnabled().addTriple(this, this.validRef(object), this.validRef(object2), this.validRef(object3), AllegroGraph.anyContextRef(object4, 1));
    }

    public void addStatements(Object object, Object object2, Object object3) throws AllegroGraphException {
        this.addStatements(object, object2, object3, null);
    }

    public void addStatements(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        try {
            this.verifyEnabled().addTriples(this, this.validRefs(object), this.validRefs(object2), this.validRefs(object3), this.anyContextRefs(object4, 1));
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new AllegroGraphException(allegroGraphException);
        }
    }

    public void clear() throws AllegroGraphException {
        try {
            this.verifyEnabled().delete(this, UPIImpl.wildUPI(), UPIImpl.wildUPI(), UPIImpl.wildUPI(), UPIImpl.wildUPI(), true);
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new AllegroGraphException(allegroGraphException);
        }
    }

    private synchronized URI getDataType(int n) {
        if (this.xsiCache[n] == null) {
            String string = "";
            switch (n) {
                case 0: {
                    string = "boolean";
                    break;
                }
                case 1: {
                    string = "byte";
                    break;
                }
                case 2: {
                    string = "short";
                    break;
                }
                case 3: {
                    string = "int";
                    break;
                }
                case 4: {
                    string = "long";
                    break;
                }
                case 5: {
                    string = "float";
                    break;
                }
                case 6: {
                    string = "double";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("bad Schema type index");
                }
            }
            this.xsiCache[n] = this.createURI(xsiPrefix, string);
        }
        return this.xsiCache[n];
    }

    public org.openrdf.model.Literal createLiteral(boolean bl) {
        return this.createLiteral(Boolean.toString(bl), this.getDataType(0));
    }

    public org.openrdf.model.Literal addLiteral(boolean bl) {
        return this.addLiteral(Boolean.toString(bl), this.getDataType(0));
    }

    public org.openrdf.model.Literal createLiteral(long l) {
        return this.createLiteral(Long.toString(l), this.getDataType(4));
    }

    public org.openrdf.model.Literal addLiteral(long l) {
        return this.addLiteral(Long.toString(l), this.getDataType(4));
    }

    public org.openrdf.model.Literal createLiteral(int n) {
        return this.createLiteral(Integer.toString(n), this.getDataType(3));
    }

    public org.openrdf.model.Literal addLiteral(int n) {
        return this.addLiteral(Integer.toString(n), this.getDataType(3));
    }

    public org.openrdf.model.Literal createLiteral(short s) {
        return this.createLiteral(Short.toString(s), this.getDataType(2));
    }

    public org.openrdf.model.Literal addLiteral(short s) {
        return this.addLiteral(Short.toString(s), this.getDataType(2));
    }

    public org.openrdf.model.Literal createLiteral(byte by) {
        return this.createLiteral(Byte.toString(by), this.getDataType(1));
    }

    public org.openrdf.model.Literal addLiteral(byte by) {
        return this.addLiteral(Byte.toString(by), this.getDataType(1));
    }

    public org.openrdf.model.Literal createLiteral(double d) {
        return this.createLiteral(Double.toString(d), this.getDataType(6));
    }

    public org.openrdf.model.Literal addLiteral(double d) {
        return this.addLiteral(Double.toString(d), this.getDataType(6));
    }

    public org.openrdf.model.Literal createLiteral(float f) {
        return this.createLiteral(Float.toString(f), this.getDataType(5));
    }

    public org.openrdf.model.Literal addLiteral(float f) {
        return this.addLiteral(Float.toString(f), this.getDataType(5));
    }

    public Statement createStatement(Resource resource, URI uRI, Value value, Resource resource2) {
        UPI uPI = null;
        if (resource instanceof ResourceNodeImpl) {
            uPI = this.queryAGId((ResourceNodeImpl)resource);
        }
        UPI uPI2 = null;
        if (uRI instanceof NodeImpl) {
            uPI2 = this.queryAGId((NodeImpl)uRI);
        }
        UPI uPI3 = null;
        if (value instanceof ValueNodeImpl) {
            uPI3 = this.queryAGId((ValueNode)value);
        }
        UPI uPI4 = UPIImpl.nullUPI();
        if (resource2 instanceof NodeImpl) {
            uPI4 = this.queryAGId((NodeImpl)resource2);
        }
        TripleImpl tripleImpl = (TripleImpl)AGFactory.makeTriple(this, uPI, uPI2, uPI3, uPI4);
        tripleImpl.subjInstance = resource;
        tripleImpl.predInstance = uRI;
        tripleImpl.objInstance = value;
        return tripleImpl;
    }

    public Cursor selectStatements(String string) throws AllegroGraphException {
        return this.agCursor(this.verifyEnabled().selectTriples(this.agbase, string, null, null, this.selectLimit, false, false));
    }

    public Cursor selectStatements(String string, Object object) throws AllegroGraphException {
        return this.agCursor(this.verifyEnabled().selectTriples(this.agbase, string, this.validRefs(object), null, this.selectLimit, false, false));
    }

    public Triple newTriple(Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.newTriple(object, object2, object3, null);
    }

    public long newTripleId(Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.newTripleId(object, object2, object3, null);
    }

    public Triple newTriple(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().addTriple(this, this.validRef(object), this.validRef(object2), this.validRef(object3), AllegroGraph.anyContextRef(object4, 1));
        Triple triple = AGFactory.makeTriple(this, (Long)objectArray[0], (UPIImpl)objectArray[1], (UPIImpl)objectArray[2], (UPIImpl)objectArray[3], (UPIImpl)objectArray[4]);
        return triple;
    }

    public long newTripleId(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().addTriple(this, this.validRef(object), this.validRef(object2), this.validRef(object3), AllegroGraph.anyContextRef(object4, 1));
        return (Long)objectArray[0];
    }

    public Triple[] newTriples(Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.newTriples(object, object2, object3, null);
    }

    public Triple[] newTriples(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().addTriples(this, this.validRefs(object), this.validRefs(object2), this.validRefs(object3), this.anyContextRefs(object4, 1));
        long[] lArray = (long[])objectArray[0];
        UPI[] uPIArray = (UPI[])objectArray[1];
        UPI[] uPIArray2 = (UPI[])objectArray[2];
        UPI[] uPIArray3 = (UPI[])objectArray[3];
        Triple[] tripleArray = new Triple[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            Triple triple;
            tripleArray[i] = triple = AGFactory.makeTriple(this, lArray[i], uPIArray[i], uPIArray2[i], uPIArray3[i]);
        }
        return tripleArray;
    }

    public long[] newTripleIds(Object object, Object object2, Object object3) throws AllegroGraphException {
        return this.newTripleIds(object, object2, object3, null);
    }

    public long[] newTripleIds(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().addTriples(this, this.validRefs(object), this.validRefs(object2), this.validRefs(object3), this.anyContextRefs(object4, 1));
        return (long[])objectArray[0];
    }

    public void removeStatements(Object object, Object object2, Object object3) throws AllegroGraphException {
        this.removeStatements(object, object2, object3, UPIImpl.nullUPI());
    }

    public void removeStatements(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        this.verifyEnabled().delete(this, AllegroGraph.validRefOrWild(object), AllegroGraph.validRefOrWild(object2), AllegroGraph.validRefOrWild(object3), AllegroGraph.anyContextRef(object4, 3), true);
    }

    public Cursor selectStatements(String string, Object object, String string2) throws AllegroGraphException {
        return this.agCursor(this.verifyEnabled().selectTriples(this.agbase, string, this.validRefs(object), string2, this.selectLimit, false, false));
    }

    public Cursor selectStatements(boolean bl, boolean bl2, String string, Object object, String string2) throws AllegroGraphException {
        return this.agCursor(this.verifyEnabled().selectTriples(this.agbase, string, this.validRefs(object), string2, this.selectLimit, bl, bl2));
    }

    public UPI[] createBNodeIds(int n) throws AllegroGraphException {
        return this.verifyEnabled().newBlankNodes(this, n);
    }

    public void removeStatement(Object object, Object object2, Object object3) throws AllegroGraphException {
        this.removeStatement(object, object2, object3, UPIImpl.nullUPI());
    }

    public void removeStatement(Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        this.verifyEnabled().delete(this, this.validRef(object), this.validRef(object2), this.validRef(object3), AllegroGraph.anyContextRef(object4, 1), false);
    }

    public UPI[] addLiteralIds(String[] stringArray, String[] stringArray2, String[] stringArray3) throws AllegroGraphException {
        return this.agbase.addLiteralIds(stringArray, stringArray2, stringArray3);
    }

    public ValueObject[][] selectValues(String string, Object[] objectArray, String string2) throws AllegroGraphException {
        Object[] objectArray2 = this.verifyEnabled().selectValues(this, string, objectArray, string2, false, false);
        return (ValueObject[][])this.selectValuesArray(false, objectArray2, false);
    }

    public ValueObject[][] selectValues(boolean bl, boolean bl2, String string, Object[] objectArray, String string2) throws AllegroGraphException {
        Object[] objectArray2 = this.verifyEnabled().selectValues(this, string, objectArray, string2, bl, bl2);
        return (ValueObject[][])this.selectValuesArray(false, objectArray2, false);
    }

    public ValueObject[] selectSingleValues(String string, Object[] objectArray, String string2) throws AllegroGraphException {
        Object[] objectArray2 = this.verifyEnabled().selectValues(this, string, objectArray, string2, false, false);
        return (ValueObject[])this.selectValuesArray(true, objectArray2, false);
    }

    public ValueObject[] selectSingleValues(boolean bl, boolean bl2, String string, Object[] objectArray, String string2) throws AllegroGraphException {
        Object[] objectArray2 = this.verifyEnabled().selectValues(this, string, objectArray, string2, bl, bl2);
        return (ValueObject[])this.selectValuesArray(true, objectArray2, false);
    }

    public ValueObject[] getFreetextUniqueSubjects(String string) throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().getFreetextSubjects(this, string, this.selectLimit);
        return (ValueObject[])this.selectValuesArray(true, objectArray, false);
    }

    public Cursor getFreetextStatements(String string) throws AllegroGraphException {
        return this.agCursor(this.verifyEnabled().getFreetextStatements(this.agbase, string, this.defaultLookAhead));
    }

    public String[] getFreetextPredicates() throws AllegroGraphException {
        return this.verifyEnabled().freetextPredicates(this, null);
    }

    public void registerFreetextPredicate(Object object) throws AllegroGraphException {
        this.verifyEnabled().freetextPredicates(this, this.validRefs(object));
    }

    Object selectValuesArray(boolean bl, Object[] objectArray, boolean bl2) throws AllegroGraphException {
        if (objectArray == null) {
            if (bl) {
                return new ValueObject[0];
            }
            return new ValueObject[0][0];
        }
        UPIImpl[] uPIImplArray = (UPIImpl[])objectArray[0];
        if (uPIImplArray == null) {
            if (bl) {
                return new ValueObject[0];
            }
            return new ValueObject[0][0];
        }
        int[] nArray = (int[])objectArray[1];
        String[] stringArray = (String[])objectArray[2];
        String[] stringArray2 = (String[])objectArray[3];
        int n = (Integer)objectArray[4];
        int n2 = (Integer)objectArray[5];
        if (bl && n2 != 1) {
            throw new IllegalArgumentException("Asked for single result but received " + n2);
        }
        Object object = objectArray[6];
        int n3 = (Integer)objectArray[7];
        int n4 = uPIImplArray.length;
        Object object2 = null;
        if (8 < objectArray.length) {
            object2 = objectArray[8];
        }
        if (bl) {
            ValueObject[] valueObjectArray = new ValueObject[n4];
            for (int i = 0; i < n4; ++i) {
                valueObjectArray[i] = this.newSelectValue(bl2, uPIImplArray[i], nArray[i], stringArray[i], stringArray2[i]);
            }
            return this.registerValues(valueObjectArray, object, n, n3, object2, bl2);
        }
        if (n2 == 0) {
            ValueObject[][] valueObjectArray = new ValueObject[n4][0];
            return this.registerValues(valueObjectArray, object, n, n3, object2, bl2);
        }
        int n5 = n4 / n2;
        int n6 = 0;
        int n7 = 0;
        ValueObject[][] valueObjectArray = new ValueObject[n5][n2];
        while (n6 < n4) {
            for (int i = 0; i < n2; ++i) {
                valueObjectArray[n7][i] = this.newSelectValue(bl2, uPIImplArray[n6], nArray[n6], stringArray[n6], stringArray2[n6]);
                ++n6;
            }
            ++n7;
        }
        return this.registerValues(valueObjectArray, object, n, n3, object2, bl2);
    }

    private ValueObject newSelectValue(boolean bl, UPIImpl uPIImpl, int n, String string, String string2) {
        if (n > 0) {
            return this.newValue(uPIImpl, n, string, string2);
        }
        if (bl) {
            return null;
        }
        throw new IllegalArgumentException("Unknown node type " + n + "  " + string + "  " + string2);
    }

    Object registerValues(Object object, Object object2, int n, int n2, Object object3, boolean bl) throws AllegroGraphException {
        if (n > 0 || object3 != null) {
            this.ags.valueMap.put(object, new AGInner.valueMapEntry(this, object2, n, n2, object3, bl));
        }
        this.discardOldTokens(false);
        return object;
    }

    public ValueObject[][] selectValues(String string) throws AllegroGraphException {
        return this.selectValues(false, false, string, new Object[0], "");
    }

    public ValueObject[][] selectValues(boolean bl, boolean bl2, String string) throws AllegroGraphException {
        return this.selectValues(bl, bl2, string, new Object[0], "");
    }

    public int valuesLength(ValueObject[][] valueObjectArray) {
        return valueObjectArray.length;
    }

    public int moreValues(Object object) {
        AGInner.valueMapEntry valueMapEntry2 = (AGInner.valueMapEntry)this.ags.valueMap.get(object);
        if (valueMapEntry2 == null) {
            return 0;
        }
        if (valueMapEntry2.savedMore > valueMapEntry2.savedPlimit) {
            return -valueMapEntry2.savedMore;
        }
        return valueMapEntry2.savedMore;
    }

    public String[] valueNames(Object object) {
        AGInner.valueMapEntry valueMapEntry2 = (AGInner.valueMapEntry)this.ags.valueMap.get(object);
        if (valueMapEntry2 == null) {
            return new String[0];
        }
        Object object2 = valueMapEntry2.savedVal;
        if (object2 == null) {
            return new String[0];
        }
        if (object2 instanceof String[]) {
            return (String[])object2;
        }
        return new String[0];
    }

    public ValueObject[][] selectMore(ValueObject[][] valueObjectArray) throws AllegroGraphException {
        return (ValueObject[][])this.selectMoreInternal(false, valueObjectArray);
    }

    public ValueObject[] selectMore(ValueObject[] valueObjectArray) throws AllegroGraphException {
        return (ValueObject[])this.selectMoreInternal(true, valueObjectArray);
    }

    private Object selectNull(boolean bl) {
        if (bl) {
            return new ValueObject[0];
        }
        return new ValueObject[0][0];
    }

    Object selectMoreInternal(boolean bl, Object object) throws AllegroGraphException {
        ValueObject[][] valueObjectArray;
        AGInner.valueMapEntry valueMapEntry2 = (AGInner.valueMapEntry)this.ags.valueMap.get(object);
        if (valueMapEntry2 == null) {
            return this.selectNull(bl);
        }
        String string = (String)valueMapEntry2.savedToken;
        boolean bl2 = valueMapEntry2.savedNullOk;
        Object[] objectArray = this.verifyEnabled().nextValuesArray(this, string, this.selectLimit);
        if (objectArray == null) {
            return this.selectNull(bl);
        }
        UPIImpl[] uPIImplArray = (UPIImpl[])objectArray[0];
        int[] nArray = (int[])objectArray[1];
        String[] stringArray = (String[])objectArray[2];
        String[] stringArray2 = (String[])objectArray[3];
        int n = (Integer)objectArray[4];
        int n2 = (Integer)objectArray[5];
        String string2 = (String)objectArray[6];
        int n3 = (Integer)objectArray[7];
        int n4 = uPIImplArray.length;
        int n5 = 0;
        if (n > 0) {
            valueMapEntry2.savedToken = string2;
            valueMapEntry2.savedMore = n;
            valueMapEntry2.savedPlimit = n3;
        } else {
            this.ags.valueMap.remove(object);
        }
        if (bl && n2 == 1) {
            ValueObject[] valueObjectArray2 = (ValueObject[])object;
            if (n4 == valueObjectArray2.length) {
                for (int i = 0; i < n4; ++i) {
                    valueObjectArray2[i] = this.newSelectValue(bl2, uPIImplArray[i], nArray[i], stringArray[i], stringArray2[i]);
                }
                return valueObjectArray2;
            }
            int n6 = n4 / n2;
            ValueObject[] valueObjectArray3 = new ValueObject[n6];
            for (n5 = 0; n5 < n4; ++n5) {
                valueObjectArray3[n5] = this.newSelectValue(bl2, uPIImplArray[n5], nArray[n5], stringArray[n5], stringArray2[n5]);
            }
            if (n > 0) {
                this.ags.valueMap.remove(object);
                this.ags.valueMap.put(valueObjectArray3, valueMapEntry2);
            }
            this.discardOldTokens(false);
            return valueObjectArray3;
        }
        ValueObject[][] valueObjectArray4 = (ValueObject[][])object;
        if (n4 == n2 * valueObjectArray4.length) {
            for (int i = 0; i < valueObjectArray4.length; ++i) {
                ValueObject[] valueObjectArray5 = new ValueObject[n2];
                for (int j = 0; j < n2; ++j) {
                    valueObjectArray5[j] = this.newSelectValue(bl2, uPIImplArray[n5], nArray[n5], stringArray[n5], stringArray2[n5]);
                    ++n5;
                }
                valueObjectArray4[i] = valueObjectArray5;
            }
            return valueObjectArray4;
        }
        if (n2 == 0) {
            valueObjectArray = new ValueObject[n4][0];
        } else {
            int n7 = 0;
            n7 = n4 / n2;
            n5 = 0;
            int n8 = 0;
            valueObjectArray = new ValueObject[n7][n2];
            while (n5 < n4) {
                for (int i = 0; i < n2; ++i) {
                    valueObjectArray[n8][i] = this.newSelectValue(bl2, uPIImplArray[n5], nArray[n5], stringArray[n5], stringArray2[n5]);
                    ++n5;
                }
                ++n8;
            }
        }
        if (n > 0) {
            this.ags.valueMap.remove(valueObjectArray4);
            this.ags.valueMap.put(valueObjectArray, valueMapEntry2);
        }
        this.discardOldTokens(false);
        return valueObjectArray;
    }

    public boolean twinqlAsk(String string) throws AllegroGraphException {
        return this.verifyEnabled().twinqlAsk(this, string, false);
    }

    public ValueObject[][] twinqlSelect(String string, String string2, int n, int n2) throws AllegroGraphException {
        return this.twinqlSelect(false, string, string2, n, n2);
    }

    public ValueObject[][] twinqlSelect(boolean bl, String string, String string2, int n, int n2) throws AllegroGraphException {
        return this.twinqlSelect(bl, string, string2, n, n2, new Object[0]);
    }

    ValueObject[][] twinqlSelect(boolean bl, String string, String string2, int n, int n2, Object[] objectArray) throws AllegroGraphException {
        Object[] objectArray2 = this.verifyEnabled().twinqlSelect(this, string, string2, n, n2, this.selectLimit, bl, objectArray);
        return (ValueObject[][])this.selectValuesArray(false, objectArray2, true);
    }

    public long twinqlCount(String string, String string2, int n, int n2) throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().twinqlSelect(this, string, string2, n, n2, -1, false);
        return AGConnector.longValue(objectArray[0]);
    }

    public Cursor twinqlFind(String string, int n, int n2) throws AllegroGraphException {
        return this.agCursor(this.verifyEnabled().twinqlFind(this.agbase, string, n, n2, this.selectLimit, false, null));
    }

    private Cursor agCursor(TriplesIterator triplesIterator) {
        return AGFactory.makeCursor(this, triplesIterator);
    }

    public String twinqlQuery(String string, String string2, int n, int n2) throws AllegroGraphException {
        return this.verifyEnabled().twinqlQuery(this, string, string2, n, n2, false);
    }

    public Statement createStatement(Resource resource, URI uRI, Value value) {
        return this.createStatement(resource, uRI, value, null);
    }

    private int intResult(Object object) {
        return AGConnector.toInt(object);
    }

    public int getUnmergedCount() throws AllegroGraphException {
        Object object = this.verifyEnabled().indexing(this, 2, 0, null);
        return this.intResult(object);
    }

    public int getUnindexedTripleCount() throws AllegroGraphException {
        Object object = this.verifyEnabled().indexing(this, 1, 0, null);
        return this.intResult(object);
    }

    public int getUnindexedThreshold() throws AllegroGraphException {
        Object object = this.verifyEnabled().indexing(this, 3, 0, null);
        return this.intResult(object);
    }

    public void setUnindexedThreshold(int n) throws AllegroGraphException {
        this.verifyEnabled().indexing(this, 13, n, null);
    }

    public int getUnmergedThreshold() throws AllegroGraphException {
        Object object = this.verifyEnabled().indexing(this, 4, 0, null);
        return this.intResult(object);
    }

    public void setUnmergedThreshold(int n) throws AllegroGraphException {
        this.verifyEnabled().indexing(this, 14, n, null);
    }

    public String[] getIndexFlavors() throws AllegroGraphException {
        Object object = this.verifyEnabled().indexing(this, 5, 0, null);
        if (object == null) {
            return new String[0];
        }
        return (String[])object;
    }

    public void setIndexFlavors(String[] stringArray) throws AllegroGraphException {
        this.verifyEnabled().indexing(this, 35, 0, stringArray);
    }

    public void addIndexFlavors(String[] stringArray) throws AllegroGraphException {
        this.agbase.addIndexFlavors(stringArray);
    }

    public void dropIndexFlavors(String[] stringArray) throws AllegroGraphException {
        this.verifyEnabled().indexing(this, 25, 0, stringArray);
    }

    public void addDataMapping(String[] stringArray) throws AllegroGraphException {
        this.agbase.addDataMapping(stringArray);
    }

    public void setDataMapping(String[] stringArray) throws AllegroGraphException {
        this.verifyEnabled().mapping(this, 21, stringArray);
    }

    public String[] getDataMapping() throws AllegroGraphException {
        Object object = this.verifyEnabled().mapping(this, 1, null);
        if (object == null) {
            return new String[0];
        }
        if (object instanceof String[]) {
            return (String[])object;
        }
        return new String[0];
    }

    public Object[] evalInServer(String string) throws AllegroGraphException {
        return this.verifyEnabled().evalInServer(this, string);
    }

    public int serverTrace(boolean bl) {
        try {
            this.verifyEnabled().serverTrace(this, bl, null);
            return 0;
        }
        catch (AllegroGraphException allegroGraphException) {
            return -1;
        }
    }

    public int serverTrace(String string) {
        try {
            this.verifyEnabled().serverTrace(this, true, string);
            return 0;
        }
        catch (AllegroGraphException allegroGraphException) {
            return -1;
        }
    }

    public void serverTimers(boolean bl) throws AllegroGraphException {
        this.verifyEnabled().serverTimers(this, bl, true);
    }

    public long[] getTimers() throws AllegroGraphException {
        return this.verifyEnabled().getTimers(this);
    }

    public String[] getNamespaces() {
        return this.agbase.getNamespaces();
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.agbase.getNamespaceRegistry();
    }

    public void registerNamespace(String string, String string2) throws AllegroGraphException {
        this.agbase.registerNamespace(string, string2);
    }

    public void registerNamespaces(String[] stringArray) throws AllegroGraphException {
        this.agbase.registerNamespaces(stringArray);
    }

    public void registerNamespaces(NamespaceRegistry namespaceRegistry) throws AllegroGraphException {
        this.agbase.registerNamespaces(namespaceRegistry);
    }

    public void setNamespaceRegistry(NamespaceRegistry namespaceRegistry) throws AllegroGraphException {
        this.agbase.setNamespaceRegistry(namespaceRegistry);
    }

    public void setNamespaceRegistry() throws AllegroGraphException {
        this.agbase.setNamespaceRegistry();
    }

    public ValueNode addPart(String string) throws AllegroGraphException {
        if (string.startsWith("_:")) {
            return (ValueNode)((Object)this.createBNode(string));
        }
        Object[] objectArray = this.verifyEnabled().addPart(this, AllegroGraph.refNtripleString(string));
        UPIImpl uPIImpl = objectArray[0] instanceof UPIImpl ? (UPIImpl)objectArray[0] : null;
        int n = 0;
        if (1 < objectArray.length) {
            n = (int)AGConnector.longValue(objectArray[1]);
        }
        String string2 = null;
        String string3 = null;
        if (2 < objectArray.length) {
            string2 = (String)objectArray[2];
        }
        if (3 < objectArray.length) {
            string2 = (String)objectArray[3];
        }
        return (ValueNode)this.newValue(uPIImpl, n, string2, string3);
    }

    AllegroGraph(AllegroGraphConnection allegroGraphConnection, String string, AGInner[] aGInnerArray, boolean bl) throws AllegroGraphException {
        AGInternals[] aGInternalsArray = new AGInternals[aGInnerArray.length];
        for (int i = 0; i < aGInnerArray.length; ++i) {
            aGInternalsArray[i] = aGInnerArray[i].agbase;
        }
        this.agbase = new AllegroGraphBuilder(allegroGraphConnection.baseConn, string, aGInternalsArray, bl);
        this.ags = allegroGraphConnection;
        this.storeName = string;
        this.storeDirectory = null;
        this.tsx = this.agbase.tsx;
    }

    AllegroGraph(AllegroGraphConnection allegroGraphConnection, String string, String string2) throws AllegroGraphException {
        this.agbase = new AllegroGraphBuilder(allegroGraphConnection.baseConn, string, string2);
        this.ags = allegroGraphConnection;
        this.tsx = this.agbase.tsx;
        this.storeName = this.agbase.storeName;
        this.storeDirectory = this.agbase.storeDirectory;
    }

    public AllegroGraph(String string) {
        this.agbase = new com.franz.agbase.AllegroGraph(string);
        this.storeName = string;
    }

    AllegroGraph(AGInner aGInner, int n, String string, String string2) {
        this.agbase = new AllegroGraphBuilder(aGInner.agbase, n, string, string2);
        this.ags = aGInner.ags;
        this.storeName = string;
        this.storeDirectory = string2;
        this.tsx = n;
    }

    public AllegroGraph[] getStores() throws AllegroGraphException {
        Object[] objectArray = this.verifyEnabled().getStores(this);
        if (null == objectArray) {
            return null;
        }
        AllegroGraph[] allegroGraphArray = new AllegroGraph[objectArray.length / 3];
        for (int i = 0; i < allegroGraphArray.length; ++i) {
            allegroGraphArray[i] = new AllegroGraph(this, (Integer)objectArray[i * 3], (String)objectArray[1 + i * 3], (String)objectArray[2 + i * 3]);
        }
        return allegroGraphArray;
    }

    public boolean getSyncEveryTime() {
        return this.sync;
    }

    public void setSyncEveryTime(boolean bl) {
        this.sync = bl;
    }

    public String toString() {
        return this.getClass().getName() + "<" + this.tsx + " " + this.storeName + ">";
    }

    public SNAExtension getSNAExtension() {
        if (null == this.sna) {
            this.sna = new SNAExtension(this);
        }
        return this.sna;
    }

    public GeoExtension getGeoExtension() {
        if (null == this.geo) {
            this.geo = new GeoExtension(this);
        }
        return this.geo;
    }

    private Object ntripleContext(Object object) throws AllegroGraphException {
        if (object instanceof String && "source".equalsIgnoreCase((String)object)) {
            return "source";
        }
        return AllegroGraph.anyContextRef(object, 1);
    }

    public void syncDatabase() throws AllegroGraphException {
        this.syncTripleStore();
    }

    public void closeDatabase() throws AllegroGraphException {
        this.closeTripleStore();
    }

    public void indexAll() throws AllegroGraphException {
        this.indexAllTriples();
    }

    public void indexTriples() throws AllegroGraphException {
        this.indexNewTriples();
    }

    public Cursor select(String string) throws AllegroGraphException {
        return this.selectStatements(string);
    }

    public Cursor select(String string, Object object) throws AllegroGraphException {
        return this.selectStatements(string, object);
    }

    public Cursor select(String string, Object object, String string2) throws AllegroGraphException {
        return this.selectStatements(string, object, string2);
    }

    public boolean isSPOGICacheEnabled() throws AllegroGraphException {
        return this.agbase.isSPOGICacheEnabled();
    }

    public void setSPOGICacheEnabled(boolean bl) throws AllegroGraphException {
        this.agbase.setSPOGICacheEnabled(bl);
    }

    public long getSPOGICacheSize() throws AllegroGraphException {
        return this.agbase.getSPOGICacheSize();
    }

    public void setSPOGICacheSize(long l) throws AllegroGraphException {
        this.agbase.setSPOGICacheSize(l);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StoreAttribute {
        EXPECTED_UNIQUE_RESOURCES("expected-unique-resources"),
        WITH_INDICES("with-indices"),
        INCLUDE_STANDARD_PARTS("include-standard-parts"),
        READ_ONLY("read-only"),
        INDIRECT_HOST("indirect-host"),
        INDIRECT_PORT("indirect-port");

        private String value;

        private StoreAttribute(String string2) {
            this.value = string2;
        }

        private String value() {
            return this.value;
        }
    }

    public static class V3_1UserSept30 {
    }
}

