/*
 * Decompiled with CFR 0.152.
 */
package com.franz.ag.repository.test;

import com.franz.ag.repository.AGRepository;
import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.SPARQLQuery;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import org.junit.Ignore;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnectionTest;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class AGRepositoryConnectionTest
extends RepositoryConnectionTest {
    private final String TEST_DIR_PREFIX = System.getProperty("user.dir") + "\\";
    AllegroGraph ts = null;
    AllegroGraphConnection ags = null;
    AGRepository repo = null;

    public AGRepositoryConnectionTest(String string) {
        super(string);
    }

    protected Repository createRepository() throws Exception {
        this.ags = new AllegroGraphConnection();
        this.ags.enable();
        this.ts = this.ags.renew("RepositoryConnectionTestStore", "/tmp/");
        this.repo = new AGRepository(this.ts);
        return this.repo;
    }

    public void testHasStatementWithoutBNodes() throws Exception {
        this.testCon.add((Resource)this.name, this.name, (Value)this.nameBob, new Resource[0]);
        AGRepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statement", (boolean)this.testCon.hasStatement((Resource)this.name, this.name, (Value)this.nameBob, false, new Resource[0]));
    }

    public void testHasStatementWithBNodes() throws Exception {
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        AGRepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statement", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
    }

    public void testAddStatement() throws Exception {
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        AGRepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statement", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        Statement statement = this.vf.createStatement((Resource)this.alice, this.name, (Value)this.nameAlice);
        this.testCon.add(statement, new Resource[0]);
        AGRepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statement", (boolean)this.testCon.hasStatement(statement, false, new Resource[0]));
        AGRepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statement", (boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleTupleQuery() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        stringBuilder.append(" SELECT ?name ?mbox");
        stringBuilder.append(" WHERE { ?x foaf:name ?name .");
        stringBuilder.append("         ?x foaf:mbox ?mbox .}");
        TupleQueryResult tupleQueryResult = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, stringBuilder.toString()).evaluate();
        try {
            AGRepositoryConnectionTest.assertTrue((tupleQueryResult != null ? 1 : 0) != 0);
            AGRepositoryConnectionTest.assertTrue((boolean)tupleQueryResult.hasNext());
            while (tupleQueryResult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tupleQueryResult.next();
                AGRepositoryConnectionTest.assertTrue((boolean)bindingSet.hasBinding("name"));
                AGRepositoryConnectionTest.assertTrue((boolean)bindingSet.hasBinding("mbox"));
                Value value = bindingSet.getValue("name");
                Value value2 = bindingSet.getValue("mbox");
                AGRepositoryConnectionTest.assertTrue((this.nameAlice.equals(value) || this.nameBob.equals(value) ? 1 : 0) != 0);
                AGRepositoryConnectionTest.assertTrue((this.mboxAlice.equals(value2) || this.mboxBob.equals(value2) ? 1 : 0) != 0);
            }
        }
        finally {
            tupleQueryResult.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleTupleQueryUnicode() throws Exception {
        this.testCon.add((Resource)this.alexander, this.name, (Value)this.strangeUnicodeVarname, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        stringBuilder.append(" SELECT ?person");
        stringBuilder.append(" WHERE { ?person foaf:name '");
        stringBuilder.append(this.strangeUnicodeVarname.getLabel()).append("' .}");
        TupleQueryResult tupleQueryResult = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, stringBuilder.toString()).evaluate();
        try {
            AGRepositoryConnectionTest.assertTrue((tupleQueryResult != null ? 1 : 0) != 0);
            AGRepositoryConnectionTest.assertTrue((boolean)tupleQueryResult.hasNext());
            while (tupleQueryResult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tupleQueryResult.next();
                AGRepositoryConnectionTest.assertTrue((boolean)bindingSet.hasBinding("person"));
                AGRepositoryConnectionTest.assertEquals((Object)this.alexander, (Object)bindingSet.getValue("person"));
            }
        }
        finally {
            tupleQueryResult.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreparedTupleQuery() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        stringBuilder.append(" SELECT ?name ?mbox");
        stringBuilder.append(" WHERE { ?x foaf:name ?name .");
        stringBuilder.append("         ?x foaf:mbox ?mbox .}");
        TupleQuery tupleQuery = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, stringBuilder.toString());
        tupleQuery.setBinding("name", (Value)this.nameBob);
        TupleQueryResult tupleQueryResult = tupleQuery.evaluate();
        try {
            AGRepositoryConnectionTest.assertTrue((tupleQueryResult != null ? 1 : 0) != 0);
            AGRepositoryConnectionTest.assertTrue((boolean)tupleQueryResult.hasNext());
            while (tupleQueryResult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tupleQueryResult.next();
                AGRepositoryConnectionTest.assertTrue((boolean)bindingSet.hasBinding("name"));
                AGRepositoryConnectionTest.assertTrue((boolean)bindingSet.hasBinding("mbox"));
                Value value = bindingSet.getValue("name");
                Value value2 = bindingSet.getValue("mbox");
                AGRepositoryConnectionTest.assertEquals((String)("unexpected value for name: " + value), (Object)this.nameBob, (Object)value);
                AGRepositoryConnectionTest.assertEquals((String)("unexpected value for mbox: " + value2), (Object)this.mboxBob, (Object)value2);
            }
        }
        finally {
            tupleQueryResult.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreparedTupleQueryUnicode() throws Exception {
        this.testCon.add((Resource)this.alexander, this.name, (Value)this.strangeUnicodeVarname, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        stringBuilder.append(" SELECT ?person");
        stringBuilder.append(" WHERE { ?person foaf:name '");
        stringBuilder.append(this.strangeUnicodeVarname.getLabel()).append("' .}");
        TupleQuery tupleQuery = this.testCon.prepareTupleQuery(QueryLanguage.SPARQL, stringBuilder.toString());
        tupleQuery.setBinding("name", (Value)this.strangeUnicodeVarname);
        TupleQueryResult tupleQueryResult = tupleQuery.evaluate();
        try {
            AGRepositoryConnectionTest.assertTrue((tupleQueryResult != null ? 1 : 0) != 0);
            AGRepositoryConnectionTest.assertTrue((boolean)tupleQueryResult.hasNext());
            while (tupleQueryResult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tupleQueryResult.next();
                AGRepositoryConnectionTest.assertTrue((boolean)bindingSet.hasBinding("person"));
                AGRepositoryConnectionTest.assertEquals((Object)this.alexander, (Object)bindingSet.getValue("person"));
            }
        }
        finally {
            tupleQueryResult.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleGraphQuery() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        stringBuilder.append(" CONSTRUCT { ?x foaf:name ?name .");
        stringBuilder.append("         ?x foaf:mbox ?mbox .}");
        stringBuilder.append(" WHERE { ?x foaf:name ?name .");
        stringBuilder.append("         ?x foaf:mbox ?mbox .}");
        GraphQueryResult graphQueryResult = this.testCon.prepareGraphQuery(QueryLanguage.SPARQL, stringBuilder.toString()).evaluate();
        try {
            AGRepositoryConnectionTest.assertTrue((graphQueryResult != null ? 1 : 0) != 0);
            AGRepositoryConnectionTest.assertTrue((boolean)graphQueryResult.hasNext());
            while (graphQueryResult.hasNext()) {
                Statement statement = (Statement)graphQueryResult.next();
                if (this.name.equals(statement.getPredicate())) {
                    AGRepositoryConnectionTest.assertTrue((this.nameAlice.equals(statement.getObject()) || this.nameBob.equals(statement.getObject()) ? 1 : 0) != 0);
                    continue;
                }
                AGRepositoryConnectionTest.assertTrue((boolean)this.mbox.equals(statement.getPredicate()));
                AGRepositoryConnectionTest.assertTrue((this.mboxAlice.equals(statement.getObject()) || this.mboxBob.equals(statement.getObject()) ? 1 : 0) != 0);
            }
        }
        finally {
            graphQueryResult.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreparedGraphQuery() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" PREFIX foaf: <http://xmlns.com/foaf/0.1/>");
        stringBuilder.append(" CONSTRUCT { ?x foaf:name ?name .");
        stringBuilder.append("         ?x foaf:mbox ?mbox .}");
        stringBuilder.append(" WHERE { ?x foaf:name ?name .");
        stringBuilder.append("         ?x foaf:mbox ?mbox .}");
        GraphQuery graphQuery = this.testCon.prepareGraphQuery(QueryLanguage.SPARQL, stringBuilder.toString());
        graphQuery.setBinding("name", (Value)this.nameBob);
        GraphQueryResult graphQueryResult = graphQuery.evaluate();
        try {
            AGRepositoryConnectionTest.assertTrue((graphQueryResult != null ? 1 : 0) != 0);
            AGRepositoryConnectionTest.assertTrue((boolean)graphQueryResult.hasNext());
            while (graphQueryResult.hasNext()) {
                Statement statement = (Statement)graphQueryResult.next();
                AGRepositoryConnectionTest.assertTrue((this.name.equals(statement.getPredicate()) || this.mbox.equals(statement.getPredicate()) ? 1 : 0) != 0);
                if (this.name.equals(statement.getPredicate())) {
                    AGRepositoryConnectionTest.assertTrue((String)("unexpected value for name: " + statement.getObject()), (boolean)this.nameBob.equals(statement.getObject()));
                    continue;
                }
                AGRepositoryConnectionTest.assertTrue((boolean)this.mbox.equals(statement.getPredicate()));
                AGRepositoryConnectionTest.assertTrue((String)("unexpected value for mbox: " + statement.getObject()), (boolean)this.mboxBob.equals(statement.getObject()));
            }
        }
        finally {
            graphQueryResult.close();
        }
    }

    public void testSetWithVariables() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
        stringBuilder.append("ASK ");
        stringBuilder.append("{ GRAPH ?g { ?p foaf:name ?name } }");
        SPARQLQuery sPARQLQuery = new SPARQLQuery();
        sPARQLQuery.setTripleStore(this.ts);
        sPARQLQuery.setQuery(stringBuilder.toString());
        sPARQLQuery.setFrom(new String[]{this.context1.toString()});
        sPARQLQuery.setFromNamed(new String[]{this.context2.toString()});
        sPARQLQuery.setWithVariables(this.ts, new Object[]{"name", this.ts.createLiteral("Bob")});
        AGRepositoryConnectionTest.assertFalse((boolean)sPARQLQuery.ask());
        sPARQLQuery.setFromNamed(new String[]{this.context1.toString()});
        AGRepositoryConnectionTest.assertTrue((boolean)sPARQLQuery.ask());
    }

    public void testDataset() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
        stringBuilder.append("ASK ");
        stringBuilder.append("{ ?p foaf:name ?name }");
        BooleanQuery booleanQuery = this.testCon.prepareBooleanQuery(QueryLanguage.SPARQL, stringBuilder.toString());
        booleanQuery.setBinding("name", (Value)this.nameBob);
        AGRepositoryConnectionTest.assertTrue((boolean)booleanQuery.evaluate());
        DatasetImpl datasetImpl = new DatasetImpl();
        datasetImpl.addDefaultGraph(this.context1);
        booleanQuery.setDataset((Dataset)datasetImpl);
        AGRepositoryConnectionTest.assertTrue((boolean)booleanQuery.evaluate());
        datasetImpl.addDefaultGraph(this.context2);
        booleanQuery.setDataset((Dataset)datasetImpl);
        AGRepositoryConnectionTest.assertTrue((boolean)booleanQuery.evaluate());
        datasetImpl.removeDefaultGraph(this.context1);
        booleanQuery.setDataset((Dataset)datasetImpl);
        AGRepositoryConnectionTest.assertFalse((boolean)booleanQuery.evaluate());
        stringBuilder.setLength(0);
        stringBuilder.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> ");
        stringBuilder.append("ASK ");
        stringBuilder.append("{ GRAPH ?g { ?p foaf:name ?name } }");
        booleanQuery = this.testCon.prepareBooleanQuery(QueryLanguage.SPARQL, stringBuilder.toString());
        booleanQuery.setBinding("name", (Value)this.nameBob);
        booleanQuery.setDataset((Dataset)datasetImpl);
        AGRepositoryConnectionTest.assertFalse((boolean)booleanQuery.evaluate());
        datasetImpl.addDefaultGraph(this.context1);
        datasetImpl.addNamedGraph(this.context2);
        booleanQuery.setDataset((Dataset)datasetImpl);
        AGRepositoryConnectionTest.assertFalse((boolean)booleanQuery.evaluate());
        datasetImpl.addNamedGraph(this.context1);
        booleanQuery.setDataset((Dataset)datasetImpl);
        AGRepositoryConnectionTest.assertTrue((boolean)booleanQuery.evaluate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetStatements() throws Exception {
        Object object;
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        AGRepositoryConnectionTest.assertTrue((String)"Repository should contain statement", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        RepositoryResult repositoryResult = this.testCon.getStatements(null, this.name, null, false, new Resource[0]);
        try {
            AGRepositoryConnectionTest.assertTrue((String)"Iterator should not be null", (repositoryResult != null ? 1 : 0) != 0);
            AGRepositoryConnectionTest.assertTrue((String)"Iterator should not be empty", (boolean)repositoryResult.hasNext());
            while (repositoryResult.hasNext()) {
                object = (Statement)repositoryResult.next();
                AGRepositoryConnectionTest.assertNull((String)"Statement should not be in a context ", (Object)object.getContext());
                AGRepositoryConnectionTest.assertTrue((String)"Statement predicate should be equal to name ", (boolean)object.getPredicate().equals(this.name));
            }
        }
        finally {
            repositoryResult.close();
        }
        object = (List)Iterations.addAll((Iteration)this.testCon.getStatements(null, this.name, null, false, new Resource[0]), new ArrayList());
        AGRepositoryConnectionTest.assertTrue((String)"List should not be null", (object != null ? 1 : 0) != 0);
        AGRepositoryConnectionTest.assertFalse((String)"List should not be empty", (boolean)object.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetStatementsInSingleContext() throws Exception {
        Object object;
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.setAutoCommit(true);
        AGRepositoryConnectionTest.assertTrue((String)"Repository should contain statement", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        AGRepositoryConnectionTest.assertTrue((String)"Repository should contain statement in context1", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
        AGRepositoryConnectionTest.assertFalse((String)"Repository should not contain statement in context2", (boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
        RepositoryResult repositoryResult = this.testCon.getStatements((Resource)this.bob, this.name, null, false, new Resource[0]);
        try {
            while (repositoryResult.hasNext()) {
                object = (Statement)repositoryResult.next();
                AGRepositoryConnectionTest.assertTrue((boolean)this.bob.equals(object.getSubject()));
                AGRepositoryConnectionTest.assertTrue((boolean)this.name.equals(object.getPredicate()));
                AGRepositoryConnectionTest.assertTrue((boolean)this.nameBob.equals(object.getObject()));
                AGRepositoryConnectionTest.assertTrue((boolean)this.context1.equals(object.getContext()));
            }
        }
        finally {
            repositoryResult.close();
        }
        repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1});
        try {
            while (repositoryResult.hasNext()) {
                object = (Statement)repositoryResult.next();
                AGRepositoryConnectionTest.assertTrue((boolean)this.context1.equals(object.getContext()));
            }
        }
        finally {
            repositoryResult.close();
        }
        repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{this.unknownContext});
        try {
            AGRepositoryConnectionTest.assertTrue((repositoryResult != null ? 1 : 0) != 0);
            AGRepositoryConnectionTest.assertFalse((boolean)repositoryResult.hasNext());
        }
        finally {
            repositoryResult.close();
        }
        object = (List)Iterations.addAll((Iteration)this.testCon.getStatements(null, this.name, null, false, new Resource[]{this.context1}), new ArrayList());
        AGRepositoryConnectionTest.assertTrue((String)"List should not be null", (object != null ? 1 : 0) != 0);
        AGRepositoryConnectionTest.assertFalse((String)"List should not be empty", (boolean)object.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetStatementsInMultipleContexts() throws Exception {
        Statement statement;
        int n;
        this.testCon.clear(new Resource[0]);
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.alice, this.mbox, (Value)this.mboxAlice, new Resource[]{this.context2});
        this.testCon.add((Resource)this.context2, this.publisher, (Value)this.nameAlice, new Resource[0]);
        this.testCon.setAutoCommit(true);
        RepositoryResult repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{null, this.context2});
        try {
            n = 0;
            while (repositoryResult.hasNext()) {
                ++n;
                statement = (Statement)repositoryResult.next();
                AGRepositoryConnectionTest.assertTrue((statement.getContext() == null || this.context2.equals(statement.getContext()) ? 1 : 0) != 0);
            }
            AGRepositoryConnectionTest.assertEquals((String)"there should be three statements", (int)3, (int)n);
        }
        finally {
            repositoryResult.close();
        }
        repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2});
        try {
            n = 0;
            while (repositoryResult.hasNext()) {
                ++n;
                statement = (Statement)repositoryResult.next();
                AGRepositoryConnectionTest.assertTrue((boolean)this.context2.equals(statement.getContext()));
            }
            AGRepositoryConnectionTest.assertEquals((String)"there should be two statements", (int)2, (int)n);
        }
        finally {
            repositoryResult.close();
        }
        repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{this.unknownContext, this.context2});
        try {
            n = 0;
            while (repositoryResult.hasNext()) {
                ++n;
                statement = (Statement)repositoryResult.next();
                AGRepositoryConnectionTest.assertTrue((boolean)this.context2.equals(statement.getContext()));
            }
            AGRepositoryConnectionTest.assertEquals((String)"there should be two statements", (int)2, (int)n);
        }
        finally {
            repositoryResult.close();
        }
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.bob, this.mbox, (Value)this.mboxBob, new Resource[]{this.context1});
        this.testCon.add((Resource)this.context1, this.publisher, (Value)this.nameBob, new Resource[0]);
        this.testCon.setAutoCommit(true);
        repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1});
        try {
            AGRepositoryConnectionTest.assertTrue((repositoryResult != null ? 1 : 0) != 0);
            AGRepositoryConnectionTest.assertTrue((boolean)repositoryResult.hasNext());
        }
        finally {
            repositoryResult.close();
        }
        repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{null, this.context2});
        try {
            n = 0;
            while (repositoryResult.hasNext()) {
                ++n;
                statement = (Statement)repositoryResult.next();
                AGRepositoryConnectionTest.assertTrue((statement.getContext() == null || this.context2.equals(statement.getContext()) ? 1 : 0) != 0);
            }
            AGRepositoryConnectionTest.assertEquals((String)"there should be four statements", (int)4, (int)n);
        }
        finally {
            repositoryResult.close();
        }
        repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[]{this.context1, this.context2});
        try {
            n = 0;
            while (repositoryResult.hasNext()) {
                ++n;
                statement = (Statement)repositoryResult.next();
                AGRepositoryConnectionTest.assertTrue((this.context1.equals(statement.getContext()) || this.context2.equals(statement.getContext()) ? 1 : 0) != 0);
            }
            AGRepositoryConnectionTest.assertEquals((String)"there should be four statements", (int)4, (int)n);
        }
        finally {
            repositoryResult.close();
        }
    }

    public void testRemoveStatements() throws Exception {
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        this.testCon.setAutoCommit(true);
        AGRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        AGRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        this.testCon.remove((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        AGRepositoryConnectionTest.assertFalse((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        AGRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        this.testCon.remove((Resource)this.alice, null, null, new Resource[0]);
        AGRepositoryConnectionTest.assertFalse((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        AGRepositoryConnectionTest.assertTrue((boolean)this.testCon.isEmpty());
    }

    public void testRemoveStatementCollection() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.setAutoCommit(true);
        AGRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        AGRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        Collection collection = Iterations.addAll((Iteration)this.testCon.getStatements(null, null, null, false, new Resource[0]), new ArrayList());
        this.testCon.remove((Iterable)collection, new Resource[0]);
        AGRepositoryConnectionTest.assertFalse((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        AGRepositoryConnectionTest.assertFalse((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveStatementIteration() throws Exception {
        this.testCon.add((Resource)this.alice, this.name, (Value)this.nameAlice, new Resource[0]);
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        this.testCon.setAutoCommit(true);
        AGRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        AGRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
        RepositoryResult repositoryResult = this.testCon.getStatements(null, null, null, false, new Resource[0]);
        try {
            this.testCon.remove((Iteration)repositoryResult, new Resource[0]);
        }
        finally {
            repositoryResult.close();
        }
        AGRepositoryConnectionTest.assertFalse((boolean)this.testCon.hasStatement((Resource)this.bob, this.name, (Value)this.nameBob, false, new Resource[0]));
        AGRepositoryConnectionTest.assertFalse((boolean)this.testCon.hasStatement((Resource)this.alice, this.name, (Value)this.nameAlice, false, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddReader() throws Exception {
        FileInputStream fileInputStream = new FileInputStream(this.TEST_DIR_PREFIX + "default-graph.nt");
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
        this.testCon.add((Reader)inputStreamReader, "", RDFFormat.NTRIPLES, new Resource[0]);
        ((Reader)inputStreamReader).close();
        AGRepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        AGRepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        FileInputStream fileInputStream2 = new FileInputStream(this.TEST_DIR_PREFIX + "graph1.nt");
        InputStreamReader inputStreamReader2 = new InputStreamReader((InputStream)fileInputStream2, "UTF-8");
        try {
            this.testCon.add((Reader)inputStreamReader2, "", RDFFormat.NTRIPLES, new Resource[]{this.context1});
        }
        finally {
            ((Reader)inputStreamReader2).close();
        }
        FileInputStream fileInputStream3 = new FileInputStream(this.TEST_DIR_PREFIX + "graph2.nt");
        InputStreamReader inputStreamReader3 = new InputStreamReader((InputStream)fileInputStream3, "UTF-8");
        try {
            this.testCon.add((Reader)inputStreamReader3, "", RDFFormat.NTRIPLES, new Resource[]{this.context2});
        }
        finally {
            ((Reader)inputStreamReader3).close();
        }
        AGRepositoryConnectionTest.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
        AGRepositoryConnectionTest.assertFalse((String)"alice should not be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context1}));
        AGRepositoryConnectionTest.assertTrue((String)"alice should be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context2}));
        AGRepositoryConnectionTest.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
        AGRepositoryConnectionTest.assertFalse((String)"bob should not be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
        AGRepositoryConnectionTest.assertTrue((String)"bib should be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddInputStream() throws Exception {
        FileInputStream fileInputStream = new FileInputStream(this.TEST_DIR_PREFIX + "default-graph.nt");
        try {
            this.testCon.add((InputStream)fileInputStream, "", RDFFormat.NTRIPLES, new Resource[0]);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        AGRepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameBob, false, new Resource[0]));
        AGRepositoryConnectionTest.assertTrue((String)"Repository should contain newly added statements", (boolean)this.testCon.hasStatement(null, this.publisher, (Value)this.nameAlice, false, new Resource[0]));
        FileInputStream fileInputStream2 = new FileInputStream(this.TEST_DIR_PREFIX + "graph1.nt");
        try {
            this.testCon.add((InputStream)fileInputStream2, "", RDFFormat.NTRIPLES, new Resource[]{this.context1});
        }
        finally {
            ((InputStream)fileInputStream2).close();
        }
        FileInputStream fileInputStream3 = new FileInputStream(this.TEST_DIR_PREFIX + "graph2.nt");
        try {
            this.testCon.add((InputStream)fileInputStream3, "", RDFFormat.NTRIPLES, new Resource[]{this.context2});
        }
        finally {
            ((InputStream)fileInputStream3).close();
        }
        AGRepositoryConnectionTest.assertTrue((String)"alice should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[0]));
        AGRepositoryConnectionTest.assertFalse((String)"alice should not be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context1}));
        AGRepositoryConnectionTest.assertTrue((String)"alice should be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameAlice, false, new Resource[]{this.context2}));
        AGRepositoryConnectionTest.assertTrue((String)"bob should be known in the store", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[0]));
        AGRepositoryConnectionTest.assertFalse((String)"bob should not be known in context2", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context2}));
        AGRepositoryConnectionTest.assertTrue((String)"bib should be known in context1", (boolean)this.testCon.hasStatement(null, this.name, (Value)this.nameBob, false, new Resource[]{this.context1}));
    }

    public void testRecoverFromParseError() throws RepositoryException, IOException {
        String string = "bad";
        try {
            this.testCon.add((Reader)new StringReader(string), "", RDFFormat.NTRIPLES, new Resource[0]);
            AGRepositoryConnectionTest.fail((String)"Invalid data should result in an exception");
        }
        catch (RDFParseException rDFParseException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    public void testStatementSerialization() throws Exception {
        Statement statement;
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[0]);
        RepositoryResult repositoryResult = this.testCon.getStatements(null, null, null, true, new Resource[0]);
        try {
            statement = (Statement)repositoryResult.next();
        }
        finally {
            repositoryResult.close();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(statement);
        objectOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Statement statement2 = (Statement)objectInputStream.readObject();
        objectInputStream.close();
        AGRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement(statement, true, new Resource[0]));
        AGRepositoryConnectionTest.assertTrue((boolean)this.testCon.hasStatement(statement2, true, new Resource[0]));
    }

    public void testAddRemove() throws Exception {
        URI uRI = this.vf.createURI("http://xmlns.com/foaf/0.1/Person");
        final Statement statement = this.vf.createStatement((Resource)this.bob, this.name, (Value)this.nameBob);
        this.testCon.add((Resource)this.bob, RDF.TYPE, (Value)uRI, new Resource[0]);
        this.testCon.add(statement, new Resource[0]);
        this.testCon.remove(statement, new Resource[0]);
        this.testCon.commit();
        this.testCon.exportStatements(null, null, null, false, (RDFHandler)new RDFHandlerBase(){

            public void handleStatement(Statement statement2) throws RDFHandlerException {
                Assert.assertTrue((!statement.equals(statement2) ? 1 : 0) != 0);
            }
        }, new Resource[0]);
    }

    public void testGetContextIDs() throws Exception {
        AGRepositoryConnectionTest.assertEquals((int)0, (int)this.testCon.getContextIDs().asList().size());
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        AGRepositoryConnectionTest.assertEquals(Arrays.asList(this.context1), (Object)this.testCon.getContextIDs().asList());
        this.testCon.remove((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context1});
        AGRepositoryConnectionTest.assertEquals((int)0, (int)this.testCon.getContextIDs().asList().size());
        this.testCon.setAutoCommit(true);
        AGRepositoryConnectionTest.assertEquals((int)0, (int)this.testCon.getContextIDs().asList().size());
        this.testCon.add((Resource)this.bob, this.name, (Value)this.nameBob, new Resource[]{this.context2});
        AGRepositoryConnectionTest.assertEquals(Arrays.asList(this.context2), (Object)this.testCon.getContextIDs().asList());
    }
}

