/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase;

import com.franz.ag.UPI;
import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.GeospatialSubtype;
import com.franz.agbase.impl.GeospatialSubtypeImpl;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.util.AGInternals;

public class Polygon {
    private AGInternals pag = null;
    private double[] points;
    private int i = 0;
    private UPI subject = null;
    private boolean modified = true;
    private GeospatialSubtypeImpl subtype;

    public GeospatialSubtype getSubtype() {
        return this.subtype;
    }

    public void setSubtype(GeospatialSubtype geospatialSubtype) {
        this.modified = true;
        this.subtype = (GeospatialSubtypeImpl)geospatialSubtype;
    }

    public double[] getPoints() {
        return (double[])this.points.clone();
    }

    public boolean getModified() {
        return this.modified;
    }

    public UPI getSubject() {
        return this.subject;
    }

    public void setSubject(UPI uPI) {
        this.modified = true;
        this.subject = uPI;
    }

    public Polygon(int n) {
        this.points = new double[2 * n];
    }

    public void addVertex(double d, double d2) {
        this.modified = true;
        this.points[this.i] = d;
        ++this.i;
        this.points[this.i] = d2;
        ++this.i;
    }

    public UPI add(AllegroGraph allegroGraph) throws AllegroGraphException {
        if (this.pag != null) {
            throw new IllegalStateException("Already added to store " + this.pag);
        }
        if (this.i < this.points.length) {
            throw new IllegalStateException("Incomplete Polygon");
        }
        if (null == this.subtype) {
            throw new IllegalStateException("Cannot add Polygon without a subtype");
        }
        this.pag = allegroGraph;
        Object[] objectArray = allegroGraph.verifyEnabled().applyAGFn(this.pag, "ag-add-polygon", new Object[]{this.subject, new Long(this.subtype.getLocal(allegroGraph.ags)), this.points});
        this.subject = (UPI)objectArray[0];
        this.modified = false;
        return this.subject;
    }

    public void get(AllegroGraph allegroGraph) throws AllegroGraphException {
        if (null == this.subject) {
            throw new IllegalStateException("Cannot locate Polygon with null subject");
        }
        this.pag = allegroGraph;
        Object[] objectArray = allegroGraph.verifyEnabled().applyAGFn(this.pag, "ag-get-polygon", new Object[]{this.subject});
        this.points = (double[])objectArray[0];
        this.i = this.points.length;
        this.modified = false;
    }

    public boolean pointInside(double d, double d2) throws AllegroGraphException {
        Object[] objectArray = this.pag.verifyEnabled().applyAGFn(this.pag, "ag-points-inside-poly", new Object[]{this.points, new Double(d), new Double(d2)});
        return 1L == AGConnector.longValue(objectArray[0]);
    }

    public boolean[] pointsInside(double[] dArray) throws AllegroGraphException {
        Object[] objectArray = this.pag.verifyEnabled().applyAGFn(this.pag, "ag-points-inside-poly", new Object[]{this.points, dArray});
        long[] lArray = AGConnector.longArray(objectArray[0]);
        boolean[] blArray = new boolean[lArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = 1L == lArray[i];
        }
        return blArray;
    }

    public boolean[] pointsInside(double[] dArray, double[] dArray2) throws AllegroGraphException {
        Object[] objectArray = this.pag.verifyEnabled().applyAGFn(this.pag, "ag-points-inside-poly", new Object[]{this.points, dArray, dArray2});
        long[] lArray = AGConnector.longArray(objectArray[0]);
        boolean[] blArray = new boolean[lArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = 1L == lArray[i];
        }
        return blArray;
    }
}

