/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agjena;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agjena.AllegroGraphGraph;
import com.franz.agjena.Utils;
import com.franz.agjena.exceptions.NiceException;
import com.franz.agjena.exceptions.UnimplementedMethodException;
import com.hp.hpl.jena.enhanced.Personality;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.shared.JenaException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.log4j.Logger;

public class AllegroGraphModel
extends ModelCom
implements Model {
    private static Logger logger = Logger.getLogger(AllegroGraphModel.class);
    private AllegroGraphGraph agraph = null;
    public static String NTRIPLES_FORMAT = "NTRIPLE";
    public static String RDFXML_FORMAT = "RDF/XML";

    public static String version() {
        Class<AllegroGraphModel> clazz = AllegroGraphModel.class;
        Class<?>[] classArray = clazz.getDeclaredClasses();
        String string = clazz.getName();
        String string2 = "";
        string = string + "$V";
        for (int i = 0; i < classArray.length; ++i) {
            String string3 = classArray[i].getName();
            if (!string3.startsWith(string)) continue;
            string2 = string3;
        }
        return string2;
    }

    public AllegroGraphModel(Graph graph) {
        super(graph);
        this.agraph = (AllegroGraphGraph)graph;
    }

    public AllegroGraphModel(Graph graph, Personality personality) {
        super(graph, personality);
        throw new UnimplementedMethodException("AllegroGraphModel two-argument constructor");
    }

    public AllegroGraph getAllegroGraphStore() {
        return ((AllegroGraphGraph)this.getGraph()).getAllegroGraphStore();
    }

    public String getName() {
        return ((AllegroGraphGraph)this.getGraph()).getName();
    }

    public String toString() {
        return "|AllegroGraphModel|" + this.getName();
    }

    private String urlToFile(String string, boolean bl) {
        return string;
    }

    private String langToNTriplesOrRDF(String string) {
        if (Utils.isNullString(string)) {
            return NTRIPLES_FORMAT;
        }
        if ("NTRIPLE".equals(string = string.toUpperCase())) {
            return NTRIPLES_FORMAT;
        }
        if (NTRIPLES_FORMAT.equals(string)) {
            return NTRIPLES_FORMAT;
        }
        if ("N-TRIPLE".equals(string)) {
            return NTRIPLES_FORMAT;
        }
        if ("N-TRIPLES".equals(string)) {
            return NTRIPLES_FORMAT;
        }
        if ("RDF/XML".equals(string)) {
            return RDFXML_FORMAT;
        }
        if ("RDF/XML-ABBREV".equals(string)) {
            return RDFXML_FORMAT;
        }
        return null;
    }

    public Model read(String string) {
        return this.read(string, null, null);
    }

    public Model read(Reader reader, String string) {
        return super.read(reader, string);
    }

    public Model read(InputStream inputStream, String string) {
        return super.read(inputStream, string);
    }

    public Model read(String string, String string2) {
        return this.read(string, null, string2);
    }

    public Model read(String string, String string2, String string3) {
        String string4 = this.urlToFile(string, true);
        String string5 = this.langToNTriplesOrRDF(string3);
        if (string4 != null && string5 != null) {
            AllegroGraphGraph allegroGraphGraph = (AllegroGraphGraph)this.getGraph();
            if (allegroGraphGraph.isRDFSPlusPlusGraph()) {
                allegroGraphGraph = (AllegroGraphGraph)allegroGraphGraph.getRawGraph();
            }
            Object object = allegroGraphGraph.getContextArgumentObject();
            try {
                if (string5.equals(NTRIPLES_FORMAT)) {
                    this.agraph.getAllegroGraphStore().loadNTriples(string4, object, null, null, null);
                } else {
                    this.agraph.getAllegroGraphStore().loadRDFXML(string4, object, string2);
                }
            }
            catch (AllegroGraphException allegroGraphException) {
                throw new NiceException("Failure during loading from the file at '" + string + "'");
            }
            return this;
        }
        return super.read(string, string2, string3);
    }

    public Model read(Reader reader, String string, String string2) {
        return super.read(reader, string, string2);
    }

    public Model read(InputStream inputStream, String string, String string2) {
        return super.read(inputStream, string, string2);
    }

    public boolean supportsTransactions() {
        return false;
    }

    public Model removeAll() {
        return this.removeAll(null, null, null);
    }

    public Model removeAll(Resource resource, Property property, RDFNode rDFNode) {
        Node node = resource == null ? null : resource.asNode();
        Node node2 = property == null ? null : property.asNode();
        Node node3 = rDFNode == null ? null : rDFNode.asNode();
        this.getBaseGraph().removeAll(node, node2, node3);
        return this;
    }

    private AllegroGraphGraph getBaseGraph() {
        AllegroGraphGraph allegroGraphGraph = (AllegroGraphGraph)this.getGraph();
        if (allegroGraphGraph.isRDFSPlusPlusGraph()) {
            allegroGraphGraph = (AllegroGraphGraph)allegroGraphGraph.getRawGraph();
        }
        return allegroGraphGraph;
    }

    public void close() {
    }

    public void indexTriples(boolean bl, boolean bl2) {
        try {
            if (bl) {
                this.agraph.getAllegroGraphStore().indexAllTriples(!bl2);
            } else {
                this.agraph.getAllegroGraphStore().indexNewTriples(!bl2);
            }
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new JenaException((Throwable)allegroGraphException);
        }
    }

    public long size() {
        AllegroGraphGraph allegroGraphGraph = this.getBaseGraph();
        return allegroGraphGraph.graphBaseSize();
    }

    public static class V3_2Mar27 {
    }
}

