/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgereefsystems.agsail;

import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.SPARQLQuery;
import com.franz.agbase.ValueSetIterator;
import com.franz.agsail.AGForSail;
import com.franz.agsail.AGSailCursor;
import com.knowledgereefsystems.agsail.AllegroSail;
import com.knowledgereefsystems.agsail.AllegroSailException;
import com.knowledgereefsystems.agsail.ContextIteration;
import com.knowledgereefsystems.agsail.NamespaceIteration;
import com.knowledgereefsystems.agsail.ResourceIteration;
import com.knowledgereefsystems.agsail.SailConnectionTripleSource;
import com.knowledgereefsystems.agsail.StatementIteration;
import info.aduna.iteration.CloseableIteration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailChangedEvent;
import org.openrdf.sail.SailChangedListener;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailConnectionListener;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllegroSailConnection
implements SailConnection {
    private final AGForSail aGraph;
    private final AllegroGraphConnection agConnection;
    private final AllegroSail sail;
    private final ValueFactory valueFactory;
    private final Collection<SailChangedListener> sailChangedListeners;
    private final Set<SailConnectionListener> sailConnectionListeners = new HashSet<SailConnectionListener>();
    private boolean open = true;
    private boolean uncommittedInsertions;
    private boolean uncommittedDeletions;

    public boolean isUncommittedInsertions() {
        return this.uncommittedInsertions;
    }

    public void setUncommittedInsertions(boolean bl) {
        this.uncommittedInsertions = bl;
    }

    public boolean isUncommittedDeletions() {
        return this.uncommittedDeletions;
    }

    public void setUncommittedDeletions(boolean bl) {
        this.uncommittedDeletions = bl;
    }

    public AllegroSailConnection(AGForSail aGForSail, AllegroGraphConnection allegroGraphConnection, AllegroSail allegroSail, Collection<SailChangedListener> collection) {
        this.aGraph = aGForSail;
        this.sail = allegroSail;
        this.valueFactory = allegroSail.getValueFactory();
        this.agConnection = allegroGraphConnection;
        this.sailChangedListeners = collection;
        this.uncommittedDeletions = false;
        this.uncommittedInsertions = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(SailConnectionListener sailConnectionListener) {
        Set<SailConnectionListener> set = this.sailConnectionListeners;
        synchronized (set) {
            this.sailConnectionListeners.add(sailConnectionListener);
        }
    }

    public void addStatement(Resource resource, URI uRI, Value value, Resource ... defaultSailChangedEvent) throws SailException {
        try {
            if (0 == ((Resource[])defaultSailChangedEvent).length) {
                this.aGraph.addStatement(resource, uRI, value);
                this.statementAdded(resource, uRI, value, null);
            } else {
                for (Resource resource2 : defaultSailChangedEvent) {
                    if (null == resource2) {
                        this.aGraph.addStatement(resource, uRI, value);
                        this.statementAdded(resource, uRI, value, null);
                        continue;
                    }
                    this.aGraph.addStatement(resource, uRI, value, resource2);
                    this.statementAdded(resource, uRI, value, resource2);
                }
            }
            this.uncommittedInsertions = true;
        }
        catch (Throwable throwable) {
            throw new AllegroSailException(throwable);
        }
        if (this.sailChangedListeners.size() > 0) {
            DefaultSailChangedEvent defaultSailChangedEvent2 = new DefaultSailChangedEvent((Sail)this.sail);
            defaultSailChangedEvent2.setStatementsAdded(true);
            for (SailChangedListener sailChangedListener : this.sailChangedListeners) {
                sailChangedListener.sailChanged((SailChangedEvent)defaultSailChangedEvent2);
            }
        }
    }

    public void clear(Resource ... resourceArray) throws SailException {
        if (0 == resourceArray.length) {
            try {
                this.aGraph.clear();
                this.uncommittedDeletions = true;
            }
            catch (AllegroGraphException allegroGraphException) {
                throw new AllegroSailException(allegroGraphException);
            }
        } else {
            this.removeStatements(null, null, null, resourceArray);
        }
    }

    public void clearNamespaces() throws SailException {
        String[] stringArray = this.agConnection.getNamespaces();
        for (int i = 0; i < stringArray.length; i += 2) {
            this.removeNamespace(stringArray[i]);
        }
    }

    public void close() throws SailException {
        this.open = false;
    }

    public void commit() throws SailException {
        if (this.sail.isReindexOnCommit() && (this.uncommittedInsertions || this.uncommittedDeletions)) {
            try {
                if (this.sail.isIndexAllOnCommit()) {
                    this.aGraph.indexAllTriples(!this.sail.isBackgroundIndexing());
                } else {
                    this.aGraph.indexNewTriples(!this.sail.isBackgroundIndexing());
                }
            }
            catch (AllegroGraphException allegroGraphException) {
                throw new AllegroSailException(allegroGraphException);
            }
            this.uncommittedInsertions = false;
            this.uncommittedInsertions = false;
        }
    }

    public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindingSet, boolean bl) throws SailException {
        return this.evaluateByDecomposition(tupleExpr, dataset, bindingSet, bl);
    }

    public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        ValueSetIterator valueSetIterator;
        SPARQLQuery sPARQLQuery = new SPARQLQuery();
        sPARQLQuery.setTripleStore(this.aGraph.getDirectInstance());
        sPARQLQuery.setQuery("SELECT DISTINCT ?g WHERE { GRAPH ?g { ?s ?p ?o }}");
        try {
            valueSetIterator = sPARQLQuery.select();
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new SailException((Throwable)allegroGraphException);
        }
        return new ContextIteration(this.aGraph, valueSetIterator);
    }

    public String getNamespace(String string) throws SailException {
        String[] stringArray;
        try {
            stringArray = this.agConnection.getNamespaces();
        }
        catch (Throwable throwable) {
            throw new AllegroSailException(throwable);
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equals(string)) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    public CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException {
        String[] stringArray;
        try {
            stringArray = this.aGraph.getDirectInstance().getNamespaces();
        }
        catch (Throwable throwable) {
            throw new AllegroSailException(throwable);
        }
        return new NamespaceIteration(stringArray);
    }

    public CloseableIteration<? extends Statement, SailException> getStatements(Resource resource, URI uRI, Value value, boolean bl, Resource ... resourceArray) throws SailException {
        AGSailCursor[] aGSailCursorArray;
        try {
            if (0 == resourceArray.length) {
                aGSailCursorArray = new AGSailCursor[]{this.aGraph.getStatements(bl, resource, uRI, value, null)};
            } else {
                aGSailCursorArray = new AGSailCursor[resourceArray.length];
                for (int i = 0; i < resourceArray.length; ++i) {
                    Resource resource2 = resourceArray[i];
                    aGSailCursorArray[i] = null == resource2 ? this.aGraph.getStatements(bl, resource, uRI, value) : this.aGraph.getStatements(bl, resource, uRI, value, resource2);
                }
            }
        }
        catch (Throwable throwable) {
            throw new AllegroSailException(throwable);
        }
        return new StatementIteration(aGSailCursorArray, this.valueFactory);
    }

    public boolean isOpen() throws SailException {
        return this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(SailConnectionListener sailConnectionListener) {
        Set<SailConnectionListener> set = this.sailConnectionListeners;
        synchronized (set) {
            this.sailConnectionListeners.remove(sailConnectionListener);
        }
    }

    public void removeNamespace(String string) throws SailException {
        try {
            this.agConnection.registerNamespace(string, null);
        }
        catch (Throwable throwable) {
            throw new AllegroSailException(throwable);
        }
    }

    public void removeStatements(Resource resource, URI uRI, Value value, Resource ... defaultSailChangedEvent) throws SailException {
        try {
            if (0 == ((Resource[])defaultSailChangedEvent).length) {
                this.aGraph.removeStatements(resource, uRI, value, new Resource[0]);
                this.statementRemoved(resource, uRI, value, null);
                this.uncommittedDeletions = true;
            } else {
                for (Resource resource2 : defaultSailChangedEvent) {
                    this.aGraph.removeStatements(resource, uRI, value, resource2);
                    this.statementRemoved(resource, uRI, value, resource2);
                    this.uncommittedDeletions = true;
                }
            }
        }
        catch (Throwable throwable) {
            throw new AllegroSailException(throwable);
        }
        if (this.sailChangedListeners.size() > 0) {
            DefaultSailChangedEvent defaultSailChangedEvent2 = new DefaultSailChangedEvent((Sail)this.sail);
            defaultSailChangedEvent2.setStatementsRemoved(true);
            for (SailChangedListener sailChangedListener : this.sailChangedListeners) {
                sailChangedListener.sailChanged((SailChangedEvent)defaultSailChangedEvent2);
            }
        }
    }

    public void rollback() throws SailException {
        this.uncommittedDeletions = false;
        this.uncommittedInsertions = false;
    }

    public void setNamespace(String string, String string2) throws SailException {
        try {
            this.agConnection.registerNamespace(string, string2);
        }
        catch (Throwable throwable) {
            throw new AllegroSailException(throwable);
        }
    }

    public long size(Resource ... resourceArray) throws SailException {
        if (0 == resourceArray.length) {
            try {
                return this.aGraph.numberOfTriples();
            }
            catch (AllegroGraphException allegroGraphException) {
                throw new AllegroSailException(allegroGraphException);
            }
        }
        return 0L;
    }

    public void registerFreetextPredicate(URI uRI) throws SailException {
        try {
            this.aGraph.registerFreetextPredicate(uRI);
        }
        catch (Throwable throwable) {
            throw new SailException(throwable);
        }
    }

    public CloseableIteration<? extends Statement, SailException> getFreetextStatements(String string) throws SailException {
        AGSailCursor[] aGSailCursorArray = new AGSailCursor[1];
        try {
            aGSailCursorArray[0] = this.aGraph.getFreetextStatements(string);
        }
        catch (Throwable throwable) {
            throw new AllegroSailException(throwable);
        }
        return new StatementIteration(aGSailCursorArray, this.valueFactory);
    }

    public CloseableIteration<? extends Resource, SailException> getFreetextUniqueSubjects(String string) throws SailException {
        ValueSetIterator valueSetIterator;
        try {
            valueSetIterator = this.aGraph.getFreetextUniqueSubjects(string);
        }
        catch (Throwable throwable) {
            throw new AllegroSailException(throwable);
        }
        return new ResourceIteration(this.aGraph, valueSetIterator);
    }

    private CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateByDecomposition(TupleExpr tupleExpr, Dataset dataset, BindingSet bindingSet, boolean bl) throws SailException {
        try {
            SailConnectionTripleSource sailConnectionTripleSource = new SailConnectionTripleSource(this, this.valueFactory, bl);
            EvaluationStrategyImpl evaluationStrategyImpl = new EvaluationStrategyImpl((TripleSource)sailConnectionTripleSource, dataset);
            return evaluationStrategyImpl.evaluate(tupleExpr, bindingSet);
        }
        catch (QueryEvaluationException queryEvaluationException) {
            throw new SailException((Throwable)queryEvaluationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statementAdded(Resource resource, URI uRI, Value value, Resource resource2) {
        if (this.sailConnectionListeners.size() > 0) {
            Statement statement = null == resource2 ? this.aGraph.createStatement(resource, uRI, value) : this.aGraph.createStatement(resource, uRI, value, resource2);
            Set<SailConnectionListener> set = this.sailConnectionListeners;
            synchronized (set) {
                for (SailConnectionListener sailConnectionListener : this.sailConnectionListeners) {
                    sailConnectionListener.statementAdded(statement);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void statementRemoved(Resource resource, URI uRI, Value value, Resource resource2) {
        if (this.sailConnectionListeners.size() > 0) {
            StatementImpl statementImpl = null == resource2 ? new StatementImpl(resource, uRI, value) : new ContextStatementImpl(resource, uRI, value, resource2);
            Set<SailConnectionListener> set = this.sailConnectionListeners;
            synchronized (set) {
                for (SailConnectionListener sailConnectionListener : this.sailConnectionListeners) {
                    sailConnectionListener.statementRemoved((Statement)statementImpl);
                }
            }
        }
    }
}

