/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgereefsystems.agsail;

import com.knowledgereefsystems.agsail.AllegroSailConnection;
import com.knowledgereefsystems.agsail.AllegroSailTestCase;
import java.util.LinkedList;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sail.SailChangedEvent;
import org.openrdf.sail.SailChangedListener;

public class TestListeners
extends AllegroSailTestCase {
    public TestListeners(String string) throws Exception {
        super(string);
    }

    public void testSailChangedListeners() throws Exception {
        final LinkedList linkedList = new LinkedList();
        SailChangedListener sailChangedListener = new SailChangedListener(){

            public void sailChanged(SailChangedEvent sailChangedEvent) {
                linkedList.add(sailChangedEvent);
            }
        };
        this.sail.addSailChangedListener(sailChangedListener);
        URI uRI = this.sail.getValueFactory().createURI("http://example.org/uriA");
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        TestListeners.assertEquals((int)0, (int)linkedList.size());
        allegroSailConnection.addStatement((Resource)uRI, uRI, (Value)uRI, new Resource[]{uRI});
        allegroSailConnection.commit();
        TestListeners.assertEquals((int)1, (int)linkedList.size());
        SailChangedEvent sailChangedEvent = (SailChangedEvent)linkedList.iterator().next();
        TestListeners.assertTrue((boolean)sailChangedEvent.statementsAdded());
        TestListeners.assertFalse((boolean)sailChangedEvent.statementsRemoved());
        linkedList.clear();
        TestListeners.assertEquals((int)0, (int)linkedList.size());
        allegroSailConnection.removeStatements((Resource)uRI, uRI, (Value)uRI, new Resource[]{uRI});
        allegroSailConnection.commit();
        TestListeners.assertEquals((int)1, (int)linkedList.size());
        sailChangedEvent = (SailChangedEvent)linkedList.iterator().next();
        TestListeners.assertFalse((boolean)sailChangedEvent.statementsAdded());
        TestListeners.assertTrue((boolean)sailChangedEvent.statementsRemoved());
        allegroSailConnection.close();
    }
}

