// ***** BEGIN LICENSE BLOCK *****
// Version: MPL 1.1
//
// The contents of this file are subject to the Mozilla Public License Version
// 1.1 (the "License"); you may not use this file except in compliance with
// the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// The Original Code is the AllegroGraph Java Client interface.
//
// The Original Code was written by Franz Inc.
// Copyright (C) 2006 Franz Inc.  All Rights Reserved.
//
// ***** END LICENSE BLOCK *****

package com.franz.ag.impl;

import org.openrdf.model.GraphException;
import org.openrdf.model.Value;
import org.openrdf.sesame.sail.StatementIterator;

import com.franz.ag.AllegroGraphException;
import com.franz.ag.UPI;
import com.franz.ag.ValueNode;

/**
 * This is the superclass of all Value instances.
 */
public class ValueNodeImpl extends ValueObjectImpl implements Value, ValueNode {

	protected ValueNodeImpl() {
		super();
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = -461411711745012850L;

	/* (non-Javadoc)
	 * @see com.franz.ag.ValueNode#queryAGId()
	 */
	public UPI queryAGId() {
		return ((com.franz.agbase.impl.ValueNodeImpl) baseInstance).queryAGId();
	}

	public UPI getAGId() throws AllegroGraphException {
		return ((com.franz.agbase.impl.ValueNodeImpl) baseInstance).getAGId();
	}

	/**
	 * Qick AGId check for equality
	 * 
	 * @param x
	 * @return +1 definite true, 0 definite false, -1 cannot tell
	 */
	protected int sameAGId(Object x) {
		if (x == null) 	return 0;
		if ( this==x ) return 1;
		if ( x instanceof ValueNodeImpl ) {
			ValueNodeImpl y = (ValueNodeImpl) x;
			if ( baseInstance==null ) return -1;
			if ( null==y.baseInstance ) return -1;
			if ( baseInstance==y.baseInstance ) return 1;
			return ((com.franz.agbase.impl.ValueNodeImpl)baseInstance).sameAGId(y.baseInstance);
		}
		return -1;
	}

	protected boolean canReference() {
		return ((com.franz.agbase.impl.ValueNodeImpl) baseInstance).canReference();
	}

	// String stringRef() throws AllegroGraphException {
	// throw new AllegroGraphException
	// ("This class does not have an ntriples string representation: "
	// + getClass());
	// }

	/* (non-Javadoc)
	 * @see com.franz.ag.ValueNode#getObjectStatements()
	 */
	public StatementIterator getObjectStatements() throws GraphException {
		try {
			return owner.getStatements(null, null, this);
		} catch (AllegroGraphException e) {
			throw new GraphException(e);
		}
	}
	
	/* (non-Javadoc)
	 * @see com.franz.ag.ValueNode#compareTo(com.franz.ag.ValueNodeImpl)
	 */
	public int compareTo ( ValueNodeImpl to ) {
		return baseInstance.compareTo(to.baseInstance);
	}


}
