package com.franz.ag.util;

import org.openrdf.model.BNode;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

import com.franz.ag.AllegroGraph;
import com.franz.ag.AllegroGraphConnection;
import com.franz.ag.AllegroGraphException;
import com.franz.ag.Cursor;
import com.franz.ag.DefaultGraph;
import com.franz.ag.UPI;
import com.franz.ag.ValueNode;
import com.franz.ag.ValueObject;
import com.franz.ag.impl.AGFactory;
import com.franz.ag.impl.CursorImpl;
import com.franz.ag.impl.EncodedLiteralImpl;
import com.franz.ag.impl.LiteralImpl;
import com.franz.ag.impl.ValueNodeImpl;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.util.AGBase;
import com.franz.agbase.util.AGC;

public class AGInner extends AGBase {

    public com.franz.agbase.AllegroGraph agbase = null;
	
	public AllegroGraphConnection ags = null;
	
	public int defaultLookAhead = 0;   // use the default in Cursor class
	
	public Cursor emptyCursor () { return CursorImpl.emptyCursor(); }
	
	// CREATED GETTER FOR THIS PUBLIC FIELD - RMM
	public AllegroGraphConnection getConnection () {return ags;}

	public AGConnector verifyEnabled() { 
		return agbase.verifyEnabled();
		}
	
	protected static class valueMapEntry {
    	public Object savedToken; public int savedMore; AllegroGraph savedAG; public Object savedVal = null;
    	public int savedPlimit;  public boolean savedNullOk;
    	public valueMapEntry ( AllegroGraph ag, Object token, int more, int pl, Object sv, boolean nullOk ) {
			savedToken = token; savedMore = more; 
			savedAG = ag; savedPlimit = pl; savedVal = sv;
			savedNullOk = nullOk;
		}
    	protected synchronized void finalize() throws Throwable {
    		if ( (savedAG.ags)==null ) return;
    		if ( null!=savedToken ) savedAG.agbase.ags.oldTokens.add(savedToken);
    	}
    }
	
	
	public void discardCursor(Object ref)
		throws AllegroGraphException {
		verifyEnabled().discardCursor(agbase, ref);
	}
	
	public ValueObject newValue(UPI id, int type, String val, String mod) {
		// id is a valid reference checked by caller
		ValueNodeImpl newInstance;
		switch (type) {
		case AGC.AGU_ANON:
			return AGFactory.makeBlankNode((AllegroGraph)this, id, val);
		case AGC.AGU_NODE:
			if ( mod!=null ) val = val + mod;
			return AGFactory.makeNode((AllegroGraph) this, id, val);
		case AGC.AGU_LITERAL:
			return AGFactory.makeLiteral((AllegroGraph) this, id, val, null, null, LiteralImpl.LANG_NONE, null);
		case AGC.AGU_LITERAL_LANG:
			return AGFactory.makeLiteral((AllegroGraph) this, id, val, null, null, LiteralImpl.LANG_KNOWN, mod);
		case AGC.AGU_TYPED_LITERAL:
			return AGFactory.makeLiteral((AllegroGraph) this, id, val, null, mod, LiteralImpl.LANG_NONE, null);
		case AGC.AGU_TRIPLE:
			if ( id instanceof UPIImpl )
			{
				long idn = ((UPIImpl) id).getCode();
				if ( idn>-1 ) 
					return AGFactory.makeTriple((AllegroGraph)this, idn, null, null, null);
			}
			
		case AGC.AGU_DEFAULT_GRAPH:
			return getDefaultGraph(id);
		case AGC.AGU_ENCODED_STRING:
			newInstance = (ValueNodeImpl) AGFactory.makeEncodedLiteral((AllegroGraph)this, val, mod);
			return newInstance;
		case AGC.AGU_ENCODED_INTEGER:
			newInstance = (ValueNodeImpl) AGFactory.makeEncodedLiteral((AllegroGraph)this, Long.parseLong(val), mod);
			return newInstance;
		case AGC.AGU_ENCODED_FLOAT:
			newInstance = (ValueNodeImpl) AGFactory.makeEncodedLiteral((AllegroGraph)this, Double.parseDouble(val), mod);
			return newInstance;
			// case 11:    // encoded triple id
		default:
			throw new IllegalArgumentException
			      ("Unknown node type " + type + "  " + val + "  " + mod);
		}
	}
	
	public synchronized DefaultGraph getDefaultGraph ( UPI id ) {
		return AGFactory.makeDefaultGraph((AllegroGraph)this, agbase.getDefaultGraph(id));
	 }
	
	 
	 public synchronized boolean isDefaultGraph ( UPI id ) { 
		 return agbase.isDefaultGraph(id);
	 }
	
	 
	 public boolean isDefaultGraph ( int type ) {
		 return type==AGC.AGU_DEFAULT_GRAPH;
	 }
	 
	
	
	public void getPartsInternal(UPI[] ids, int[] tnums, String[] vals, String[] mods)
		throws AllegroGraphException {
		agbase.getPartsInternal(ids, tnums, vals, mods);
}




	public static String refEncToString(EncodedLiteralImpl v) {
		return com.franz.agbase.AllegroGraph.refEncToString(v.baseEncLit);
	}





	public UPI queryAGId(ValueNode x) {
		if (x == null)
			throw new IllegalArgumentException(
			"Null node reference not allowed");
		return x.queryAGId();
	}


	

	/**
	 * Convert a Value instance to a String
	 * containing the object id or an unambiguous representation
	 * of the object.
	 * @param node or literal
	 * @return a string
	 */
	private static String refValueToString(Value node) {
		if ( node instanceof ValueNodeImpl )
			
		{
			ValueNodeImpl nd = (ValueNodeImpl)node;
			return com.franz.agbase.util.AGInternals.refValueToString((com.franz.agbase.ValueNode) nd.baseInstance);
		}
		if ( node instanceof URI )  return refNodeToString(node.toString());;
		if ( node instanceof BNode) return refAnonToString(((BNode)node).getID()); 
		if ( node instanceof org.openrdf.model.Literal )
			{
				org.openrdf.model.Literal lt = (org.openrdf.model.Literal)node;
				String label = lt.getLabel();
				String lang = lt.getLanguage();
				if ( lang!=null )
					return refLitToString(label, lang, null);
					URI dt = lt.getDatatype();
					if ( dt==null )
						return refLitToString(label, null, null);
					return refLitToString(label, null, dt.toString());	
			}
		notValRef(node);
		return "";  // dummy return to avoid compiler error
	}


	/**
	 * Map to string decoded by ag-intern-thing
	 * @param node ntriple string, ValueObject, UPI.
	 * @return encoded string
	 */
	public String refToString(Object node) {
		if ( node instanceof UPIImpl ) return refUPIToString((UPIImpl)node);
		if ( node instanceof EncodedLiteralImpl ) return refEncToString((EncodedLiteralImpl) node);
		if ( node instanceof Value ) return refValueToString((Value)node);
		if ( node instanceof String ) return refNtripleString((String) node);
		throw new IllegalArgumentException
		("Cannot map this object to a Value ref" + node);
	}


	


	private static Object validRefEnc(EncodedLiteralImpl x) {
		UPI u = x.queryAGId();
		if ( (null!=u) && UPIImpl.canReference(u) ) 
			return validUPI(u);
		return refEncToString(x);
	}

	public static Object validRefOb ( Object x ) {
		if ( x instanceof UPIImpl ) return validUPI((UPIImpl)x);
		if ( x instanceof EncodedLiteralImpl ) return validRefEnc((EncodedLiteralImpl) x);
		if ( x instanceof Value ) return refValueToString((Value)x); 
		if ( x instanceof String ) return refNtripleString((String)x);
		throw new IllegalArgumentException("Not a valid part reference: " + x);
	}

	// This has a lot of refs as a class method.
	public Object validRef(Object x) { return validRefOb(x); }

    public static Object validRefOb ( Object x, Object ifNull ) {
    	if ( x==null ) return ifNull;
		if ( (x instanceof UPIImpl ) && ((UPIImpl)x).isWild() ) return ifNull;
		return validRefOb(x);
    }
	
    // This has a lot of refs as a class method.
	public Object validRef(Object x, Object ifNull) { return validRefOb(x, ifNull); }


	public static Object validRefOrWild(Object x) { return validRefOb(x, UPIImpl.wildUPI()); }


	private String[] validRefObjects(Object[] nodes) {
		// Turn all into strings to make a homegeneous array.
		// Direct encoder likes that better.
		String[] v = new String[nodes.length];
		// look at elements with agjRef to detect EncodedLiteral
		//  instances [bug17163]
		for (int i=0; i<v.length; i++) v[i] = refToString(nodes[i]);
		return v;
	}


	


	public static Object validRangeRef(Object ref) {
		Object v = minMaxRef(ref);
		if ( v!=null ) return v;
		return validRefOrWild(ref);
	}
	


	private String[] validRefValues(Value[] nodes) {
		String[] v = new String[nodes.length];
		// look at elements with agjRef to detect EncodedLiteral
		//  instances [bug17163]
		for (int i=0; i<v.length; i++) v[i] = refToString(nodes[i]);
		return v;
	}



	


	public Object validRefs(Object nodes) {
		if ( nodes instanceof String ) return refToString(nodes);
		if ( nodes instanceof Value ) return refToString(nodes);
		if ( nodes instanceof UPIImpl ) return nodes;
		if ( nodes instanceof Value[] ) return validRefValues((Value[])nodes);
		if ( nodes instanceof String[] ) return validRefStrings((String[])nodes);
		if ( nodes instanceof UPI[] ) return nodes;
		if ( nodes instanceof Object[] ) return validRefObjects((Object[])nodes);
		throw new IllegalArgumentException
		("Cannot map this object to a Value ref or array " + nodes);
	}




	


	/**
	 * Verify a context reference
	 * @param x any thing
	 * @param wildok 0 - only explicit context allowed,
	 *               1 - null or "" denotes the null context
	 *               2 - null is wild, "" not allowed
	 *               3 - null is wild, "" is null context
	 *               4 - null is null, "" not allowed
	 *               5 - like 3 + min/max
	 *               6 - like 4 + min/max
	 * @return
	 */
	public static Object anyContextRef(Object x, int wildok) throws AllegroGraphException {
		if ( x==null )
			switch (wildok) {
			case 1: return UPIImpl.nullUPI();
			case 2: 
			case 3: case 5: return UPIImpl.wildUPI();
			case 4: case 6: return null;
			default: throw new AllegroGraphException("Null is not a valid context");
			}			
		if ( "".equals(x) ) 
			switch (wildok) {
			case 1:
			case 3: case 5: return UPIImpl.nullUPI();
			default: throw new AllegroGraphException("\"\" is not a valid context");
			}
		switch (wildok) {
		case 5:
		case 6:
			Object v = minMaxRef(x);
			if ( v!=null ) return v;
		}
		return validRefOb(x);
	}


	private UPI[] anyContextUPIs(UPI[] x, int wildok) throws AllegroGraphException {
		UPI[] y = new UPI[x.length];
		for (int i = 0; i < x.length; i++) {
			y[i] = (UPI)anyContextRef(x[i], wildok);
		}
		return y;
	}


	private String[] anyContextStrings(String[] x, int wildok) throws AllegroGraphException {
		String[] y = new String[x.length];
		for (int i = 0; i < x.length; i++) {
			y[i] = (String)anyContextRef(x[i], wildok);
		}
		return y;
	}


	private String[] anyContextValues(Value[] x, int wildok) throws AllegroGraphException {
		String[] y = new String[x.length];
		for (int i = 0; i < x.length; i++) {
			y[i] = (String)anyContextRef(x[i], wildok);
		}
		return y;
	}


	public Object anyContextRefs(Object x, int wildok) throws AllegroGraphException {
		if ( x instanceof UPI[] ) return anyContextUPIs((UPI[])x, wildok);
		if ( x instanceof String[] ) return anyContextStrings((String[])x, wildok);
		if ( x instanceof Value[] ) return anyContextValues((Value[])x, wildok);
		//if ( x instanceof Object[] ) return anyContextObjects((Object[])x, wildok);
		return anyContextRef(x, wildok);
	}


	


	public synchronized void discardOldTokens(boolean force) throws AllegroGraphException {
		agbase.discardOldTokens(force);
	}

	
	
	public Object[] applyAGFn( String fn, Object[] args ) throws AllegroGraphException {
		return agbase.verifyEnabled().applyAGFn(agbase, fn, args);
	}
	
}
