package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGDuplicates {

	/**
	 * Demonstrates some basic facts about duplicate triples.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store.
		AllegroGraph ts = ags.renew("duplicates", AGPaths.TRIPLE_STORES);

		// Load some triples
		String ntripleFile = AGPaths.dataSources("test.nt");		
		System.out.println("Loading N-Triples from " + ntripleFile);
		Long n = ts.loadNTriples(ntripleFile);
		System.out.println("Loaded " + n + " triples.");
		
		// Load them again
		System.out.println("Loading them again from " + ntripleFile);
		n = ts.loadNTriples(ntripleFile);
		System.out.println("Loaded another " + n + " triples, totaling: " + ts.numberOfTriples());

		// Get all triples in the store and show them -- note the duplicates.
		TriplesIterator cc = ts.getStatements(null, null, null);
		AGUtils.showTriples(cc);
		
		// Close the triple store and disconnect from the server. 
		ts.closeTripleStore();
		ags.disable();
	}

}
