package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGIndexFlavors {

	/**
	 * Demonstrates managing which indices will be available in a triple store
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to the server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem.", e);
		}

		// Create a triple store
		AllegroGraph ts = ags.renew("indexflavors", AGPaths.TRIPLE_STORES);
		
		// Show the 6 managed indices for a store
		AGUtils.printStringArray("original IndexFlavors: ", ts.getIndexFlavors());
		
		// Instruct the server to manage only 3 indices for the store.  You 
		// might do this to save on disk space and indexing performance if 
		// the store uses a single graph (often the default graph).
		ts.setIndexFlavors(new String[]{"spogi","posgi","ospgi"});
		AGUtils.printStringArray("new IndexFlavors: ", ts.getIndexFlavors());
		
		// Close the triple store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}
}
