package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGLoadStoreInThread extends Thread {

	String store;
	String file;
	
	AGLoadStoreInThread(String store, String file) {
		this.store = store;
		this.file = file;
	}
	
	public void run() {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
			// Create a fresh triple store.
			// AGPaths.TRIPLE_STORES is the directory where stores will 
			// be located, replace it as needed
			AllegroGraph ts = ags.renew(store, AGPaths.TRIPLE_STORES);

			// Load a file into the store's default graph.
			System.out.println("Loading " + store + " from " + file);
			Long n = ts.loadNTriples(file);
			System.out.println("Loaded " + n + " triples into " + store);
		
			// Close the triple store and disconnect from the server.
			ts.closeTripleStore();
			ags.disable();
		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
	}
	
	/**
	 * Demonstrates loading two triple stores in parallel.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// AGPaths.dataSources() returns the full path to the source file
		String file = AGPaths.dataSources("kennedy.ntriples");
		AGLoadStoreInThread p1 = new AGLoadStoreInThread("store1", file);
		AGLoadStoreInThread p2 = new AGLoadStoreInThread("store2", file);
		p1.start();
		p2.start();
	}
	
}
