package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGLoadUsingRapper {

	public static int port = 4567;
	
	/**
	 * Demonstrates loading RDF/XML using the Rapper utility.
	 * 
	 * Rapper can be obtained here: http://librdf.org/raptor/rapper.html
	 * 
	 * Rapper must be installed separately and must be accessible 
	 * from the server.
	 * 
	 * RDF/XML data is piped through Rapper and converted to 
	 * N-Triples before loading.  For large RDF/XML files, it 
	 * can be more efficient to use this Rapper option.  
	 *   
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.setPort(port);
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		
		// Create a fresh triple store.
		AllegroGraph ts = ags.renew("Wine", AGPaths.TRIPLE_STORES);

		// Load RDF/XML using Rapper
		try {
			long start = System.nanoTime();
			long n = ts.loadRDFXML(AGPaths.dataSources("wilburwine.rdf"), "", null, true, false);
			long delta = System.nanoTime() - start;
			System.out.println("Done loading " + n + " triples in " + (delta/1000000000.0) + " seconds.");
			
			// Get some triples and show them.
			TriplesIterator it = ts.getStatements(null, null, null);
			AGUtils.showTriples(it, 20);			
		} catch (IllegalArgumentException e) {
			if (e.getMessage().contains("unable-to-find-rapper-error")) {
				throw new AllegroGraphException("Rapper was not found. Please ensure you have Rapper installed and that it is accessible to the server.");
			} else {
				throw new AllegroGraphException(e.getMessage());
			}
		}

		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
