package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGServerInfo {

	/**
	 * Demonstrates some basics of obtaining server parameters
	 *   
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {

		// Show default parameter settings for server connections
		// Note that you do not need to be connected to a server to
		// obtain this information
		showDefaultConnectionInfo();

		// Connect to a server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Show information about this connection
		showConnectionInstanceInfo(ags);
		
		// Disconnect from the server
		ags.disable();
	}

	
	public static void showDefaultConnectionInfo() {
		System.out.println("Server default settings:");
		System.out.println("  Command: " + AllegroGraphConnection.getDefaultCommand());
		System.out.println("  Debug: " + AllegroGraphConnection.getDefaultDebug());
		System.out.println("  Host: " + AllegroGraphConnection.getDefaultHost());
		System.out.println("  Mode: " + AllegroGraphConnection.getDefaultMode());
		System.out.println("  PollCount: " + AllegroGraphConnection.getDefaultPollCount());
		System.out.println("  PollInterval: " + AllegroGraphConnection.getDefaultPollInterval());
		System.out.println("  Port: " + AllegroGraphConnection.getDefaultPort());
		System.out.println("  Port2: " + AllegroGraphConnection.getDefaultPort2());
		System.out.println("  ServerKeep: " + AllegroGraphConnection.getDefaultServerKeep());
	}

	public static void showConnectionInstanceInfo(AllegroGraphConnection ags) throws AllegroGraphException {
		System.out.println("Server current settings:");
		System.out.println("  ChunkSize: " + ags.getChunkSize());
		System.out.println("  Command: " + ags.getCommand());
		System.out.println("  Debug: " + ags.getDebug());
		System.out.println("  ExpectedResources: " + ags.getDefaultExpectedResources());
		System.out.println("  Host: " + ags.getHost());
		System.out.println("  Mode: " + ags.getMode());
		System.out.println("  PollCount: " + ags.getPollCount());
		System.out.println("  PollInterval: " + ags.getPollInterval());
		System.out.println("  Port: " + ags.getPort());
		System.out.println("  Port2: " + ags.getPort2());
		System.out.println("  ServerKeep: " + ags.getServerKeep());
		System.out.println("  isBusy: " + ags.isBusy());
		System.out.println("  isEnabled: " + ags.isEnabled());
		System.out.println("  serverLevel: " + ags.serverLevel(0));
	}
}