package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSparqlDefaultDatasetBehavior {

	/**
	 * Demonstrates how to specify the Default Dataset Behavior in a SPARQL query.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("sparqldefaultdataset", AGPaths.TRIPLE_STORES);
		
		// Register namespaces
		ts.registerNamespace("ex", "http://example.org/");
		
		// Add some triples to the default graph of each store
		ts.addStatement("!ex:A", "!rdfs:subClassOf", "!ex:B");
		ts.addStatement("!ex:B", "!rdfs:subClassOf", "!ex:C");
		
		// Add some triples to named graphs
		ts.addStatement("!ex:C", "!rdfs:subClassOf", "!ex:D", "!ex:ng1");
		ts.addStatement("!ex:D", "!rdfs:subClassOf", "!ex:E", "!ex:ng2");
		
		AGIndexAllTriples.indexAllTriplesWithTiming(ts);
		
		// A query that leaves the dataset FROM/FROM NAMED unspecified
		String query = "select ?s ?p ?o {?s ?p ?o}";
		
		// Query the store using the dataset {{every graph}, {every graph}}
		// This is also the default behavior for a SPARQL Query
		SPARQLQuery sq = new SPARQLQuery();
		sq.setTripleStore(ts);
		sq.setQuery(query);
		sq.setDefaultDatasetBehaviorAll();
		AGSparqlSelect.doSparqlSelect(sq);

		// Query the store using the dataset {{default},{}}
		sq.setDefaultDatasetBehaviorDefault();
		AGSparqlSelect.doSparqlSelect(sq);

		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}