package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSparqlFiltersInOptionals {

	/**
	 * Demonstrates some basics of using FILTER in OPTIONAL graph patterns.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("sparql", AGPaths.TRIPLE_STORES);
				
		// Register any namespaces
		ts.registerNamespace("dc", "http://purl.org/dc/elements/1.1/");
		ts.registerNamespace("b", "http://example.org/book/");
		ts.registerNamespace("ns", "http://example.org/ns#");

		// Add some data to the store
		ts.addStatement("!b:book1","!dc:title",ts.createLiteral("SPARQL Tutorial"));
		ts.addStatement("!b:book1","!ns:price",ts.createLiteral(42));
		ts.addStatement("!b:book2","!dc:title",ts.createLiteral("The Semantic Web"));
		ts.addStatement("!b:book2","!ns:price",ts.createLiteral(23));

		// Query using a FILTER inside an OPTIONAL graph pattern.  No price 
		// appears for the book with title "SPARQL Tutorial" because the 
		// optional graph pattern did not lead to a solution involving the 
		// variable ?price.
		String query = 
		"PREFIX  dc:  <http://purl.org/dc/elements/1.1/> " +
		"PREFIX  ns:  <http://example.org/ns#> " +
		"SELECT  ?title ?price " +
		"WHERE   { ?x dc:title ?title . " +
				"OPTIONAL { ?x ns:price ?price . FILTER (?price < 30) } " +
				"}";
		
		// Query the store and show the results
		SPARQLQuery sq = new SPARQLQuery();
		sq.setTripleStore(ts);
		sq.setQuery(query);
		AGSparqlSelect.doSparqlSelect(sq);

		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}