/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.impl;

import com.franz.ag.UPI;
import java.nio.CharBuffer;

public class UPIImpl
implements UPI {
    private static final int CODE_LOWEST = -14;
    private static final UPIImpl WILD = new UPIImpl(-1L);
    private static final UPIImpl NULL_CONTEXT = new UPIImpl(-2L);
    static final int WIDTH = 12;
    byte[] upi = null;
    int setWidth = 0;
    long code = -14L;
    int width = 12;

    public byte[] getUpi() {
        return this.upi;
    }

    public static UPI wildUPI() {
        return WILD;
    }

    public static UPIImpl nullUPI() {
        return NULL_CONTEXT;
    }

    static String wildString() {
        return null;
    }

    static String nullString(boolean bl) {
        if (bl) {
            return "";
        }
        return null;
    }

    static String allString() {
        return null;
    }

    public static UPI refNull(UPI uPI) {
        if (uPI == null) {
            return NULL_CONTEXT;
        }
        return uPI;
    }

    static boolean isWild(UPI uPI) {
        if (uPI == null) {
            return true;
        }
        if (uPI instanceof UPIImpl) {
            return ((UPIImpl)uPI).isWild();
        }
        return false;
    }

    public boolean isWild() {
        if (this == WILD) {
            return true;
        }
        if (this.upi != null) {
            return false;
        }
        return UPIImpl.WILD.code == this.code;
    }

    public static boolean isNullContext(UPI uPI) {
        if (uPI == null) {
            return false;
        }
        if (uPI == NULL_CONTEXT) {
            return true;
        }
        if (!(uPI instanceof UPIImpl)) {
            return false;
        }
        UPIImpl uPIImpl = (UPIImpl)uPI;
        if (uPIImpl.upi != null) {
            return false;
        }
        return UPIImpl.NULL_CONTEXT.code == uPIImpl.code;
    }

    public boolean isNullContext() {
        if (this.upi != null) {
            return false;
        }
        return UPIImpl.NULL_CONTEXT.code == this.code;
    }

    public static boolean canReference(UPI uPI) {
        if (UPIImpl.isNullContext(uPI)) {
            return true;
        }
        if (!(uPI instanceof UPIImpl)) {
            return false;
        }
        UPIImpl uPIImpl = (UPIImpl)uPI;
        return uPIImpl.upi != null;
    }

    public boolean canReference() {
        if (this.upi != null) {
            return true;
        }
        return this.isNullContext();
    }

    static boolean hasBody(UPI uPI) {
        if (!(uPI instanceof UPIImpl)) {
            return false;
        }
        UPIImpl uPIImpl = (UPIImpl)uPI;
        return null != uPIImpl.upi;
    }

    boolean hasBody() {
        return null != this.upi;
    }

    public UPIImpl(long l) {
        this.code = l;
        this.width = 0;
    }

    public UPIImpl() {
        this.upi = new byte[12];
    }

    UPIImpl(byte[] byArray) {
        this.upi = new byte[12];
        for (int i = 0; i < byArray.length; ++i) {
            this.upi[i] = byArray[i];
        }
    }

    public long getCode() {
        return this.code;
    }

    public boolean withLabel() {
        return null != this.upi;
    }

    public void addByte(int n) {
        if (this.upi == null) {
            throw new IllegalStateException("Cannot update marker UPI.");
        }
        if (this.setWidth == 12) {
            throw new IllegalStateException("UPI bytes are all there.");
        }
        this.upi[this.setWidth++] = (byte)n;
    }

    public int getByte(int n) {
        if (n < 12) {
            return 0xFF & this.upi[n];
        }
        return -1;
    }

    public String hexByte(int n) {
        String string = Integer.toHexString(this.getByte(n));
        if ("0".equals(string)) {
            string = "00";
        }
        if (2 < string.length()) {
            string = string.substring(string.length() - 2);
        }
        return string;
    }

    public String blankNodeIDString() {
        return this.hexByte(0) + this.hexByte(1) + this.hexByte(2) + this.hexByte(3);
    }

    public long blankNodeID() {
        return this.getByte(0) + 256 * this.getByte(1) + 65536 * this.getByte(2) + 0x1000000 * this.getByte(3);
    }

    public static int compare(UPI uPI, UPI uPI2) {
        if (!(uPI instanceof UPIImpl)) {
            return 0;
        }
        if (!(uPI2 instanceof UPIImpl)) {
            return 0;
        }
        UPIImpl uPIImpl = (UPIImpl)uPI;
        UPIImpl uPIImpl2 = (UPIImpl)uPI2;
        if (uPIImpl.upi == null && uPIImpl2.upi == null) {
            if (uPIImpl.code == uPIImpl2.code) {
                return 0;
            }
            if (uPIImpl.code < uPIImpl2.code) {
                return -1;
            }
            return 1;
        }
        if (uPIImpl.upi == null) {
            return -1;
        }
        if (uPIImpl2.upi == null) {
            return 1;
        }
        byte[] byArray = uPIImpl.upi;
        int n = byArray.length;
        byte[] byArray2 = uPIImpl2.upi;
        int n2 = byArray2.length;
        for (int i = 0; i < n; ++i) {
            if (i >= n2) {
                return 1;
            }
            if (byArray[i] < byArray2[i]) {
                return -1;
            }
            if (byArray[i] <= byArray2[i]) continue;
            return 1;
        }
        return 0;
    }

    CharSequence asHex() {
        CharBuffer charBuffer = CharBuffer.allocate(24);
        for (int i = 0; i < 12; ++i) {
            int n = (0xF0 & this.upi[i]) >> 4;
            int n2 = 0xF & this.upi[i];
            charBuffer.put("0123456789ABCDEF".charAt(n));
            charBuffer.put("0123456789ABCDEF".charAt(n2));
        }
        charBuffer.rewind();
        return charBuffer;
    }

    public CharSequence asChars() {
        CharBuffer charBuffer = CharBuffer.allocate(12);
        for (int i = 0; i < 12; ++i) {
            charBuffer.put(this.upiByteAsChar(i));
        }
        charBuffer.rewind();
        return charBuffer;
    }

    char upiByteAsChar(int n) {
        int n2 = 1 + (0xFF & this.upi[n]);
        return (char)n2;
    }

    public CharSequence asChars(CharSequence charSequence) {
        int n;
        CharBuffer charBuffer = CharBuffer.allocate(12 + charSequence.length());
        for (n = 0; n < charSequence.length(); ++n) {
            charBuffer.put(charSequence.charAt(n));
        }
        for (n = 0; n < 12; ++n) {
            charBuffer.put(this.upiByteAsChar(n));
        }
        charBuffer.rewind();
        return charBuffer;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UPIImpl)) {
            return false;
        }
        UPIImpl uPIImpl = (UPIImpl)object;
        if (this.upi == null && uPIImpl.upi == null) {
            return this.getCode() == uPIImpl.getCode();
        }
        if (this.upi == null || uPIImpl.upi == null) {
            return false;
        }
        for (int i = 0; i < this.upi.length; ++i) {
            if (this.upi[i] == uPIImpl.upi[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        if (this.upi == null) {
            return (int)this.getCode();
        }
        for (int i = 0; i < this.upi.length; ++i) {
            n += this.upi[i] << 8 * (i % 4);
        }
        return n;
    }

    public String toString() {
        if (this.upi != null) {
            return "<UPI " + this.asHex() + ">";
        }
        return "<UPI code=" + this.code + ">";
    }

    public CharSequence getStoreBytes() {
        if (null == this.upi) {
            return "";
        }
        CharBuffer charBuffer = CharBuffer.allocate(8);
        for (int i = 4; i < 8; ++i) {
            int n = (0xF0 & this.upi[i]) >> 4;
            int n2 = 0xF & this.upi[i];
            charBuffer.put("0123456789ABCDEF".charAt(n));
            charBuffer.put("0123456789ABCDEF".charAt(n2));
        }
        charBuffer.rewind();
        return charBuffer;
    }
}

