/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agbase.transport;

import com.franz.ag.AllegroGraphException;
import com.franz.ag.UPI;
import com.franz.agbase.AllegroGraph;
import com.franz.agbase.Triple;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.impl.AGFactory;
import com.franz.agbase.impl.TripleImpl;
import com.franz.agbase.impl.TriplesIteratorImpl;
import com.franz.agbase.impl.UPIImpl;
import com.franz.agbase.impl.ValueNodeImpl;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.transport.AGDirectLink;
import com.franz.agbase.transport.AGDirectLinkDebug;
import com.franz.agbase.util.AGBase;
import com.franz.agbase.util.AGInternals;
import java.io.IOException;
import java.lang.reflect.Array;

public class AGDirectConnector
extends AGConnector {
    AGDirectLink trs = null;

    AGDirectLink verifyLink() {
        if (this.trs == null) {
            throw new IllegalStateException("Cannot use disabled link.");
        }
        return this.trs;
    }

    public int transportVersion() {
        return 2;
    }

    Object tsApply0(AGBase aGBase, String string, Object[] objectArray) throws AllegroGraphException {
        AGDirectConnector.testIndex(aGBase);
        try {
            return this.verifyLink().sendOp3n(":call", 1, 0, "db.agraph.servers::ag-apply", aGBase.tsx, string, objectArray);
        }
        catch (IOException iOException) {
            throw new AllegroGraphException(iOException);
        }
    }

    Object[] tsApplyA(AGBase aGBase, String string, Object[] objectArray) throws AllegroGraphException {
        AGDirectConnector.testIndex(aGBase);
        try {
            return (Object[])this.verifyLink().sendOp3n(":call", 1, -1, "db.agraph.servers::ag-apply", aGBase.tsx, string, objectArray);
        }
        catch (IOException iOException) {
            throw new AllegroGraphException(iOException);
        }
    }

    Object[] applyA(String string, Object[] objectArray) throws AllegroGraphException {
        try {
            return (Object[])this.verifyLink().sendOp1n(":call", 1, -1, string, objectArray);
        }
        catch (IOException iOException) {
            throw new AllegroGraphException(iOException);
        }
    }

    int intValue(Object object) {
        if (object instanceof Long) {
            return (int)((Long)object).longValue();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new IllegalArgumentException("Cannot convert to int " + object);
    }

    int access(String string, String string2, String string3) throws AllegroGraphException {
        return this.access(string, string2, string3, new Object[0]);
    }

    public int access(String string, String string2, String string3, Object[] objectArray) throws AllegroGraphException {
        Object object;
        Object[] objectArray2 = new Object[3 + objectArray.length];
        objectArray2[0] = string;
        objectArray2[1] = string2;
        objectArray2[2] = string3;
        if (0 < objectArray.length && !this.serverLevel(1)) {
            throw new IllegalStateException("Server level < 1");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[3 + i] = objectArray[i];
        }
        try {
            object = this.verifyLink().sendOp1n(":call", 1, 0, "db.agraph.servers::ag-access-triple-store", objectArray2);
        }
        catch (IOException iOException) {
            String string4 = iOException.getMessage();
            int n = string4.indexOf("AGErr");
            if (n < 0) {
                throw new AllegroGraphException(iOException);
            }
            throw new AllegroGraphException(string4.substring(n));
        }
        return (int)AGConnector.longValue(object);
    }

    public Object[] addTriple(AGBase aGBase, Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "ag-add-triple", new Object[]{object, object2, object3, object4, "with-parts", new Integer(1), "sync", aGBase.sync ? "" : null});
        Object[] objectArray2 = new Object[5];
        objectArray2[0] = new Long(AGConnector.longValue(objectArray[2]));
        for (int i = 1; i < 5; ++i) {
            objectArray2[i] = objectArray[i + 2];
        }
        return objectArray2;
    }

    public Object[] addTriples(AGBase aGBase, Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "ag-add-triples", new Object[]{object, object2, object3, object4, "with-parts", new Integer(1), "sync", aGBase.sync ? "" : null});
        long[] lArray = AGDirectConnector.longArray(objectArray[2]);
        Object[] objectArray2 = new Object[]{lArray, null, null, null, null};
        objectArray2[1] = objectArray[3];
        objectArray2[2] = objectArray[4];
        objectArray2[3] = objectArray[5];
        objectArray2[4] = objectArray[6];
        return objectArray2;
    }

    public boolean closeTripleStore(AGBase aGBase, boolean bl) throws AllegroGraphException {
        return 1L == AGDirectConnector.longValue(this.tsApply0(aGBase, "ag-close", new Object[]{bl ? "" : null}));
    }

    public void delete(AGBase aGBase, Object object, Object object2, Object object3, Object object4, boolean bl) throws AllegroGraphException {
        this.tsApply0(aGBase, "ag-delete", new Object[]{object, object2, object3, object4, new Integer(bl ? 1 : 0)});
    }

    public void disable() {
        try {
            this.verifyLink().disconnect();
            this.trs = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void discardCursor(AGBase aGBase, Object object) throws AllegroGraphException {
        this.tsApply0(aGBase, "ag-discard-cursor", new Object[]{object});
    }

    public void discardCursors(AGBase aGBase, Object[] objectArray) throws AllegroGraphException {
        if (16000 < objectArray.length) {
            throw new AllegroGraphException("Too many arguments in call.");
        }
        this.tsApply0(aGBase, "ag-discard-cursor", objectArray);
    }

    public void enable() throws IOException {
        if (this.trs != null) {
            return;
        }
        AGDirectLink.debug(this.debug);
        this.trs = this.debug > 0 ? new AGDirectLinkDebug(this.host, this.port, this.pollCount, this.pollInterval, this.timeout) : new AGDirectLink(this.host, this.port, this.pollCount, this.pollInterval, this.timeout);
    }

    public boolean exists(String string, String string2) throws AllegroGraphException {
        Object object;
        try {
            object = this.verifyLink().sendOp1n(":call", 1, 0, "db.agraph.servers::ag-exists-p", new Object[]{string, string2});
        }
        catch (IOException iOException) {
            throw new AllegroGraphException(iOException);
        }
        return 1L == AGConnector.longValue(object);
    }

    public String getLangPart(AGBase aGBase, UPI uPI) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "ag-get-node-parts", new Object[]{uPI});
        switch ((int)AGConnector.longValue(objectArray[2])) {
            case 4: {
                if (4 >= objectArray.length) break;
                return (String)objectArray[4];
            }
        }
        return null;
    }

    public Object[] getParts(AGBase aGBase, UPI uPI) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "ag-get-node-parts", new Object[]{uPI});
        return new Object[]{new Integer((int)AGConnector.longValue(objectArray[2])), (String)objectArray[3], (String)objectArray[4]};
    }

    public void getParts(AGBase aGBase, UPI[] uPIArray, int[] nArray, String[] stringArray, String[] stringArray2) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "ag-get-node-parts", new Object[]{uPIArray});
        AGDirectConnector.copy(AGDirectConnector.intArray(objectArray[2]), nArray);
        AGDirectConnector.copy(AGDirectConnector.stringArray(objectArray[3]), stringArray);
        AGDirectConnector.copy(AGDirectConnector.stringArray(objectArray[4]), stringArray2);
    }

    public String getTextPart(AGBase aGBase, UPI uPI) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "ag-get-node-parts", new Object[]{uPI});
        switch ((int)AGConnector.longValue(objectArray[2])) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                if (3 >= objectArray.length) break;
                return (String)objectArray[3];
            }
        }
        return null;
    }

    public TriplesIterator getTriples(AllegroGraph allegroGraph, Object object, Object object2, Object object3, Object object4, int n) throws AllegroGraphException {
        Object[] objectArray;
        if (n < 1) {
            n = TriplesIteratorImpl.defaultLookAhead;
        }
        if (4 > (objectArray = this.tsApplyA(allegroGraph, "ag-get-triples", new Object[]{object, object2, object3, object4, new Integer(n), new Integer(1)})).length) {
            return TriplesIteratorImpl.emptyCursor;
        }
        if (4 == objectArray.length) {
            AGFactory.makeCursor(allegroGraph, objectArray[2], AGDirectConnector.toUPIArray(objectArray[3]));
        }
        return AGFactory.makeCursor(allegroGraph, objectArray[2], AGDirectConnector.toUPIArray(objectArray[3]), (String[])objectArray[4]);
    }

    public TriplesIterator getInfTriples(AllegroGraph allegroGraph, Object object, Object object2, Object object3, Object object4, int n, boolean bl) throws AllegroGraphException {
        Object[] objectArray;
        if (n < 1) {
            n = TriplesIteratorImpl.defaultLookAhead;
        }
        if (4 > (objectArray = this.tsApplyA(allegroGraph, "ag-infer-triples", new Object[]{object, object2, object3, object4, new Integer(n), "infer", new Integer(bl ? 1 : 0)})).length) {
            return TriplesIteratorImpl.emptyCursor;
        }
        return AGFactory.makeCursor(allegroGraph, objectArray[3], AGDirectConnector.toUPIArray(objectArray[2]));
    }

    public TriplesIterator getTriples(AllegroGraph allegroGraph, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, int n) throws AllegroGraphException {
        Object[] objectArray;
        if (n < 1) {
            n = TriplesIteratorImpl.defaultLookAhead;
        }
        if (4 > (objectArray = this.tsApplyA(allegroGraph, "ag-get-triple-range", new Object[]{object, object2, object3, object4, object5, object6, object7, object8, new Integer(n), new Integer(1)})).length) {
            return TriplesIteratorImpl.emptyCursor;
        }
        if (4 == objectArray.length) {
            return AGFactory.makeCursor(allegroGraph, objectArray[2], AGDirectConnector.toUPIArray(objectArray[3]));
        }
        return AGFactory.makeCursor(allegroGraph, objectArray[2], AGDirectConnector.toUPIArray(objectArray[3]), (String[])objectArray[4]);
    }

    public Object getTriples(AllegroGraph allegroGraph, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, int n, Object[] objectArray) throws AllegroGraphException {
        if (!this.serverLevel(8)) {
            throw new UnsupportedOperationException("AllegroGraph server is too old.");
        }
        Object[] objectArray2 = new Object[9 + objectArray.length];
        objectArray2[0] = object;
        objectArray2[1] = object2;
        objectArray2[2] = object3;
        objectArray2[3] = object4;
        objectArray2[4] = object5;
        objectArray2[5] = object6;
        objectArray2[6] = object7;
        objectArray2[7] = object8;
        objectArray2[8] = n;
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[9 + i] = objectArray[i];
        }
        Object[] objectArray3 = this.tsApplyA(allegroGraph, "ag-get-triple-range", objectArray2);
        switch (n) {
            case -1: {
                if (3 > objectArray3.length) {
                    return false;
                }
                return true;
            }
            case -5: 
            case -4: 
            case -3: {
                if (3 > objectArray3.length) {
                    return 0;
                }
                return AGDirectConnector.longValue(objectArray3[2]);
            }
        }
        if (4 > objectArray3.length) {
            return TriplesIteratorImpl.emptyCursor;
        }
        if (4 == objectArray3.length) {
            return AGFactory.makeCursor(allegroGraph, objectArray3[2], AGDirectConnector.toUPIArray(objectArray3[3]));
        }
        return AGFactory.makeCursor(allegroGraph, objectArray3[2], AGDirectConnector.toUPIArray(objectArray3[3]), (String[])objectArray3[4]);
    }

    public TriplesIterator getInfTriples(AllegroGraph allegroGraph, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, int n, boolean bl) throws AllegroGraphException {
        Object[] objectArray;
        if (n < 1) {
            n = TriplesIteratorImpl.defaultLookAhead;
        }
        if (4 > (objectArray = this.tsApplyA(allegroGraph, "ag-infer-triple-range", new Object[]{object, object2, object3, object4, object5, object6, object7, object8, new Integer(n), "infer", new Integer(bl ? 1 : 0)})).length) {
            return TriplesIteratorImpl.emptyCursor;
        }
        return AGFactory.makeCursor(allegroGraph, objectArray[3], AGDirectConnector.toUPIArray(objectArray[2]));
    }

    public String getTypePart(AGBase aGBase, UPI uPI) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "ag-get-node-parts", new Object[]{uPI});
        switch ((int)AGConnector.longValue(objectArray[2])) {
            case 5: {
                if (4 >= objectArray.length) break;
                return (String)objectArray[4];
            }
        }
        return null;
    }

    public boolean hasTriple(AGBase aGBase, Object object, Object object2, Object object3, Object object4) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "ag-get-triples", new Object[]{object, object2, object3, object4, new Integer(-1)});
        return 3 <= objectArray.length;
    }

    public boolean hasInfTriple(AGBase aGBase, Object object, Object object2, Object object3, Object object4, boolean bl) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "ag-infer-triples", new Object[]{object, object2, object3, object4, new Integer(-1), "infer", new Integer(bl ? 1 : 0)});
        return 3 <= objectArray.length;
    }

    public void indexAll(AGBase aGBase, boolean bl) throws AllegroGraphException {
        this.tsApply0(aGBase, "ag-all", new Object[]{new Integer(bl ? 1 : 0)});
    }

    public void indexTriples(AGBase aGBase, boolean bl) throws AllegroGraphException {
        this.tsApply0(aGBase, "ag-index", new Object[]{new Integer(bl ? 1 : 0)});
    }

    public long loadNTriples(AGBase aGBase, Object object, Object object2, String string, Object[] objectArray, Boolean bl, String string2) throws AllegroGraphException {
        Object[] objectArray2;
        Integer n = null;
        if (null != bl) {
            n = bl != false ? new Integer(8) : new Integer(4);
        }
        int n2 = 4;
        if (null != string2) {
            n2 += 2;
        }
        Object[] objectArray3 = new Object[n2];
        objectArray3[0] = object;
        objectArray3[1] = object2;
        objectArray3[2] = string;
        objectArray3[3] = n;
        int n3 = 4;
        if (null != string2) {
            objectArray3[n3] = "external-format";
            objectArray3[++n3] = string2;
            ++n3;
        }
        if ((objectArray2 = this.tsApplyA(aGBase, "ag-load", objectArray3)) == null) {
            return 0L;
        }
        if (4 > objectArray2.length) {
            return AGDirectConnector.longValue(objectArray2[2]);
        }
        if (objectArray != null && 0 < objectArray.length) {
            objectArray[0] = objectArray2[3];
        }
        return AGDirectConnector.longValue(objectArray2[2]);
    }

    public long loadRDF(AGBase aGBase, Object object, Object object2, String string, boolean bl) throws AllegroGraphException {
        Object[] objectArray;
        Object[] objectArray2;
        Integer n = null;
        if (bl) {
            n = new Integer(1);
        }
        if ((objectArray2 = this.tsApplyA(aGBase, "ag-rdf", objectArray = null == string ? new Object[]{object, object2, n} : new Object[]{object, object2, n, "base-uri", string})) == null) {
            return 0L;
        }
        if (2 < objectArray2.length) {
            return AGDirectConnector.longValue(objectArray2[2]);
        }
        return -1L;
    }

    public UPIImpl newBlankNode(AGBase aGBase) throws AllegroGraphException {
        Object object = this.tsApply0(aGBase, "ag-new-node", new Object[0]);
        return AGDirectConnector.toUPI(object);
    }

    public UPIImpl newBlankNode(AGBase aGBase, String string) throws AllegroGraphException {
        Object object = this.tsApply0(aGBase, "ag-new-node", new Object[]{string});
        return AGDirectConnector.toUPI(object);
    }

    public UPIImpl[] newBlankNodes(AGBase aGBase, int n) throws AllegroGraphException {
        Object object = this.tsApply0(aGBase, "ag-new-node", new Object[]{new Integer(n)});
        return AGDirectConnector.toUPIArray(object);
    }

    public UPIImpl newLiteral(AGBase aGBase, String string, String string2, String string3) throws AllegroGraphException {
        Object object = this.tsApply0(aGBase, "ag-intern-lit", new Object[]{string, string2, string3});
        return AGDirectConnector.toUPI(object);
    }

    public UPIImpl newLiteral(AGBase aGBase, String string, UPI uPI, String string2) throws AllegroGraphException {
        Object object = this.tsApply0(aGBase, "ag-intern-lit", new Object[]{string, uPI, string2});
        return AGDirectConnector.toUPI(object);
    }

    public UPIImpl[] newLiteral(AGBase aGBase, String[] stringArray, String[] stringArray2, String[] stringArray3) throws AllegroGraphException {
        Object object = this.tsApply0(aGBase, "ag-intern-lit", new Object[]{stringArray, stringArray2, stringArray3});
        return AGDirectConnector.toUPIArray(object);
    }

    public UPIImpl newResource(AGBase aGBase, String string) throws AllegroGraphException {
        Object object = this.tsApply0(aGBase, "ag-intern-res", new Object[]{string});
        return AGDirectConnector.toUPI(object);
    }

    public UPIImpl[] newResources(AGBase aGBase, String[] stringArray) throws AllegroGraphException {
        Object object = this.tsApply0(aGBase, "ag-intern-res", new Object[]{stringArray});
        return AGDirectConnector.toUPIArray(object);
    }

    public UPIImpl[] nextCursor(AGBase aGBase, Object object, int n) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "ag-next", new Object[]{object, new Integer(n)});
        if (3 > objectArray.length) {
            return null;
        }
        return AGDirectConnector.toUPIArray(objectArray[2]);
    }

    public Object[] nextCursorAndParts(AGBase aGBase, Object object, int n) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "ag-next-with-parts", new Object[]{object, new Integer(n)});
        if (4 > objectArray.length) {
            return null;
        }
        return new Object[]{objectArray[2], objectArray[3]};
    }

    public long numberOfTriples(AGBase aGBase) throws AllegroGraphException {
        Object object = this.tsApply0(aGBase, "ag-number", new Object[0]);
        return AGConnector.longValue(object);
    }

    public int query() {
        if (this.trs == null) {
            return -1;
        }
        if (null == this.trs.softLock) {
            return 0;
        }
        return 1;
    }

    public void syncTripleStore(AGBase aGBase) throws AllegroGraphException {
        this.tsApplyA(aGBase, "ag-sync", new Object[0]);
    }

    static String[] stringArray(Object object) {
        if (object == null) {
            return new String[0];
        }
        if (object instanceof String[]) {
            return (String[])object;
        }
        if (object instanceof String) {
            return new String[]{(String)object};
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                stringArray[i] = object2 == null ? null : (object2 instanceof String ? (String)object2 : "Coerced " + object2.toString() + " to String");
            }
            return stringArray;
        }
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                Object object3 = Array.get(object, i);
                stringArray[i] = object3 == null ? null : (object3 instanceof String ? (String)object3 : "Coerced " + object3.toString() + " to String");
            }
            return stringArray;
        }
        return new String[]{"Coerced " + object.toString() + " to String"};
    }

    public TriplesIterator selectTriples(AllegroGraph allegroGraph, String string, Object object, String string2, int n, boolean bl, boolean bl2) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(allegroGraph, "ag-select-triples", new Object[]{string, new Integer(n), "presets", object, "pvars", string2, "use-reasoner", new Boolean(bl), "distinct", new Boolean(bl2)});
        return AGFactory.makeCursor(allegroGraph, objectArray[3], AGDirectConnector.toUPIArray(objectArray[2]));
    }

    public TriplesIterator selectTriples(AllegroGraph allegroGraph, String string, Object[] objectArray, String string2, int n, boolean bl, boolean bl2) throws AllegroGraphException {
        Object[] objectArray2 = this.tsApplyA(allegroGraph, "ag-select-triples", new Object[]{string, new Integer(n), "presets", objectArray, "pvars", string2, "use-reasoner", new Boolean(bl), "distinct", new Boolean(bl2)});
        return AGFactory.makeCursor(allegroGraph, objectArray2[3], AGDirectConnector.toUPIArray(objectArray2[2]));
    }

    public Object[] selectValues(AGBase aGBase, String string, Object[] objectArray, String string2, boolean bl, boolean bl2) throws AllegroGraphException {
        Object[] objectArray2;
        Object[] objectArray3 = new Object[8];
        objectArray3[0] = string2;
        if (objectArray == null) {
            objectArray3[1] = new String[0];
        } else if (0 == objectArray.length) {
            objectArray3[1] = new String[0];
        } else if (objectArray[0] instanceof Long) {
            objectArray2 = new int[objectArray.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray2[i] = (int)((Long)objectArray[i]).longValue();
            }
            objectArray3[1] = objectArray2;
        } else if (objectArray[0] instanceof String) {
            objectArray2 = new String[objectArray.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object = objectArray[i];
                objectArray2[i] = (int)AGInternals.refNtripleString((String)object);
            }
            objectArray3[1] = objectArray2;
        } else if (objectArray[0] instanceof ValueNodeImpl) {
            objectArray2 = new UPI[objectArray.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                ValueNodeImpl valueNodeImpl = (ValueNodeImpl)objectArray[i];
                objectArray2[i] = (int)valueNodeImpl.getAGId();
            }
            objectArray3[1] = objectArray2;
        } else if (objectArray[0] instanceof TripleImpl) {
            objectArray2 = new int[objectArray.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                Triple triple = (Triple)objectArray[i];
                objectArray2[i] = (int)triple.getAGId();
            }
            objectArray3[1] = objectArray2;
        } else {
            throw new IllegalArgumentException("presets object contains unsuitable type");
        }
        objectArray3[2] = string;
        objectArray3[3] = new Integer(aGBase.selectLimit);
        objectArray3[4] = "use-reasoner";
        objectArray3[5] = new Boolean(bl);
        objectArray3[6] = "distinct";
        objectArray3[7] = new Boolean(bl2);
        objectArray2 = this.tsApplyA(aGBase, "ag-select-values", objectArray3);
        return this.valuesResults(objectArray2);
    }

    public Object[] nextValuesArray(AGBase aGBase, Object object, int n) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "ag-next", new Object[]{object, new Integer(n)});
        return this.valuesResults(objectArray);
    }

    Object[] valuesResults(Object[] objectArray) {
        if (10 > objectArray.length) {
            return null;
        }
        Object object = null;
        if (10 < objectArray.length) {
            object = objectArray[10];
        }
        UPIImpl[] uPIImplArray = AGDirectConnector.toUPIArray(objectArray[2]);
        int[] nArray = AGDirectConnector.intArray(objectArray[3]);
        String[] stringArray = AGDirectConnector.stringArray(objectArray[4]);
        String[] stringArray2 = AGDirectConnector.stringArray(objectArray[5]);
        int n = (int)AGConnector.longValue(objectArray[6]);
        int n2 = (int)AGConnector.longValue(objectArray[7]);
        Object object2 = objectArray[8];
        int n3 = (int)AGConnector.longValue(objectArray[9]);
        return new Object[]{uPIImplArray, nArray, stringArray, stringArray2, new Integer(n), new Integer(n2), object2, new Integer(n3), object};
    }

    public void serverTrace(boolean bl, String string) throws AllegroGraphException {
        String string2 = string != null ? string : (bl ? new Integer(1) : new Integer(0));
        try {
            this.verifyLink().sendOp1n(":call", 1, -1, "db.agraph.servers::agj-trace-int", new Object[]{string2});
        }
        catch (IOException iOException) {
            throw new AllegroGraphException(iOException);
        }
    }

    public void serverTrace(AGBase aGBase, boolean bl, String string) throws AllegroGraphException {
        String string2 = string != null ? string : (bl ? new Integer(1) : new Integer(0));
        this.tsApply0(aGBase, "agj-trace-int", new Object[]{string2});
    }

    public void serverTimers(AGBase aGBase, boolean bl, boolean bl2) throws AllegroGraphException {
        int n;
        int n2 = bl ? (bl2 ? 3 : 2) : (n = 0);
        if (aGBase == null) {
            try {
                this.verifyLink().sendOp1n(":call", 1, -1, "db.agraph.servers::agj-trace-int", new Object[]{n});
            }
            catch (IOException iOException) {
                throw new AllegroGraphException(iOException);
            }
            return;
        }
        this.tsApply0(aGBase, "agj-trace-int", new Object[]{n});
    }

    public long[] getTimers(AGBase aGBase) throws AllegroGraphException {
        return AGDirectConnector.longArray(this.serverOptionAll("timers", aGBase == null ? null : Integer.valueOf(aGBase.tsx)));
    }

    public long serverId() throws AllegroGraphException {
        try {
            Object object = this.verifyLink().sendOp1n(":call", 1, 0, "db.agraph.servers::agj-trace-int", new Object[]{new Integer(-2)});
            return AGConnector.longValue(object);
        }
        catch (IOException iOException) {
            throw new AllegroGraphException(iOException);
        }
    }

    public int interruptServer(long l) throws AllegroGraphException {
        if (l < 101L) {
            return -4;
        }
        try {
            Object object = this.verifyLink().sendOp1n(":call", 1, 0, "db.agraph.servers::agj-trace-int", new Object[]{new Long(l)});
            return AGConnector.toInt(object);
        }
        catch (IOException iOException) {
            throw new AllegroGraphException(iOException);
        }
    }

    public boolean serverLevel(int n) throws AllegroGraphException {
        if (this.currentServerLevel < 0) {
            try {
                Object object = this.verifyLink().sendOp1n(":call", 1, 0, "db.agraph.servers::agj-trace-int", new Object[]{new Integer(100)});
                this.currentServerLevel = (int)AGConnector.longValue(object);
            }
            catch (IOException iOException) {
                throw new AllegroGraphException(iOException);
            }
        }
        return n <= this.currentServerLevel;
    }

    Object[] valuesOnly(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length - 2];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = objectArray[i + 2];
        }
        return objectArray2;
    }

    public Object[] evalInServer(AGBase aGBase, String string) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "agj-eval", new Object[]{string});
        return this.valuesOnly(objectArray);
    }

    public Object[] evalInServer(String string) throws AllegroGraphException {
        Object object;
        try {
            object = this.verifyLink().sendOp1n(":call", 1, -1, "db.agraph.servers::agj-eval", new Object[]{string});
        }
        catch (IOException iOException) {
            throw new AllegroGraphException(iOException);
        }
        return this.valuesOnly((Object[])object);
    }

    public UPIImpl[] getTripleParts(AGBase aGBase, long l) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "ag-get-triple-parts", new Object[]{new Long(l)});
        if (6 > objectArray.length) {
            return null;
        }
        return new UPIImpl[]{AGDirectConnector.toUPI(objectArray[2]), AGDirectConnector.toUPI(objectArray[3]), AGDirectConnector.toUPI(objectArray[4]), AGDirectConnector.toUPI(objectArray[5])};
    }

    public boolean twinqlAsk(AGBase aGBase, String string, boolean bl) throws AllegroGraphException {
        return this.twinqlAsk(aGBase, string, bl, null);
    }

    public boolean twinqlAsk(AGBase aGBase, String string, boolean bl, Object[] objectArray) throws AllegroGraphException {
        int n = null == objectArray ? 0 : objectArray.length;
        Object[] objectArray2 = new Object[3 + n];
        objectArray2[0] = string;
        objectArray2[1] = "use-reasoner";
        objectArray2[2] = new Boolean(bl);
        for (int i = 0; i < n; ++i) {
            objectArray2[3 + i] = objectArray[i];
        }
        Object object = this.tsApply0(aGBase, "ag-twinql-ask", new Object[]{string});
        return 1L == AGConnector.longValue(object);
    }

    public Object[] twinqlSelect(AGBase aGBase, String string, String string2, int n, int n2, int n3, boolean bl) throws AllegroGraphException {
        return this.twinqlSelect(aGBase, string, string2, n, n2, n3, bl, null);
    }

    public Object[] twinqlSelect(AGBase aGBase, String string, String string2, int n, int n2, int n3, boolean bl, Object[] objectArray) throws AllegroGraphException {
        int n4 = null == objectArray ? 0 : objectArray.length;
        Object[] objectArray2 = new Object[8 + n4];
        objectArray2[0] = string;
        objectArray2[1] = string2;
        objectArray2[2] = new Integer(n);
        objectArray2[3] = new Integer(n2);
        objectArray2[4] = "slimit";
        objectArray2[5] = new Integer(n3);
        objectArray2[6] = "use-reasoner";
        objectArray2[7] = new Boolean(bl);
        for (int i = 0; i < n4; ++i) {
            objectArray2[8 + i] = objectArray[i];
        }
        Object[] objectArray3 = this.tsApplyA(aGBase, "ag-twinql-select", objectArray2);
        if (n3 == -1) {
            return this.valuesOnly(objectArray3);
        }
        return this.valuesResults(objectArray3);
    }

    public TriplesIterator twinqlFind(AllegroGraph allegroGraph, String string, int n, int n2, int n3, boolean bl) throws AllegroGraphException {
        return this.twinqlFind(allegroGraph, string, n, n2, n3, bl, null);
    }

    public TriplesIterator twinqlFind(AllegroGraph allegroGraph, String string, int n, int n2, int n3, boolean bl, Object[] objectArray) throws AllegroGraphException {
        return this.twinqlFindTriples("ag-twinql-find", allegroGraph, string, n, n2, n3, bl, objectArray);
    }

    public TriplesIterator twinqlConstruct(AllegroGraph allegroGraph, String string, int n, int n2, int n3, boolean bl, Object[] objectArray) throws AllegroGraphException {
        return this.twinqlFindTriples("ag-twinql-construct", allegroGraph, string, n, n2, n3, bl, objectArray);
    }

    public TriplesIterator twinqlDescribe(AllegroGraph allegroGraph, String string, int n, int n2, int n3, boolean bl, Object[] objectArray) throws AllegroGraphException {
        return this.twinqlFindTriples("ag-twinql-describe", allegroGraph, string, n, n2, n3, bl, objectArray);
    }

    TriplesIterator twinqlFindTriples(String string, AllegroGraph allegroGraph, String string2, int n, int n2, int n3, boolean bl, Object[] objectArray) throws AllegroGraphException {
        int n4 = null == objectArray ? 0 : objectArray.length;
        Object[] objectArray2 = new Object[7 + n4];
        objectArray2[0] = string2;
        objectArray2[1] = new Integer(n);
        objectArray2[2] = new Integer(n2);
        objectArray2[3] = "slimit";
        objectArray2[4] = new Integer(n3);
        objectArray2[5] = "use-reasoner";
        objectArray2[6] = new Boolean(bl);
        for (int i = 0; i < n4; ++i) {
            objectArray2[7 + i] = objectArray[i];
        }
        Object[] objectArray3 = this.tsApplyA(allegroGraph, string, objectArray2);
        String string3 = null;
        if (3 < objectArray3.length) {
            string3 = (String)objectArray3[3];
        }
        return AGFactory.makeCursor(allegroGraph, string3, AGDirectConnector.toUPIArray(objectArray3[2]));
    }

    public String twinqlQuery(AGBase aGBase, String string, String string2, int n, int n2, boolean bl) throws AllegroGraphException {
        return this.twinqlQuery(aGBase, string, string2, n, n2, bl, null);
    }

    public String twinqlQuery(AGBase aGBase, String string, String string2, int n, int n2, boolean bl, Object[] objectArray) throws AllegroGraphException {
        int n3 = null == objectArray ? 0 : objectArray.length;
        Object[] objectArray2 = new Object[6 + n3];
        objectArray2[0] = string;
        objectArray2[1] = string2;
        objectArray2[2] = new Integer(n);
        objectArray2[3] = new Integer(n2);
        objectArray2[4] = "use-reasoner";
        objectArray2[5] = new Boolean(bl);
        for (int i = 0; i < n3; ++i) {
            objectArray2[6 + i] = objectArray[i];
        }
        Object object = this.tsApply0(aGBase, "ag-twinql-query", objectArray2);
        return (String)object;
    }

    public Object indexing(AGBase aGBase, int n, int n2, String[] stringArray) throws AllegroGraphException {
        return this.tsApply0(aGBase, "ag-indexing", new Object[]{new Integer(n), new Integer(n2), stringArray});
    }

    public Object mapping(AGBase aGBase, int n, String[] stringArray) throws AllegroGraphException {
        return this.tsApply0(aGBase, "ag-mapping", new Object[]{new Integer(n), stringArray});
    }

    public String[] namespaces(AGBase aGBase, String[] stringArray) throws AllegroGraphException {
        Object object = this.tsApply0(aGBase, "agj-namespaces", new Object[]{stringArray});
        String[] stringArray2 = AGDirectConnector.stringArray(object);
        return stringArray2;
    }

    public Object[] addPart(AGBase aGBase, String string) throws AllegroGraphException {
        if (this.serverLevel(2)) {
            Object[] objectArray = this.tsApplyA(aGBase, "ag-add-part", new Object[]{string});
            return this.valuesOnly(objectArray);
        }
        throw new IllegalStateException("Server does not support addPart()");
    }

    public String[] freetextPredicates(AGBase aGBase, Object object) throws AllegroGraphException {
        Object object2 = this.tsApply0(aGBase, "ag-freetext-predicates", new Object[]{object});
        if (object2 instanceof String[]) {
            return (String[])object2;
        }
        return new String[0];
    }

    public TriplesIterator getFreetextStatements(AllegroGraph allegroGraph, String string, int n) throws AllegroGraphException {
        if (n == 0) {
            n = TriplesIteratorImpl.defaultLookAhead;
        }
        Object[] objectArray = this.tsApplyA(allegroGraph, "ag-freetext-statements", new Object[]{string, new Integer(n), new Integer(1)});
        if (n < 0) {
            if (2 == objectArray.length) {
                return null;
            }
            return TriplesIteratorImpl.emptyCursor;
        }
        if (4 > objectArray.length) {
            return TriplesIteratorImpl.emptyCursor;
        }
        if (4 == objectArray.length) {
            return AGFactory.makeCursor(allegroGraph, objectArray[2], AGDirectConnector.toUPIArray(objectArray[3]));
        }
        return AGFactory.makeCursor(allegroGraph, objectArray[2], AGDirectConnector.toUPIArray(objectArray[3]), (String[])objectArray[4]);
    }

    public Object[] getFreetextSubjects(AGBase aGBase, String string, int n) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "ag-freetext-subjects", new Object[]{string, new Integer(n)});
        return this.valuesResults(objectArray);
    }

    public int federate(String string, int[] nArray, boolean bl) throws AllegroGraphException {
        Object object;
        try {
            object = this.verifyLink().sendOp1n(":call", 1, 0, "db.agraph.servers::ag-federate", new Object[]{string, nArray, "if-exists", bl ? "supersede" : null});
        }
        catch (IOException iOException) {
            throw new AllegroGraphException(iOException);
        }
        return (int)AGDirectConnector.longValue(object);
    }

    public Object[] findStore(String string, String string2, Object object) throws AllegroGraphException {
        Object object2;
        try {
            object2 = this.verifyLink().sendOp1n(":call", 1, -1, "db.agraph.servers::ag-find-store", new Object[]{string, string2, null, object == null ? "ignore" : "delete", object == null ? null : "delete"});
        }
        catch (IOException iOException) {
            throw new AllegroGraphException(iOException);
        }
        Object[] objectArray = (Object[])object2;
        if (5 > objectArray.length) {
            return null;
        }
        return new Object[]{new Integer((int)AGDirectConnector.longValue(objectArray[2])), objectArray[3], objectArray[4]};
    }

    public Object[] getStores(AGBase aGBase) throws AllegroGraphException {
        Object[] objectArray = this.tsApplyA(aGBase, "ag-get-stores", new Object[0]);
        if (3 == objectArray.length) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length - 2];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = 0 == i % 3 ? new Integer((int)AGDirectConnector.longValue(objectArray[i + 2])) : objectArray[i + 2];
        }
        return objectArray2;
    }

    public Object serializeTriples(AGBase aGBase, Object[] objectArray) throws AllegroGraphException {
        Object[] objectArray2 = this.tsApplyA(aGBase, "ag-serialize-triples", objectArray);
        if (2 < objectArray2.length) {
            return objectArray2[2];
        }
        return null;
    }

    public Object[] applyAGFn(AGBase aGBase, String string, Object[] objectArray) throws AllegroGraphException {
        Object[] objectArray2 = this.tsApplyA(aGBase, string, objectArray);
        if (null == objectArray2) {
            return new Object[0];
        }
        if (3 > objectArray2.length) {
            return new Object[0];
        }
        Object[] objectArray3 = new Object[objectArray2.length - 2];
        for (int i = 0; i < objectArray3.length; ++i) {
            objectArray3[i] = objectArray2[i + 2];
        }
        return objectArray3;
    }

    public Object[] applyFn(String string, Object[] objectArray) throws AllegroGraphException {
        Object[] objectArray2 = this.applyA(string, objectArray);
        if (null == objectArray2) {
            return new Object[0];
        }
        if (3 > objectArray2.length) {
            return new Object[0];
        }
        Object[] objectArray3 = new Object[objectArray2.length - 2];
        for (int i = 0; i < objectArray3.length; ++i) {
            objectArray3[i] = objectArray2[i + 2];
        }
        return objectArray3;
    }

    public Object serverOptionOne(Object ... objectArray) throws AllegroGraphException {
        Object[] objectArray2 = this.applyA("db.agraph.servers::agj-server-options", objectArray);
        if (null == objectArray2) {
            return null;
        }
        if (3 > objectArray2.length) {
            return null;
        }
        return objectArray2[2];
    }

    public Object serverOptionAll(Object ... objectArray) throws AllegroGraphException {
        return this.applyFn("db.agraph.servers::agj-server-options", objectArray);
    }

    public Object[] clientOption(AGBase aGBase, Object ... objectArray) throws AllegroGraphException {
        return this.applyAGFn(aGBase, "ag-client-options", objectArray);
    }
}

