/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agjena;

import com.franz.agbase.AllegroGraphException;
import com.franz.agjena.AllegroGraphGraph;
import com.franz.agjena.JenaToAGManager;
import com.franz.agjena.exceptions.NiceException;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AGBulkUpdateHandler
extends SimpleBulkUpdateHandler
implements BulkUpdateHandler {
    public AGBulkUpdateHandler(GraphWithPerform graphWithPerform) {
        super(graphWithPerform);
    }

    private String[] makeArray(String[] stringArray, int n) {
        if (stringArray == null) {
            return new String[n];
        }
        if (n == stringArray.length) {
            return stringArray;
        }
        return new String[n];
    }

    private void setArrays(AllegroGraphGraph allegroGraphGraph, Triple triple, int n, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        JenaToAGManager jenaToAGManager = allegroGraphGraph.getJ2AG();
        stringArray[n] = jenaToAGManager.jenaNodeToAgStringTerm(triple.getSubject());
        stringArray2[n] = jenaToAGManager.jenaNodeToAgStringTerm(triple.getPredicate());
        stringArray3[n] = jenaToAGManager.jenaNodeToAgStringTerm(triple.getObject());
        stringArray4[n] = allegroGraphGraph.getContextArgumentString();
    }

    protected void add(List list, boolean bl) {
        this.perform(list, null, false, bl);
    }

    protected void delete(List list, boolean bl) {
        this.perform(list, null, true, bl);
    }

    public void add(Triple[] tripleArray) {
        this.perform(null, tripleArray, false, true);
    }

    public void delete(Triple[] tripleArray) {
        this.perform(null, tripleArray, true, true);
    }

    private void perform(List<Triple> list, Triple[] tripleArray, boolean bl, boolean bl2) {
        int n;
        AllegroGraphGraph allegroGraphGraph;
        int n2;
        int n3 = 0;
        if (null == list) {
            n3 = tripleArray.length;
        }
        if (null == tripleArray) {
            n3 = list.size();
        }
        if ((n2 = (allegroGraphGraph = (AllegroGraphGraph)this.graph).getAllegroGraphStore().getSelectLimit()) < 1000) {
            n2 = 1000;
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        int n4 = 0;
        for (int i = n3; 0 < i; i -= n) {
            n = i < n2 ? i : n2;
            stringArray = this.makeArray(stringArray, n);
            stringArray2 = this.makeArray(stringArray2, n);
            stringArray3 = this.makeArray(stringArray3, n);
            stringArray4 = this.makeArray(stringArray4, n);
            for (int j = 0; j < n; ++j) {
                Triple triple = null;
                if (null == tripleArray) {
                    triple = list.get(n4);
                }
                if (null == list) {
                    triple = tripleArray[n4];
                }
                this.setArrays(allegroGraphGraph, triple, j, stringArray, stringArray2, stringArray3, stringArray4);
                ++n4;
            }
            try {
                if (bl) {
                    allegroGraphGraph.getAGConnector().delete(allegroGraphGraph.getAllegroGraphStore(), stringArray, stringArray2, stringArray3, stringArray4, false);
                    continue;
                }
                allegroGraphGraph.getAGConnector().addTriples(allegroGraphGraph.getAllegroGraphStore(), stringArray, stringArray2, stringArray3, stringArray4);
                continue;
            }
            catch (AllegroGraphException allegroGraphException) {
                throw new NiceException(allegroGraphException);
            }
        }
        if (null == tripleArray && bl2) {
            if (bl) {
                this.manager.notifyDeleteList((Graph)this.graph, list);
            } else {
                this.manager.notifyAddList((Graph)this.graph, list);
            }
        }
        if (null == list) {
            if (bl) {
                this.manager.notifyDeleteArray((Graph)this.graph, tripleArray);
            } else {
                this.manager.notifyAddArray((Graph)this.graph, tripleArray);
            }
        }
    }
}

