/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agjena;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.DefaultGraph;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.TriplesQuery;
import com.franz.agbase.URINode;
import com.franz.agbase.impl.AGFactory;
import com.franz.agbase.impl.ResourceNodeImpl;
import com.franz.agbase.transport.AGConnector;
import com.franz.agbase.util.AGInternals;
import com.franz.agjena.AGBulkUpdateHandler;
import com.franz.agjena.AGTripleIterator;
import com.franz.agjena.AllegroGraphGraphMaker;
import com.franz.agjena.AllegroGraphReasoner;
import com.franz.agjena.EmptyExtendedIterator;
import com.franz.agjena.JenaToAGManager;
import com.franz.agjena.Utils;
import com.franz.agjena.exceptions.NiceException;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import org.apache.log4j.Logger;

public class AllegroGraphGraph
extends BaseInfGraph {
    private static Logger logger = Logger.getLogger(AllegroGraphGraph.class);
    private ResourceNodeImpl graphResource;
    private JenaToAGManager j2ag = null;
    private boolean isTheDefaultGraph = false;
    private boolean isGraphOfAllGraphs = false;
    private boolean inferenceEnabled = false;
    private static String INF_SUFFIX = "_INF";

    private String generateLegalURI(String string) {
        if (Utils.isLegalURI(string)) {
            return string;
        }
        return Utils.uriFromBNodeId(string);
    }

    public AllegroGraphGraph(AllegroGraph allegroGraph, String string, Reasoner reasoner) {
        super(null, reasoner, ReificationStyle.Minimal);
        this.fdata = new FGraph((Graph)this);
        if (reasoner != null && !(reasoner instanceof AllegroGraphReasoner)) {
            logger.warn((Object)"Hooking up to a non-AllegroGraph reasoner has not been tested, and may not perform.");
        }
        try {
            this.graphResource = AllegroGraphGraphMaker.DEFAULT_GRAPH_NAME.equals(string) || Utils.isNullString(string) ? (ResourceNodeImpl)((Object)AGFactory.makeDefaultGraph(allegroGraph, null)) : (ResourceNodeImpl)((Object)allegroGraph.addURI(this.generateLegalURI(string)));
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new NiceException("Failed to create the graph named " + string);
        }
        this.j2ag = new JenaToAGManager(allegroGraph);
    }

    public AllegroGraphGraph(AllegroGraph allegroGraph, String string) {
        this(allegroGraph, string, null);
    }

    public AllegroGraphGraph(Graph graph, Reasoner reasoner) {
        this(((AllegroGraphGraph)graph).getAllegroGraphStore(), ((AllegroGraphGraph)graph).getName() + "_INF", reasoner);
        if (!(graph instanceof AllegroGraphGraph)) {
            throw new NiceException("A non-AllegroGraphGraph may not be passed to the 'AllegroGraphGraph' constructor.");
        }
        this.fdata = new FGraph(graph);
    }

    public AllegroGraphGraph(Graph graph, Reasoner reasoner, ReificationStyle reificationStyle) {
        this(graph, reasoner);
    }

    public String getName() {
        if (this.graphResource instanceof DefaultGraph) {
            return null;
        }
        if (this.isTheDefaultGraph) {
            return null;
        }
        String string = ((URINode)((Object)this.graphResource)).getURI();
        if (string.endsWith(INF_SUFFIX)) {
            return null;
        }
        return string;
    }

    protected String getCovertName() {
        if (this.graphResource instanceof DefaultGraph) {
            return "";
        }
        String string = ((URINode)((Object)this.graphResource)).getURI();
        return string;
    }

    public String toString() {
        return "|Graph|" + this.getCovertName();
    }

    public boolean isTheRealHonestToGoodnessDefaultGraph() {
        return this.isTheDefaultGraph;
    }

    protected void setIsTheDefaultGraph(boolean bl) {
        this.isTheDefaultGraph = bl;
    }

    public boolean isGraphOfAllGraphs() {
        return this.isGraphOfAllGraphs;
    }

    protected void setIsGraphOfAllGraphs(boolean bl) {
        this.isGraphOfAllGraphs = bl;
    }

    public boolean isRDFSPlusPlusGraph() {
        return this.inferenceEnabled || this.reasoner != null && this.reasoner instanceof AllegroGraphReasoner;
    }

    public JenaToAGManager getJ2AG() {
        return this.j2ag;
    }

    public AllegroGraph getAllegroGraphStore() {
        return this.j2ag.getAGStore();
    }

    public AGConnector getAGConnector() {
        return this.j2ag.getAGStore().verifyEnabled();
    }

    public String getContextArgumentString() {
        Object object = this.getContextArgumentTerm();
        if (object instanceof String) {
            return (String)object;
        }
        return this.j2ag.getAGStore().refToString(object);
    }

    public Object getContextArgumentObject() {
        return this.graphResource;
    }

    public Object getContextArgumentTerm() {
        try {
            return AGInternals.validRefOb(this.graphResource);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new NiceException(illegalArgumentException);
        }
    }

    public void performAdd(Triple triple) {
        try {
            this.j2ag.getAGStore().verifyEnabled().addTriple(this.j2ag.getAGStore(), this.j2ag.jenaNodeToAGTerm(triple.getSubject()), this.j2ag.jenaNodeToAGTerm(triple.getPredicate()), this.j2ag.jenaNodeToAGTerm(triple.getObject()), this.getContextArgumentTerm());
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new NiceException("Illegal argument exception", allegroGraphException);
        }
    }

    public void performDelete(Triple triple) {
        try {
            this.j2ag.getAGStore().verifyEnabled().delete(this.j2ag.getAGStore(), this.j2ag.jenaNodeToAGTerm(triple.getSubject()), this.j2ag.jenaNodeToAGTerm(triple.getPredicate()), this.j2ag.jenaNodeToAGTerm(triple.getObject()), this.getContextArgumentTerm(), false);
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new IllegalArgumentException(allegroGraphException.toString());
        }
    }

    public void removeAll(Node node, Node node2, Node node3) {
        try {
            this.j2ag.getAGStore().verifyEnabled().delete(this.j2ag.getAGStore(), this.j2ag.jenaNodeToAGTerm(node, true), this.j2ag.jenaNodeToAGTerm(node2, true), this.j2ag.jenaNodeToAGTerm(node3, true), this.getContextArgumentTerm(), true);
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new JenaException("Failure in removeAll", (Throwable)allegroGraphException);
        }
    }

    public int graphBaseSize() {
        long l = 0L;
        try {
            TriplesQuery triplesQuery = new TriplesQuery();
            triplesQuery.setContext(this.graphResource);
            l = triplesQuery.count(this.j2ag.getAGStore());
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new NiceException(allegroGraphException);
        }
        return (int)l;
    }

    public boolean isEmpty() {
        return 0 == this.graphBaseSize();
    }

    public ExtendedIterator graphBaseFind(TripleMatch tripleMatch) {
        TriplesIterator triplesIterator;
        try {
            triplesIterator = this.j2ag.getAGStore().verifyEnabled().getInfTriples(this.j2ag.getAGStore(), this.j2ag.jenaNodeToAGTerm(tripleMatch.getMatchSubject(), true), this.j2ag.jenaNodeToAGTerm(tripleMatch.getMatchPredicate(), true), this.j2ag.jenaNodeToAGTerm(tripleMatch.getMatchObject(), true), this.getContextArgumentTerm(), 0, this.isRDFSPlusPlusGraph());
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new IllegalArgumentException(allegroGraphException.toString());
        }
        return new AGTripleIterator(this, triplesIterator);
    }

    public boolean inferenceEnabled() {
        return this.isRDFSPlusPlusGraph();
    }

    public void setInferenceEnabled(boolean bl) {
        this.inferenceEnabled = bl;
    }

    public QueryHandler queryHandler() {
        if (this.queryHandler == null) {
            this.queryHandler = new SimpleQueryHandler((Graph)this);
        }
        return this.queryHandler;
    }

    public Reifier constructReifier() {
        return new SimpleReifier((GraphBase)this, ReificationStyle.Minimal);
    }

    public PrefixMapping getPrefixMapping() {
        return this.pm;
    }

    public Reasoner getReasoner() {
        if (this.reasoner == null) {
            this.reasoner = new AllegroGraphReasoner();
        }
        return this.reasoner;
    }

    public ExtendedIterator findWithContinuation(TriplePattern triplePattern, Finder finder) {
        if (finder == null) {
            return new EmptyExtendedIterator();
        }
        return finder.find(triplePattern);
    }

    public Graph getSchemaGraph() {
        return null;
    }

    public void close() {
    }

    public ResourceNodeImpl getGraphResource() {
        return this.graphResource;
    }

    public TransactionHandler getTransactionHandler() {
        return new InfTransactionHandler(this);
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new AGBulkUpdateHandler((GraphWithPerform)this);
        }
        return this.bulkHandler;
    }

    public static class InfTransactionHandler
    extends BaseInfGraph.InfTransactionHandler {
        public InfTransactionHandler(BaseInfGraph baseInfGraph) {
            super(baseInfGraph);
        }

        public boolean transactionsSupported() {
            return false;
        }
    }
}

