/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agjena;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.PrologSelectQuery;
import com.franz.agbase.URINode;
import com.franz.agbase.ValueObject;
import com.franz.agbase.ValueSetIterator;
import com.franz.agjena.AllegroGraphGraph;
import com.franz.agjena.exceptions.NiceException;
import com.franz.agjena.exceptions.UnimplementedMethodException;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.BaseGraphMaker;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.DoesNotExistException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllegroGraphGraphMaker
extends BaseGraphMaker {
    private AllegroGraph agStore;
    private AllegroGraphGraph defaultGraph = null;
    private static AllegroGraphGraphMaker ALLEGRO_GRAPH_GRAPH_MAKER = null;
    private Map<String, AllegroGraphGraph> namedGraphIndex = new HashMap<String, AllegroGraphGraph>();
    protected static String DEFAULT_GRAPH_NAME = "DeFaUlTgRaPh";

    public AllegroGraphGraphMaker(AllegroGraph allegroGraph) {
        super(ReificationStyle.Minimal);
        this.agStore = allegroGraph;
    }

    public static void setDefaultMaker(AllegroGraph allegroGraph) {
        ALLEGRO_GRAPH_GRAPH_MAKER = new AllegroGraphGraphMaker(allegroGraph);
    }

    public static AllegroGraphGraphMaker getInstance() {
        return ALLEGRO_GRAPH_GRAPH_MAKER;
    }

    public void setDefaultIsGraphOfAllGraphs(boolean bl) {
        AllegroGraphGraph allegroGraphGraph = (AllegroGraphGraph)this.getDefaultGraph();
        allegroGraphGraph.setIsGraphOfAllGraphs(bl);
    }

    public Graph createGraph(String string, boolean bl) {
        AllegroGraphGraph allegroGraphGraph = this.namedGraphIndex.get(string);
        if (allegroGraphGraph != null) {
            if (bl) {
                throw new NiceException("Attempt to create graph named '" + string + "'\n when one with the same name already exists.");
            }
            return allegroGraphGraph;
        }
        allegroGraphGraph = new AllegroGraphGraph(this.agStore, string);
        this.namedGraphIndex.put(string, allegroGraphGraph);
        return allegroGraphGraph;
    }

    public Graph openGraph(String string, boolean bl) {
        Graph graph = (Graph)this.namedGraphIndex.get(string);
        if (graph != null) {
            return graph;
        }
        if (bl) {
            throw new DoesNotExistException("Can't open non-existent graph named '" + string + "'");
        }
        return this.createGraph(string);
    }

    public void removeGraph(String string) {
        AllegroGraphGraph allegroGraphGraph = (AllegroGraphGraph)this.openGraph(string, true);
        allegroGraphGraph.close();
        throw new UnimplementedMethodException("removeGraph. Graph deletion is not implemented.");
    }

    public boolean hasGraph(String string) {
        return this.namedGraphIndex.get(string) != null;
    }

    public Node getMakerClass() {
        String string = "AllegroGraphMakerSpec";
        return ResourceFactory.createResource((String)("http://jena.hpl.hp.com/2003/08/jms#" + string)).asNode();
    }

    protected void augmentDescription(Graph graph, Node node) {
        throw new UnimplementedMethodException("augmentDescription");
    }

    public void close() {
        throw new UnimplementedMethodException("getGraphMaker");
    }

    public List<String> getGraphURIs() {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            PrologSelectQuery prologSelectQuery = new PrologSelectQuery();
            prologSelectQuery.setQuery(new String[]{"g"}, "(q- ? ? ? ?g)");
            prologSelectQuery.setDistinct(true);
            ValueSetIterator valueSetIterator = prologSelectQuery.run(this.agStore);
            while (valueSetIterator.hasNext()) {
                ValueObject valueObject = valueSetIterator.next(0);
                if (!(valueObject instanceof URINode)) continue;
                arrayList.add(((URINode)valueObject).getURI());
            }
            return arrayList;
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new NiceException("", allegroGraphException);
        }
    }

    public ExtendedIterator listGraphs() {
        final ArrayList<AllegroGraphGraph> arrayList = new ArrayList<AllegroGraphGraph>();
        final AllegroGraphGraphMaker allegroGraphGraphMaker = this;
        for (AllegroGraphGraph allegroGraphGraph : this.namedGraphIndex.values()) {
            arrayList.add(allegroGraphGraph);
        }
        return new NiceIterator(){
            private Iterator<AllegroGraphGraph> cursor;
            private AllegroGraphGraph currentGraph;
            {
                this.cursor = arrayList.iterator();
                this.currentGraph = null;
            }

            public boolean hasNext() {
                return this.cursor.hasNext();
            }

            public Object next() {
                if (!this.hasNext()) {
                    return null;
                }
                this.currentGraph = this.cursor.next();
                return this.currentGraph.getName();
            }

            public void close() {
            }

            public void remove() {
                this.cursor.remove();
                if (this.currentGraph != null) {
                    allegroGraphGraphMaker.removeGraph(this.currentGraph.getName());
                }
            }

            public ExtendedIterator andThen(ClosableIterator closableIterator) {
                throw new UnimplementedMethodException("listGraphs.andThen");
            }
        };
    }

    public Graph getGraph() {
        return this.getDefaultGraph();
    }

    public Graph openGraph() {
        if (this.defaultGraph == null) {
            throw new DoesNotExistException("no default graph in this GraphMaker [" + ((Object)((Object)this)).getClass() + "]");
        }
        return this.defaultGraph;
    }

    public Graph getDefaultGraph() {
        if (this.defaultGraph == null) {
            this.defaultGraph = (AllegroGraphGraph)this.createGraph(DEFAULT_GRAPH_NAME);
            this.defaultGraph.setIsTheDefaultGraph(true);
            this.namedGraphIndex.remove(DEFAULT_GRAPH_NAME);
        }
        return this.defaultGraph;
    }
}

