/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agjena.query;

import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.PrologSelectQuery;
import com.franz.agbase.SPARQLQuery;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.ValueSetIterator;
import com.franz.agjena.AGTripleIterator;
import com.franz.agjena.AllegroGraphGraph;
import com.franz.agjena.AllegroGraphModel;
import com.franz.agjena.Utils;
import com.franz.agjena.exceptions.NiceException;
import com.franz.agjena.exceptions.UnimplementedMethodException;
import com.franz.agjena.query.AllegroGraphResultSet;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.util.FileUtils;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllegroGraphQuery
extends Query
implements Cloneable {
    private String queryString = null;
    private AllegroGraphModel model = null;
    private Syntax syntax = Syntax.syntaxSPARQL;
    public static final int QueryTypeUnknown = -123;
    public static final int QueryTypeSelect = 111;
    public static final int QueryTypeConstruct = 222;
    public static final int QueryTypeDescribe = 333;
    public static final int QueryTypeAsk = 444;
    int queryType = -123;

    public AllegroGraphQuery() {
    }

    public AllegroGraphQuery(Model model) {
    }

    public AllegroGraphQuery(Prologue prologue) {
        this();
        throw new UnimplementedMethodException("AllegroGraphQuery constructor with Prologue");
    }

    public String getQueryString() {
        return this.queryString;
    }

    protected void setQueryString(String string) {
        this.queryString = string.trim();
        if (string == null) {
            return;
        }
        String string2 = string.toLowerCase();
        this.queryType = string2.contains("select") ? 111 : (string2.contains("construct") ? 222 : (string2.contains("describe") ? 333 : (string2.contains("ask") ? 444 : -123)));
    }

    public Model getModel() {
        return this.model;
    }

    public int getQueryType() {
        return this.queryType;
    }

    public boolean isSelectType() {
        return this.queryType == 111;
    }

    public boolean isConstructType() {
        return this.queryType == 222;
    }

    public boolean isDescribeType() {
        return this.queryType == 333;
    }

    public boolean isAskType() {
        return this.queryType == 444;
    }

    public boolean isUnknownType() {
        return this.queryType == -123;
    }

    public ResultSet executeSelectQuery() {
        return this.executeSelectQuery(null);
    }

    private static List<String> extractGraphNames(String string, boolean bl) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string;
        String string3 = string.toLowerCase();
        while ((n = string3.indexOf("from named")) >= 0) {
            string3 = string3.substring(n);
            string2 = string2.substring(n);
            int n2 = string3.indexOf("<");
            int n3 = string3.indexOf(">");
            if (n2 < 0 || n3 < 0 || n3 <= n2) {
                string3 = string3.substring(3);
                string2 = string2.substring(3);
                continue;
            }
            if (bl) {
                arrayList.add(string2.substring(n2, n3 + 1));
            } else {
                arrayList.add(string2.substring(n2 + 1, n3));
            }
            string3 = string3.substring(n3);
            string2 = string2.substring(n3);
        }
        return arrayList;
    }

    private List<AllegroGraphGraph> graphsFromDataset(Dataset dataset) {
        DatasetGraph datasetGraph = dataset.asDatasetGraph();
        AllegroGraphGraph allegroGraphGraph = (AllegroGraphGraph)datasetGraph.getDefaultGraph();
        ArrayList<AllegroGraphGraph> arrayList = new ArrayList<AllegroGraphGraph>();
        arrayList.add(allegroGraphGraph);
        Iterator iterator = datasetGraph.listGraphNodes();
        while (iterator.hasNext()) {
            AllegroGraphGraph allegroGraphGraph2 = (AllegroGraphGraph)datasetGraph.getGraph((Node)iterator.next());
            arrayList.add(allegroGraphGraph2);
        }
        return arrayList;
    }

    public SPARQLQuery sparqlQueryFromDataset(Dataset dataset) {
        String[] stringArray;
        AllegroGraphGraph allegroGraphGraph2;
        if (dataset != null && !Utils.toList(dataset.listNames()).isEmpty()) {
            System.out.println("Query execution against the externally-specified graphs \n   '" + Utils.toList(dataset.listNames()) + "' is not yet implemented!.");
        }
        List<AllegroGraphGraph> list = this.graphsFromDataset(dataset);
        boolean bl = false;
        boolean bl2 = false;
        for (AllegroGraphGraph allegroGraphGraph2 : list) {
            if (allegroGraphGraph2.isRDFSPlusPlusGraph()) {
                bl = true;
            }
            if (!allegroGraphGraph2.isGraphOfAllGraphs()) continue;
            bl2 = true;
        }
        SPARQLQuery sPARQLQuery = new SPARQLQuery();
        sPARQLQuery.setQuery(this.queryString);
        sPARQLQuery.setTripleStore(list.get(0).getAllegroGraphStore());
        sPARQLQuery.setIncludeInferred(bl);
        if (bl2) {
            sPARQLQuery.setDefaultDatasetBehaviorAll();
        } else {
            sPARQLQuery.setDefaultDatasetBehaviorDefault();
        }
        allegroGraphGraph2 = null;
        ArrayList<AllegroGraphGraph> arrayList = new ArrayList<AllegroGraphGraph>();
        boolean bl3 = true;
        for (AllegroGraphGraph allegroGraphGraph3 : list) {
            String string = allegroGraphGraph3.getName();
            if (string == null) continue;
            if (bl3) {
                allegroGraphGraph2 = allegroGraphGraph3;
                continue;
            }
            arrayList.add(allegroGraphGraph3);
            bl3 = false;
        }
        if (allegroGraphGraph2 != null) {
            stringArray = new String[]{allegroGraphGraph2.getName()};
            sPARQLQuery.setFrom(stringArray);
        }
        if (!arrayList.isEmpty()) {
            stringArray = (String[])arrayList.toArray();
            sPARQLQuery.setFromNamed(stringArray);
        }
        return sPARQLQuery;
    }

    public PrologSelectQuery prologSelectQueryFromDataset(Dataset dataset) {
        String[] stringArray = AllegroGraphQuery.getVars(this.queryString);
        String string = AllegroGraphQuery.getQuery(this.queryString);
        if (dataset != null && !Utils.toList(dataset.listNames()).isEmpty()) {
            System.out.println("Query execution against the externally-specified graphs \n   '" + Utils.toList(dataset.listNames()) + "' is not yet implemented!.");
        }
        List<AllegroGraphGraph> list = this.graphsFromDataset(dataset);
        boolean bl = false;
        for (AllegroGraphGraph allegroGraphGraph : list) {
            if (!allegroGraphGraph.isRDFSPlusPlusGraph()) continue;
            bl = true;
        }
        PrologSelectQuery prologSelectQuery = new PrologSelectQuery();
        prologSelectQuery.setTripleStore(list.get(0).getAllegroGraphStore());
        prologSelectQuery.setVariables(stringArray);
        prologSelectQuery.setQuery(string);
        prologSelectQuery.setIncludeInferred(bl);
        return prologSelectQuery;
    }

    private static String[] getVars(String string) {
        String[] stringArray = string.split("\\)");
        stringArray = stringArray[0].split("\\?");
        String[] stringArray2 = new String[stringArray.length - 1];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i + 1].trim();
        }
        return stringArray2;
    }

    private static String getQuery(String string) {
        int n = string.indexOf(41);
        String string2 = string.substring(n + 1, string.trim().length() - 1);
        return string2;
    }

    public ResultSet executePrologSelectQuery(Dataset dataset) {
        PrologSelectQuery prologSelectQuery = this.prologSelectQueryFromDataset(dataset);
        AllegroGraphGraph allegroGraphGraph = this.graphsFromDataset(dataset).get(0);
        try {
            ValueSetIterator valueSetIterator = prologSelectQuery.run();
            return new AllegroGraphResultSet(valueSetIterator, allegroGraphGraph, this.queryString);
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new NiceException("Failed to execute query \n" + this.queryString, allegroGraphException);
        }
    }

    public boolean isPrologQuery(String string) {
        return string.contains("(select");
    }

    public ResultSet executeSelectQuery(Dataset dataset) {
        if (this.isPrologQuery(this.queryString)) {
            return this.executePrologSelectQuery(dataset);
        }
        SPARQLQuery sPARQLQuery = this.sparqlQueryFromDataset(dataset);
        AllegroGraphGraph allegroGraphGraph = this.graphsFromDataset(dataset).get(0);
        try {
            ValueSetIterator valueSetIterator = sPARQLQuery.select();
            return new AllegroGraphResultSet(valueSetIterator, allegroGraphGraph, this.queryString);
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new NiceException("Failed to execute query \n" + this.queryString, allegroGraphException);
        }
    }

    public Model executeConstructQuery(Dataset dataset) {
        SPARQLQuery sPARQLQuery = this.sparqlQueryFromDataset(dataset);
        AllegroGraphGraph allegroGraphGraph = this.graphsFromDataset(dataset).get(0);
        try {
            TriplesIterator triplesIterator = sPARQLQuery.construct();
            AGTripleIterator aGTripleIterator = new AGTripleIterator(allegroGraphGraph, triplesIterator);
            GraphMem graphMem = new GraphMem();
            while (aGTripleIterator.hasNext()) {
                graphMem.performAdd(aGTripleIterator.next());
            }
            return new ModelCom((Graph)graphMem);
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new NiceException("Failed to execute query \n" + this.queryString, allegroGraphException);
        }
    }

    public Model executeDescribeQuery(Dataset dataset) {
        SPARQLQuery sPARQLQuery = this.sparqlQueryFromDataset(dataset);
        AllegroGraphGraph allegroGraphGraph = this.graphsFromDataset(dataset).get(0);
        try {
            TriplesIterator triplesIterator = sPARQLQuery.describe();
            AGTripleIterator aGTripleIterator = new AGTripleIterator(allegroGraphGraph, triplesIterator);
            GraphMem graphMem = new GraphMem();
            while (aGTripleIterator.hasNext()) {
                graphMem.performAdd(aGTripleIterator.next());
            }
            return new ModelCom((Graph)graphMem);
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new NiceException("Failed to execute query \n" + this.queryString, allegroGraphException);
        }
    }

    public boolean executeAskQuery(Dataset dataset) {
        SPARQLQuery sPARQLQuery = this.sparqlQueryFromDataset(dataset);
        try {
            return sPARQLQuery.ask();
        }
        catch (AllegroGraphException allegroGraphException) {
            throw new NiceException("Failed to execute query \n" + this.queryString, allegroGraphException);
        }
    }

    public String serialize() {
        return this.queryString;
    }

    public String serialize(Syntax syntax) {
        if (syntax != Syntax.syntaxSPARQL) {
            throw new NiceException("Only SPARQL query syntax is supported.");
        }
        return this.queryString;
    }

    public void serialize(OutputStream outputStream) {
        System.out.println("SERIALIZE: " + this.queryString);
        FileUtils.asPrintWriterUTF8((OutputStream)outputStream).print(this.queryString);
    }

    public void serialize(IndentedWriter indentedWriter) {
        throw new NiceException("Indented printing of queries is not supported.");
    }

    private static void practice(String string) {
        System.out.println("Input '" + string + "'   Output " + AllegroGraphQuery.extractGraphNames(string, true));
    }

    public static void main(String[] stringArray) {
        AllegroGraphQuery.practice("select ?s where true");
        AllegroGraphQuery.practice("select ?s from named <http://foo>");
        AllegroGraphQuery.practice("select ?s from named <http://foo>from named<Http://bar>");
        AllegroGraphQuery.practice("select ?s from named http://foo> from named<Http://bar>");
    }
}

