/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agjena.query;

import com.franz.agjena.exceptions.NiceException;
import com.franz.agjena.exceptions.UnimplementedMethodException;
import com.franz.agjena.query.AllegroGraphQuery;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.FileManager;

public class AllegroGraphQueryExecution
implements QueryExecution {
    private FileManager fileManager = null;
    private AllegroGraphQuery query = null;
    private Dataset dataset = null;
    private Context context = null;
    private QuerySolution initialBinding = null;

    protected AllegroGraphQueryExecution(Query query, Dataset dataset, Context context) {
        if (!(query instanceof AllegroGraphQuery)) {
            throw new NiceException("Non-AllegroGraph query passed to 'AllegroGraphQueryExecution'");
        }
        this.query = (AllegroGraphQuery)query;
        this.dataset = dataset;
        this.context = context;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void setInitialBinding(QuerySolution querySolution) {
        this.initialBinding = querySolution;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public Context getContext() {
        return this.context;
    }

    public ResultSet execSelect() {
        return this.query.executeSelectQuery(this.dataset);
    }

    public Model execConstruct() {
        return this.query.executeConstructQuery(this.dataset);
    }

    public Model execConstruct(Model model) {
        throw new UnimplementedMethodException("execConstruct");
    }

    public Model execDescribe() {
        return this.query.executeDescribeQuery(this.dataset);
    }

    public Model execDescribe(Model model) {
        throw new UnimplementedMethodException("execDescribe");
    }

    public boolean execAsk() {
        return this.query.executeAskQuery(this.dataset);
    }

    public void abort() {
        throw new UnimplementedMethodException("Query abort not implemented.");
    }

    public void close() {
    }
}

