/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agjena.query;

import com.franz.agjena.exceptions.NiceException;
import com.franz.agjena.exceptions.UnimplementedMethodException;
import com.franz.agjena.query.AllegroGraphQuery;
import com.franz.agjena.query.AllegroGraphQueryExecution;
import com.franz.agjena.query.AllegroGraphQueryFactory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DataSourceImpl;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.FileManager;
import java.util.List;

public class AllegroGraphQueryExecutionFactory {
    private AllegroGraphQueryExecutionFactory() {
    }

    public static QueryExecution create(Query query) {
        AllegroGraphQueryExecutionFactory.checkArg(query);
        return AllegroGraphQueryExecutionFactory.make(query);
    }

    public static QueryExecution create(String string) {
        AllegroGraphQueryExecutionFactory.checkArg(string);
        return AllegroGraphQueryExecutionFactory.create(AllegroGraphQueryExecutionFactory.makeQuery(string));
    }

    public static QueryExecution create(String string, Syntax syntax) {
        AllegroGraphQueryExecutionFactory.checkArg(string);
        return AllegroGraphQueryExecutionFactory.create(AllegroGraphQueryExecutionFactory.makeQuery(string, syntax));
    }

    public static QueryExecution create(Query query, Dataset dataset) {
        return AllegroGraphQueryExecutionFactory.make(query, dataset);
    }

    public static QueryExecution create(String string, Dataset dataset) {
        AllegroGraphQueryExecutionFactory.checkArg(string);
        return AllegroGraphQueryExecutionFactory.make(AllegroGraphQueryExecutionFactory.makeQuery(string), dataset);
    }

    public static QueryExecution create(String string, Syntax syntax, Dataset dataset) {
        AllegroGraphQueryExecutionFactory.checkArg(string);
        return AllegroGraphQueryExecutionFactory.make(AllegroGraphQueryExecutionFactory.makeQuery(string, syntax), dataset);
    }

    public static QueryExecution create(Query query, FileManager fileManager) {
        AllegroGraphQueryExecutionFactory.checkArg(query);
        QueryExecution queryExecution = AllegroGraphQueryExecutionFactory.make(query);
        if (fileManager != null) {
            queryExecution.setFileManager(fileManager);
        }
        return queryExecution;
    }

    public static QueryExecution create(String string, FileManager fileManager) {
        AllegroGraphQueryExecutionFactory.checkArg(string);
        return AllegroGraphQueryExecutionFactory.create(AllegroGraphQueryExecutionFactory.makeQuery(string), fileManager);
    }

    public static QueryExecution create(String string, Syntax syntax, FileManager fileManager) {
        AllegroGraphQueryExecutionFactory.checkArg(string);
        return AllegroGraphQueryExecutionFactory.create(AllegroGraphQueryExecutionFactory.makeQuery(string, syntax), fileManager);
    }

    public static QueryExecution create(Query query, Model model) {
        AllegroGraphQueryExecutionFactory.checkArg(query);
        AllegroGraphQueryExecutionFactory.checkArg(model);
        AllegroGraphQueryExecution allegroGraphQueryExecution = (AllegroGraphQueryExecution)AllegroGraphQueryExecutionFactory.create(query, (Dataset)new DatasetImpl(model));
        return allegroGraphQueryExecution;
    }

    public static QueryExecution create(String string, Model model) {
        AllegroGraphQueryExecutionFactory.checkArg(string);
        AllegroGraphQueryExecutionFactory.checkArg(model);
        AllegroGraphQueryExecution allegroGraphQueryExecution = (AllegroGraphQueryExecution)AllegroGraphQueryExecutionFactory.create(AllegroGraphQueryExecutionFactory.makeQuery(string), model);
        return allegroGraphQueryExecution;
    }

    public static QueryExecution create(String string, Syntax syntax, Model model) {
        AllegroGraphQueryExecutionFactory.checkArg(string);
        AllegroGraphQueryExecutionFactory.checkArg(model);
        return AllegroGraphQueryExecutionFactory.create(AllegroGraphQueryExecutionFactory.makeQuery(string, syntax), model);
    }

    public static QueryExecution create(Query query, QuerySolution querySolution) {
        AllegroGraphQueryExecutionFactory.checkArg(query);
        QueryExecution queryExecution = AllegroGraphQueryExecutionFactory.make(query);
        if (querySolution != null) {
            queryExecution.setInitialBinding(querySolution);
        }
        return queryExecution;
    }

    public static QueryExecution create(String string, QuerySolution querySolution) {
        AllegroGraphQueryExecutionFactory.checkArg(string);
        return AllegroGraphQueryExecutionFactory.create(AllegroGraphQueryExecutionFactory.makeQuery(string), querySolution);
    }

    public static QueryExecution create(String string, Syntax syntax, QuerySolution querySolution) {
        AllegroGraphQueryExecutionFactory.checkArg(string);
        return AllegroGraphQueryExecutionFactory.create(AllegroGraphQueryExecutionFactory.makeQuery(string, syntax), querySolution);
    }

    public static QueryExecution create(Query query, Model model, QuerySolution querySolution) {
        AllegroGraphQueryExecutionFactory.checkArg(model);
        return AllegroGraphQueryExecutionFactory.create(query, (Dataset)new DataSourceImpl(model), querySolution);
    }

    public static QueryExecution create(String string, Model model, QuerySolution querySolution) {
        AllegroGraphQueryExecutionFactory.checkArg(string);
        AllegroGraphQueryExecutionFactory.checkArg(model);
        return AllegroGraphQueryExecutionFactory.create(AllegroGraphQueryExecutionFactory.makeQuery(string), model, querySolution);
    }

    public static QueryExecution create(String string, Syntax syntax, Model model, QuerySolution querySolution) {
        AllegroGraphQueryExecutionFactory.checkArg(string);
        return AllegroGraphQueryExecutionFactory.create(AllegroGraphQueryExecutionFactory.makeQuery(string, syntax), model, querySolution);
    }

    public static QueryExecution create(Query query, Dataset dataset, QuerySolution querySolution) {
        AllegroGraphQueryExecutionFactory.checkArg(query);
        QueryExecution queryExecution = AllegroGraphQueryExecutionFactory.make(query, dataset);
        queryExecution.setInitialBinding(querySolution);
        return queryExecution;
    }

    public static QueryExecution create(String string, Dataset dataset, QuerySolution querySolution) {
        AllegroGraphQueryExecutionFactory.checkArg(string);
        return AllegroGraphQueryExecutionFactory.create(AllegroGraphQueryExecutionFactory.makeQuery(string), dataset, querySolution);
    }

    public static QueryExecution create(String string, Syntax syntax, Dataset dataset, QuerySolution querySolution) {
        AllegroGraphQueryExecutionFactory.checkArg(string);
        return AllegroGraphQueryExecutionFactory.create(AllegroGraphQueryExecutionFactory.makeQuery(string, syntax), dataset, querySolution);
    }

    public static QueryExecution sparqlService(String string, String string2) {
        AllegroGraphQueryExecutionFactory.checkNotNull(string, "URL for service is null");
        AllegroGraphQueryExecutionFactory.checkArg(string2);
        return AllegroGraphQueryExecutionFactory.sparqlService(string, AllegroGraphQueryFactory.create(string2));
    }

    public static QueryExecution sparqlService(String string, String string2, String string3) {
        AllegroGraphQueryExecutionFactory.checkNotNull(string, "URL for service is null");
        AllegroGraphQueryExecutionFactory.checkArg(string2);
        return AllegroGraphQueryExecutionFactory.sparqlService(string, AllegroGraphQueryFactory.create(string2), string3);
    }

    public static QueryExecution sparqlService(String string, String string2, List list, List list2) {
        AllegroGraphQueryExecutionFactory.checkNotNull(string, "URL for service is null");
        AllegroGraphQueryExecutionFactory.checkArg(string2);
        return AllegroGraphQueryExecutionFactory.sparqlService(string, AllegroGraphQueryFactory.create(string2), list, list2);
    }

    public static QueryExecution sparqlService(String string, Query query) {
        AllegroGraphQueryExecutionFactory.checkNotNull(string, "URL for service is null");
        AllegroGraphQueryExecutionFactory.checkArg(query);
        return AllegroGraphQueryExecutionFactory.createServiceRequest(string, query);
    }

    public static QueryExecution sparqlService(String string, Query query, List list, List list2) {
        AllegroGraphQueryExecutionFactory.checkNotNull(string, "URL for service is null");
        AllegroGraphQueryExecutionFactory.checkArg(query);
        QueryEngineHTTP queryEngineHTTP = AllegroGraphQueryExecutionFactory.createServiceRequest(string, query);
        if (list != null) {
            queryEngineHTTP.setDefaultGraphURIs(list);
        }
        if (list2 != null) {
            queryEngineHTTP.setNamedGraphURIs(list2);
        }
        return queryEngineHTTP;
    }

    public static QueryExecution sparqlService(String string, Query query, String string2) {
        AllegroGraphQueryExecutionFactory.checkNotNull(string, "URL for service is null");
        AllegroGraphQueryExecutionFactory.checkArg(query);
        QueryEngineHTTP queryEngineHTTP = AllegroGraphQueryExecutionFactory.createServiceRequest(string, query);
        queryEngineHTTP.addDefaultGraph(string2);
        return queryEngineHTTP;
    }

    public static QueryEngineHTTP createServiceRequest(String string, Query query) {
        QueryEngineHTTP queryEngineHTTP = new QueryEngineHTTP(string, query);
        return queryEngineHTTP;
    }

    public static Plan createPlan(AllegroGraphQuery allegroGraphQuery, DatasetGraph datasetGraph, Binding binding, Context context) {
        throw new UnimplementedMethodException("createPlan");
    }

    public static Plan createPlan(String string, Graph graph) {
        return AllegroGraphQueryExecutionFactory.createPlan((Query)AllegroGraphQueryFactory.create(string), graph);
    }

    public static Plan createPlan(String string, DatasetGraph datasetGraph) {
        return AllegroGraphQueryExecutionFactory.createPlan((Query)AllegroGraphQueryFactory.create(string), datasetGraph);
    }

    public static Plan createPlan(Query query, Graph graph) {
        throw new UnimplementedMethodException("createPlan");
    }

    public static Plan createPlan(Query query, DatasetGraph datasetGraph) {
        throw new UnimplementedMethodException("createPlan");
    }

    public static Plan createPlan(Element element, Graph graph) {
        throw new UnimplementedMethodException("createPlan");
    }

    public static Plan createPlan(Element element, DatasetGraph datasetGraph) {
        throw new UnimplementedMethodException("createPlan");
    }

    private static Query makeQuery(String string) {
        return AllegroGraphQueryFactory.create(string);
    }

    private static Query makeQuery(String string, Syntax syntax) {
        if (syntax != Syntax.syntaxSPARQL) {
            throw new NiceException("Only SPARQL queries are supported");
        }
        return AllegroGraphQueryFactory.create(string);
    }

    private static QueryExecution make(Query query) {
        QueryExecution queryExecution = AllegroGraphQueryExecutionFactory.make(query, null);
        return queryExecution;
    }

    private static QueryExecution make(Query query, Dataset dataset) {
        return AllegroGraphQueryExecutionFactory.make(query, dataset, null);
    }

    private static QueryExecution make(Query query, Dataset dataset, Context context) {
        if (context == null) {
            context = new Context(ARQ.getContext());
        }
        DatasetGraph datasetGraph = null;
        if (dataset != null) {
            datasetGraph = dataset.asDatasetGraph();
        }
        return new AllegroGraphQueryExecution(query, dataset, context);
    }

    private static QueryEngineFactory findFactory(Query query, DatasetGraph datasetGraph, Context context) {
        return QueryEngineRegistry.get().find(query, datasetGraph, context);
    }

    private static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    private static void checkArg(Model model) {
        AllegroGraphQueryExecutionFactory.checkNotNull(model, "Model is a null pointer");
    }

    private static void checkArg(String string) {
        AllegroGraphQueryExecutionFactory.checkNotNull(string, "Query string is null");
    }

    private static void checkArg(Query query) {
        AllegroGraphQueryExecutionFactory.checkNotNull(query, "Query is null");
    }
}

