/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agsail.util;

import com.franz.agbase.AllegroGraph;
import com.franz.agbase.BlankNode;
import com.franz.agbase.DefaultGraph;
import com.franz.agbase.LiteralNode;
import com.franz.agbase.Triple;
import com.franz.agbase.TriplesIterator;
import com.franz.agbase.UPI;
import com.franz.agbase.URINode;
import com.franz.agbase.ValueNode;
import com.franz.agsail.AGForSail;
import com.franz.agsail.AGSailCursor;
import com.franz.agsail.AGSailTriple;
import com.franz.agsail.impl.AGSailBlankNodeImpl;
import com.franz.agsail.impl.AGSailFactory;
import com.franz.agsail.impl.AGSailValueObjectImpl;
import java.util.Hashtable;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class AGSInternal {
    private AllegroGraph directInstance = null;
    private Hashtable<UPI, BNode> agToSail = new Hashtable();
    private Hashtable<BNode, BlankNode> sailToAG = new Hashtable();

    public AGSInternal(AllegroGraph allegroGraph) {
        this.directInstance = allegroGraph;
    }

    public AllegroGraph getDirectInstance() {
        return this.directInstance;
    }

    public Object coerceToAGPart(Object object) {
        AGSailValueObjectImpl aGSailValueObjectImpl;
        Object object2;
        if (object == null) {
            return null;
        }
        if (object instanceof AGSailValueObjectImpl && (object2 = (aGSailValueObjectImpl = (AGSailValueObjectImpl)object).getDirectInstance()) != null) {
            return object2;
        }
        if (object instanceof URI) {
            return this.directInstance.createURI(object.toString());
        }
        if (object instanceof Literal) {
            aGSailValueObjectImpl = (Literal)object;
            object2 = aGSailValueObjectImpl.getLanguage();
            if (object2 != null) {
                return this.directInstance.createLiteral(aGSailValueObjectImpl.getLabel(), (String)object2);
            }
            URI uRI = aGSailValueObjectImpl.getDatatype();
            if (uRI != null) {
                return this.directInstance.createTypedLiteral(aGSailValueObjectImpl.getLabel(), uRI.toString());
            }
            return this.directInstance.createLiteral(aGSailValueObjectImpl.getLabel());
        }
        if (object instanceof BNode) {
            return this.lookupBNode((BNode)object);
        }
        if (object instanceof String) {
            return object;
        }
        throw new IllegalArgumentException("Cannot coerce to AGPart " + object);
    }

    public AGSailCursor coerceToSailCursor(TriplesIterator triplesIterator) {
        return AGSailFactory.makeCursor((AGForSail)this, triplesIterator);
    }

    public AGSailTriple coerceToSailTriple(Triple triple) {
        return AGSailFactory.makeTriple((AGForSail)this, triple);
    }

    public Value coerceToSailValue(ValueNode valueNode) {
        if (valueNode == null) {
            return null;
        }
        if (valueNode instanceof URINode) {
            return AGSailFactory.makeNode((AGForSail)this, (URINode)valueNode);
        }
        if (valueNode instanceof BlankNode) {
            return this.registerBlankNode((BlankNode)valueNode, null);
        }
        if (valueNode instanceof LiteralNode) {
            return AGSailFactory.makeLiteral((AGForSail)this, (LiteralNode)valueNode);
        }
        if (valueNode instanceof DefaultGraph) {
            return null;
        }
        throw new IllegalArgumentException("Cannot coerce to Sesame Part " + valueNode);
    }

    public BlankNode lookupBNode(BNode bNode) {
        if (bNode instanceof AGSailBlankNodeImpl) {
            AGSailBlankNodeImpl aGSailBlankNodeImpl = (AGSailBlankNodeImpl)bNode;
            return (BlankNode)aGSailBlankNodeImpl.getDirectInstance();
        }
        BlankNode blankNode = null;
        if (bNode != null) {
            blankNode = this.sailToAG.get(bNode);
        }
        if (blankNode != null) {
            return blankNode;
        }
        blankNode = this.directInstance.createBNode();
        if (bNode == null) {
            bNode = AGSailFactory.makeBlankNode((AGForSail)this, blankNode);
        }
        this.agToSail.put(blankNode.queryAGId(), bNode);
        this.sailToAG.put(bNode, blankNode);
        return blankNode;
    }

    public BNode registerBlankNode(BlankNode blankNode, BNode bNode) {
        BNode bNode2 = this.agToSail.get(blankNode.queryAGId());
        if (bNode2 != null) {
            return bNode2;
        }
        bNode2 = bNode == null ? AGSailFactory.makeBlankNode((AGForSail)this, blankNode) : bNode;
        this.agToSail.put(blankNode.queryAGId(), bNode2);
        this.sailToAG.put(bNode2, blankNode);
        return bNode2;
    }
}

