/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgereefsystems.agsail;

import com.knowledgereefsystems.agsail.AllegroSailException;
import info.aduna.iteration.CloseableIteration;
import org.openrdf.model.Namespace;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.sail.SailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceIteration
implements CloseableIteration<Namespace, SailException> {
    private String[] nsArray;
    private int cur;
    private int size;
    private boolean closed = false;

    public NamespaceIteration(String[] stringArray) throws SailException {
        this.nsArray = stringArray;
        this.cur = 0;
        if (null == stringArray) {
            this.close();
        } else {
            this.size = stringArray.length / 2;
        }
    }

    public void close() throws SailException {
        this.nsArray = null;
        this.closed = true;
        this.size = 0;
    }

    public boolean hasNext() throws SailException {
        return this.cur < this.size;
    }

    public Namespace next() throws SailException {
        if (this.closed) {
            throw new AllegroSailException("iterator has been closed");
        }
        String string = this.nsArray[this.cur * 2];
        String string2 = this.nsArray[this.cur * 2 + 1];
        NamespaceImpl namespaceImpl = new NamespaceImpl(string, string2);
        ++this.cur;
        return namespaceImpl;
    }

    public void remove() throws SailException {
        if (this.closed) {
            throw new AllegroSailException("iterator has been closed");
        }
    }
}

