/*
 * Decompiled with CFR 0.152.
 */
package com.knowledgereefsystems.agsail;

import com.knowledgereefsystems.agsail.AllegroSailConnection;
import com.knowledgereefsystems.agsail.AllegroSailTestCase;
import info.aduna.iteration.CloseableIteration;
import java.io.File;
import java.util.HashSet;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.sparql.SPARQLParser;

public class TestTupleQueries
extends AllegroSailTestCase {
    public TestTupleQueries(String string) throws Exception {
        super(string);
    }

    public void testEvaluate() throws Exception {
        URI uRI;
        URI uRI2;
        URI uRI3;
        Value value;
        URI uRI4;
        Object object;
        this.loadTrig(new File("resources/com/knowledgereefsystems/agsail/queryTest.trig"));
        AllegroSailConnection allegroSailConnection = this.sail.getConnection();
        URI uRI5 = this.sail.getValueFactory().createURI("http://example.org/ctxA");
        allegroSailConnection.addStatement((Resource)uRI5, uRI5, (Value)uRI5, new Resource[0]);
        allegroSailConnection.commit();
        SPARQLParser sPARQLParser = new SPARQLParser();
        EmptyBindingSet emptyBindingSet = new EmptyBindingSet();
        String string = "http://example.org/bogus/";
        String string2 = "SELECT ?y ?z WHERE { <http://example.org/ctxA> ?y ?z }";
        ParsedQuery parsedQuery = sPARQLParser.parseQuery(string2, string);
        CloseableIteration closeableIteration = allegroSailConnection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)emptyBindingSet, false);
        int n = 0;
        while (closeableIteration.hasNext()) {
            ++n;
            object = (BindingSet)closeableIteration.next();
            uRI4 = (URI)object.getValue("y");
            value = object.getValue("z");
            TestTupleQueries.assertNotNull((Object)uRI4);
            TestTupleQueries.assertNotNull((Object)value);
        }
        closeableIteration.close();
        TestTupleQueries.assertTrue((n > 0 ? 1 : 0) != 0);
        string2 = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?z WHERE { <http://knowledgereefsystems.com/agsail/test/thor> foaf:name ?z }";
        parsedQuery = sPARQLParser.parseQuery(string2, string);
        closeableIteration = allegroSailConnection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)emptyBindingSet, false);
        n = 0;
        object = new HashSet();
        while (closeableIteration.hasNext()) {
            ++n;
            uRI4 = (BindingSet)closeableIteration.next();
            value = (Literal)uRI4.getValue("z");
            TestTupleQueries.assertNotNull((Object)value);
            object.add(value.getLanguage());
        }
        closeableIteration.close();
        TestTupleQueries.assertTrue((n > 0 ? 1 : 0) != 0);
        TestTupleQueries.assertEquals((int)2, (int)object.size());
        TestTupleQueries.assertTrue((boolean)object.contains("en"));
        TestTupleQueries.assertTrue((boolean)object.contains("se"));
        string2 = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nSELECT ?s WHERE { ?s rdfs:comment \"he really knows where his towel is\" }";
        uRI4 = this.sail.getValueFactory().createURI("http://knowledgereefsystems.com/agsail/test/ford");
        parsedQuery = sPARQLParser.parseQuery(string2, string);
        closeableIteration = allegroSailConnection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)emptyBindingSet, false);
        n = 0;
        while (closeableIteration.hasNext()) {
            ++n;
            value = (BindingSet)closeableIteration.next();
            uRI3 = (URI)value.getValue("s");
            TestTupleQueries.assertNotNull((Object)uRI3);
            TestTupleQueries.assertEquals((Object)uRI3, (Object)uRI4);
        }
        closeableIteration.close();
        TestTupleQueries.assertTrue((n > 0 ? 1 : 0) != 0);
        string2 = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?s WHERE { ?s foaf:name \"Thor\"@en }";
        value = this.sail.getValueFactory().createURI("http://knowledgereefsystems.com/agsail/test/thor");
        parsedQuery = sPARQLParser.parseQuery(string2, string);
        closeableIteration = allegroSailConnection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)emptyBindingSet, false);
        n = 0;
        while (closeableIteration.hasNext()) {
            ++n;
            uRI3 = (BindingSet)closeableIteration.next();
            uRI2 = (URI)uRI3.getValue("s");
            TestTupleQueries.assertNotNull((Object)uRI2);
            TestTupleQueries.assertEquals((Object)uRI2, (Object)value);
        }
        closeableIteration.close();
        TestTupleQueries.assertTrue((n > 0 ? 1 : 0) != 0);
        string2 = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?s WHERE { ?s foaf:name \"Thor\" }";
        parsedQuery = sPARQLParser.parseQuery(string2, string);
        closeableIteration = allegroSailConnection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)emptyBindingSet, false);
        n = 0;
        while (closeableIteration.hasNext()) {
            ++n;
            closeableIteration.next();
        }
        closeableIteration.close();
        TestTupleQueries.assertEquals((int)0, (int)n);
        string2 = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nSELECT ?s WHERE { ?s foaf:msnChatID \"Thorster123\"^^xsd:string }";
        parsedQuery = sPARQLParser.parseQuery(string2, string);
        closeableIteration = allegroSailConnection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)emptyBindingSet, false);
        n = 0;
        while (closeableIteration.hasNext()) {
            ++n;
            uRI3 = (BindingSet)closeableIteration.next();
            uRI2 = (URI)uRI3.getValue("s");
            TestTupleQueries.assertNotNull((Object)uRI2);
            TestTupleQueries.assertEquals((Object)uRI2, (Object)value);
        }
        closeableIteration.close();
        TestTupleQueries.assertTrue((n > 0 ? 1 : 0) != 0);
        string2 = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nSELECT ?s WHERE { ?s foaf:msnChatID \"Thorster123\" }";
        parsedQuery = sPARQLParser.parseQuery(string2, string);
        closeableIteration = allegroSailConnection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)emptyBindingSet, false);
        n = 0;
        while (closeableIteration.hasNext()) {
            ++n;
            closeableIteration.next();
        }
        closeableIteration.close();
        TestTupleQueries.assertEquals((int)0, (int)n);
        string2 = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nSELECT ?p WHERE { <http://knowledgereefsystems.com/agsail/test/thor> ?p \"Thor\"@en }";
        parsedQuery = sPARQLParser.parseQuery(string2, string);
        uRI3 = this.sail.getValueFactory().createURI("http://xmlns.com/foaf/0.1/name");
        closeableIteration = allegroSailConnection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)emptyBindingSet, false);
        n = 0;
        while (closeableIteration.hasNext()) {
            ++n;
            uRI2 = (BindingSet)closeableIteration.next();
            uRI = (URI)uRI2.getValue("p");
            TestTupleQueries.assertNotNull((Object)uRI);
            TestTupleQueries.assertEquals((Object)uRI, (Object)uRI3);
        }
        closeableIteration.close();
        TestTupleQueries.assertTrue((n > 0 ? 1 : 0) != 0);
        string2 = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?z\nFROM <http://knowledgereefsystems.com/agsail/test/ctx1>\nWHERE { <http://knowledgereefsystems.com/agsail/test/thor> foaf:name ?z }";
        parsedQuery = sPARQLParser.parseQuery(string2, string);
        closeableIteration = allegroSailConnection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)emptyBindingSet, false);
        n = 0;
        object = new HashSet();
        while (closeableIteration.hasNext()) {
            ++n;
            uRI2 = (BindingSet)closeableIteration.next();
            uRI = (Literal)uRI2.getValue("z");
            TestTupleQueries.assertNotNull((Object)uRI);
            object.add(uRI.getLanguage());
        }
        closeableIteration.close();
        TestTupleQueries.assertTrue((n > 0 ? 1 : 0) != 0);
        TestTupleQueries.assertEquals((int)2, (int)object.size());
        TestTupleQueries.assertTrue((boolean)object.contains("en"));
        TestTupleQueries.assertTrue((boolean)object.contains("se"));
        string2 = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?z\nFROM <http://example.org/emptycontext>\nWHERE { <http://knowledgereefsystems.com/agsail/test/thor> foaf:name ?z }";
        parsedQuery = sPARQLParser.parseQuery(string2, string);
        closeableIteration = allegroSailConnection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)emptyBindingSet, false);
        n = 0;
        while (closeableIteration.hasNext()) {
            ++n;
            closeableIteration.next();
        }
        closeableIteration.close();
        TestTupleQueries.assertEquals((int)0, (int)n);
        string2 = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nSELECT ?o\nWHERE { <http://knowledgereefsystems.com/agsail/test/instance1> rdf:type ?o }";
        parsedQuery = sPARQLParser.parseQuery(string2, string);
        closeableIteration = allegroSailConnection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)emptyBindingSet, false);
        n = 0;
        while (closeableIteration.hasNext()) {
            ++n;
            uRI2 = (BindingSet)closeableIteration.next();
            uRI = (URI)uRI2.getValue("o");
            TestTupleQueries.assertEquals((String)"http://knowledgereefsystems.com/agsail/test/classB", (String)uRI.toString());
        }
        closeableIteration.close();
        TestTupleQueries.assertEquals((int)1, (int)n);
        closeableIteration = allegroSailConnection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)emptyBindingSet, true);
        n = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (closeableIteration.hasNext()) {
            ++n;
            BindingSet bindingSet = (BindingSet)closeableIteration.next();
            URI uRI6 = (URI)bindingSet.getValue("o");
            String string3 = uRI6.toString();
            if (string3.equals("http://knowledgereefsystems.com/agsail/test/classA")) {
                bl = true;
                continue;
            }
            if (!string3.equals("http://knowledgereefsystems.com/agsail/test/classB")) continue;
            bl2 = true;
        }
        closeableIteration.close();
        TestTupleQueries.assertEquals((int)2, (int)n);
        TestTupleQueries.assertTrue((boolean)bl);
        TestTupleQueries.assertTrue((boolean)bl2);
        allegroSailConnection.close();
    }
}

