/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SparqlOrderByTest
extends TestCase {
    private String query1 = "PREFIX foaf:    <http://xmlns.com/foaf/0.1/>\nSELECT ?name\nWHERE { ?x foaf:name ?name }\nORDER BY ?name\n";
    private String query2 = "PREFIX     :    <http://example.org/ns#>\nPREFIX foaf:    <http://xmlns.com/foaf/0.1/>\nPREFIX xsd:     <http://www.w3.org/2001/XMLSchema#>\nSELECT ?name\nWHERE { ?x foaf:name ?name ; :empId ?emp }\nORDER BY DESC(?emp)\n";
    private String query3 = "PREFIX     :    <http://example.org/ns#>\nPREFIX foaf:    <http://xmlns.com/foaf/0.1/>\nSELECT ?name\nWHERE { ?x foaf:name ?name ; :empId ?emp }\nORDER BY ?name DESC(?emp)\n";
    private Repository repository;
    private RepositoryConnection conn;

    public void testQuery1() throws Exception {
        SparqlOrderByTest.assertTrue(("James Leigh".compareTo("James Leigh Hunt") < 0 ? 1 : 0) != 0);
        this.assertResult(this.query1, Arrays.asList("James Leigh", "James Leigh", "James Leigh Hunt", "Megan Leigh"));
    }

    public void testQuery2() throws Exception {
        this.assertResult(this.query2, Arrays.asList("Megan Leigh", "James Leigh", "James Leigh Hunt", "James Leigh"));
    }

    public void testQuery3() throws Exception {
        this.assertResult(this.query3, Arrays.asList("James Leigh", "James Leigh", "James Leigh Hunt", "Megan Leigh"));
    }

    protected void setUp() throws Exception {
        this.repository = this.createRepository();
        this.createEmployee("james", "James Leigh", 123);
        this.createEmployee("jim", "James Leigh", 244);
        this.createEmployee("megan", "Megan Leigh", 1234);
        this.createEmployee("hunt", "James Leigh Hunt", 243);
        this.conn = this.repository.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        repository.initialize();
        RepositoryConnection repositoryConnection = repository.getConnection();
        try {
            repositoryConnection.clear(new Resource[0]);
            repositoryConnection.clearNamespaces();
        }
        finally {
            repositoryConnection.close();
        }
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;

    protected void tearDown() throws Exception {
        this.conn.close();
        this.repository.shutDown();
    }

    private void createEmployee(String string, String string2, int n) throws RepositoryException {
        ValueFactory valueFactory = this.repository.getValueFactory();
        String string3 = "http://xmlns.com/foaf/0.1/name";
        String string4 = "http://example.org/ns#empId";
        RepositoryConnection repositoryConnection = this.repository.getConnection();
        repositoryConnection.add((Resource)valueFactory.createURI("http://example.org/ns#" + string), valueFactory.createURI(string3), (Value)valueFactory.createLiteral(string2), new Resource[0]);
        repositoryConnection.add((Resource)valueFactory.createURI("http://example.org/ns#" + string), valueFactory.createURI(string4), (Value)valueFactory.createLiteral(n), new Resource[0]);
        repositoryConnection.close();
    }

    private void assertResult(String string, List<String> list) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        TupleQuery tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, string);
        TupleQueryResult tupleQueryResult = tupleQuery.evaluate();
        for (String string2 : list) {
            Value value = ((BindingSet)tupleQueryResult.next()).getValue("name");
            SparqlOrderByTest.assertEquals((String)string2, (String)((Literal)value).getLabel());
        }
        SparqlOrderByTest.assertFalse((boolean)tupleQueryResult.hasNext());
        tupleQueryResult.close();
    }
}

