/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository;

import junit.framework.TestCase;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public abstract class SparqlRegexTest
extends TestCase {
    public String queryInline = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?name ?mbox\n WHERE { ?x foaf:name  ?name ;\n            foaf:mbox  ?mbox .\n         FILTER regex(str(?mbox), \"@Work.example\", \"i\") }";
    public String queryBinding = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?name ?mbox\n WHERE { ?x foaf:name  ?name ;\n            foaf:mbox  ?mbox .\n         FILTER regex(str(?mbox), ?pattern) }";
    public String queryBindingFlags = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?name ?mbox\n WHERE { ?x foaf:name  ?name ;\n            foaf:mbox  ?mbox .\n         FILTER regex(str(?mbox), ?pattern, ?flags) }";
    public String queryExpr = "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT ?name ?mbox\n WHERE { ?x foaf:name  ?name ;\n            foaf:mbox  ?mbox .\n         ?y <http://example.org/ns#pattern>  ?pattern .\n         ?y <http://example.org/ns#flags>  ?flags .\n         FILTER regex(str(?mbox), ?pattern, ?flags) }";
    private Repository repository;
    private RepositoryConnection conn;
    private ValueFactory vf;
    private Literal hunt;

    public void testInline() throws Exception {
        TupleQuery tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.queryInline);
        TupleQueryResult tupleQueryResult = tupleQuery.evaluate();
        SparqlRegexTest.assertEquals((Object)this.hunt, (Object)((BindingSet)tupleQueryResult.next()).getValue("name"));
        SparqlRegexTest.assertFalse((boolean)tupleQueryResult.hasNext());
        tupleQueryResult.close();
    }

    public void testBinding() throws Exception {
        TupleQuery tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.queryBinding);
        tupleQuery.setBinding("pattern", (Value)this.vf.createLiteral("@work.example"));
        TupleQueryResult tupleQueryResult = tupleQuery.evaluate();
        SparqlRegexTest.assertEquals((Object)this.hunt, (Object)((BindingSet)tupleQueryResult.next()).getValue("name"));
        SparqlRegexTest.assertFalse((boolean)tupleQueryResult.hasNext());
        tupleQueryResult.close();
    }

    public void testBindingFlags() throws Exception {
        TupleQuery tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.queryBindingFlags);
        tupleQuery.setBinding("pattern", (Value)this.vf.createLiteral("@Work.example"));
        tupleQuery.setBinding("flags", (Value)this.vf.createLiteral("i"));
        TupleQueryResult tupleQueryResult = tupleQuery.evaluate();
        SparqlRegexTest.assertEquals((Object)this.hunt, (Object)((BindingSet)tupleQueryResult.next()).getValue("name"));
        SparqlRegexTest.assertFalse((boolean)tupleQueryResult.hasNext());
        tupleQueryResult.close();
    }

    public void testExpr() throws Exception {
        URI uRI = this.vf.createURI("http://example.org/ns#", "pattern");
        URI uRI2 = this.vf.createURI("http://example.org/ns#", "flags");
        BNode bNode = this.vf.createBNode();
        this.conn.add((Resource)bNode, uRI, (Value)this.vf.createLiteral("@Work.example"), new Resource[0]);
        this.conn.add((Resource)bNode, uRI2, (Value)this.vf.createLiteral("i"), new Resource[0]);
        TupleQuery tupleQuery = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, this.queryExpr);
        TupleQueryResult tupleQueryResult = tupleQuery.evaluate();
        SparqlRegexTest.assertEquals((Object)this.hunt, (Object)((BindingSet)tupleQueryResult.next()).getValue("name"));
        SparqlRegexTest.assertFalse((boolean)tupleQueryResult.hasNext());
        tupleQueryResult.close();
    }

    protected void setUp() throws Exception {
        this.repository = this.createRepository();
        this.vf = this.repository.getValueFactory();
        this.hunt = this.vf.createLiteral("James Leigh Hunt");
        this.createUser("james", "James Leigh", "james@leigh");
        this.createUser("megan", "Megan Leigh", "megan@leigh");
        this.createUser("hunt", "James Leigh Hunt", "james@work.example");
        this.conn = this.repository.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        repository.initialize();
        RepositoryConnection repositoryConnection = repository.getConnection();
        try {
            repositoryConnection.clear(new Resource[0]);
            repositoryConnection.clearNamespaces();
        }
        finally {
            repositoryConnection.close();
        }
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;

    protected void tearDown() throws Exception {
        this.conn.close();
        this.repository.shutDown();
    }

    private void createUser(String string, String string2, String string3) throws RepositoryException {
        RepositoryConnection repositoryConnection = this.repository.getConnection();
        URI uRI = this.vf.createURI("http://example.org/ns#", string);
        URI uRI2 = this.vf.createURI("http://xmlns.com/foaf/0.1/", "name");
        URI uRI3 = this.vf.createURI("http://xmlns.com/foaf/0.1/", "mbox");
        repositoryConnection.add((Resource)uRI, uRI2, (Value)this.vf.createLiteral(string2), new Resource[0]);
        repositoryConnection.add((Resource)uRI, uRI3, (Value)this.vf.createURI("mailto:", string3), new Resource[0]);
        repositoryConnection.close();
    }
}

