package com.franz.ag;

import org.openrdf.model.GraphException;
import org.openrdf.model.Value;
import org.openrdf.sesame.sail.StatementIterator;

import com.franz.ag.impl.ValueNodeImpl;

/**
 * This is the superclass of all Value instances.
 */
public interface ValueNode extends Value, ValueObject {

	/**
	 * Return the unique identifier of the object.
	 * 
	 * @return A UPI instance. If the value is null, then the object has not
	 *         been stored in the triple store and is simply a place holder for a
	 *         label.
	 */
	public UPI queryAGId();

	public StatementIterator getObjectStatements() throws GraphException;

	public int compareTo(ValueNodeImpl to);

}