package com.franz.ag.repository.examples;

import static com.franz.ag.repository.examples.AGRepositoryValueFactory.*;
import info.aduna.iteration.CloseableIteration;

import com.franz.ag.repository.AGRepository;
import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.examples.AGPaths;

import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class AGRepositoryRemoveStatements {

	/**
	 * Demonstrates some basics of removing statements from a Repository. 
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws Exception {
		// Connect to the server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Get a connection to a fresh repository
		AllegroGraph ts = ags.renew("repositorytuplequery", AGPaths.TRIPLE_STORES);
		Repository repo = new AGRepository(ts);
		repo.initialize();
		RepositoryConnection repoConn = repo.getConnection();
		
		// Get the ValueFactory for the Repository and create some example values. 
		ValueFactory vf = repo.getValueFactory();
		createExampleValues(vf);

		repoConn.add(bob, name, nameBob);
		repoConn.add(alice, name, nameAlice);

		repoConn.remove(bob, name, nameBob);

		System.out.println("Repository has bob statement?: " + repoConn.hasStatement(bob, name, nameBob, false));
		System.out.println("Repository has alice statement?: " + repoConn.hasStatement(alice, name, nameAlice, false));

		repoConn.remove(alice, null, null);
		System.out.println("Repository still has alice statement?: " + repoConn.hasStatement(alice, name, nameAlice, false));
		System.out.println("Repository is empty?: " + repoConn.isEmpty());
		
		repoConn.add(alice, name, nameAlice);
		repoConn.add(bob, name, nameBob);

		System.out.println("Repository has bob statement again?: " + repoConn.hasStatement(bob, name, nameBob, false));
		System.out.println("Repository has alice statement again?: " + repoConn.hasStatement(alice, name, nameAlice, false));

		CloseableIteration<? extends Statement, RepositoryException> iter = repoConn
				.getStatements(null, null, null, false);

		try {
			repoConn.remove(iter);
		} finally {
			iter.close();
		}
		System.out.println("Repository is empty?: " + repoConn.isEmpty());

		// Close the RepositoryConnection and shutdown the Repository
		// Close the store and disconnect from the server
		repoConn.close();
		repo.shutDown();
		ts.closeTripleStore();
		ags.disable();
	}
}
