package com.franz.ag.repository.examples;

import com.franz.ag.repository.AGRepository;
import com.franz.agbase.AllegroGraph;
import com.franz.agbase.AllegroGraphConnection;
import com.franz.agbase.AllegroGraphException;
import com.franz.agbase.examples.AGPaths;

import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;

public class AGRepositoryValueFactory {

	public static final String FOAF_NS = "http://xmlns.com/foaf/0.1/";

	public static final String DC_NS = "http://purl.org/dc/elements/1.1/";

	public static final String TEST_DIR_PREFIX = "/testcases/";

	public static ValueFactory vf;

	public static BNode bob;

	public static BNode alice;

	public static BNode alexander;

	public static URI name;

	public static URI mbox;

	public static URI publisher;

	public static URI unknownContext;

	public static URI context1;

	public static URI context2;

	public static Literal nameAlice;

	public static Literal nameBob;

	public static Literal mboxAlice;

	public static Literal mboxBob;

	/**
	 * Demonstrates basic use of a Repository's ValueFactory to create
	 * BNode's, URI's, and Literals.
	 * 
	 * These values are also used by other examples.
	 * 
	 * @param args
	 *            unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws Exception {

		// Connect to the server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store and Repository
		AllegroGraph ts = ags.renew("valuefactory", AGPaths.TRIPLE_STORES);
		Repository repo = new AGRepository(ts);
		repo.initialize();
		RepositoryConnection repoConn = repo.getConnection();
		
		// Get the ValueFactory for the Repository and create some example values. 
		ValueFactory vf = repo.getValueFactory();
		createExampleValues(vf);
		System.out.println("Using Repository's ValueFactory to create example values.");
		
		// Now we can use the values in an application
		repoConn.add(alice, name, nameAlice, context1);
		System.out.println("Added a statement involving some values to the repository.");
		
		// Close the RepositoryConnection and shutdown the Repository
		// Close the store and disconnect from the server
		repoConn.close();
		repo.shutDown();
		ts.closeTripleStore();
		ags.disable();
	}

	public static void createExampleValues(ValueFactory vf) {

		bob = vf.createBNode();
		alice = vf.createBNode();
		alexander = vf.createBNode();

		name = vf.createURI(FOAF_NS + "name");
		mbox = vf.createURI(FOAF_NS + "mbox");

		publisher = vf.createURI(DC_NS + "publisher");

		nameAlice = vf.createLiteral("Alice");
		nameBob = vf.createLiteral("Bob");

		mboxAlice = vf.createLiteral("alice@example.org");
		mboxBob = vf.createLiteral("bob@example.org");

		context1 = vf.createURI("urn:x-local:graph1");
		context2 = vf.createURI("urn:x-local:graph2");
	}
}
