package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGCreateLiteral {

	/**
	 * Demonstrates some basics of creating Literals.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create a fresh triple-store for this example.
		AllegroGraph ts = ags.renew("createliteral", AGPaths.TRIPLE_STORES);
		
		// Create a few Literals from various types 
		LiteralNode lit1 = ts.createLiteral("Fido");
		LiteralNode lit2 = ts.createLiteral(true);
		LiteralNode lit3 = ts.createLiteral(123);
		LiteralNode lit4 = ts.createLiteral(123.0);
		LiteralNode lit5 = ts.createLiteral((long)123);
		LiteralNode lit6 = ts.createLiteral((double)123);
		
		AGUtils.showLiteral(lit1);
		AGUtils.showLiteral(lit2);
		AGUtils.showLiteral(lit3);
		AGUtils.showLiteral(lit4);
		AGUtils.showLiteral(lit5);
		AGUtils.showLiteral(lit6);

		// Create a few URIs from strings 
		URINode subject = ts.createURI("http://example.org/fido");  
		URINode predicate = ts.createURI("http://example.org/name");

		// Add a triple to the store (also adds URIs and a Literal)
		ts.addStatement(subject, predicate, lit1);
		
		// You can also create Literals and add them to the store directly
		LiteralNode cat = ts.addLiteral("chat","fr"); // language is french
		AGUtils.showLiteral(cat);
		URINode dt = ts.createURI("http://www.w3.org/2001/XMLSchema#int");
		LiteralNode lit7 = ts.addLiteral("123", dt); // datatype is int
		AGUtils.showLiteral(lit7);
		
		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}
}
