package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGDeleteTriples {

	/**
	 * Demonstrates some basics of deleting triples
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("deletetriples", AGPaths.TRIPLE_STORES);
		
		// Register namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		// Add some triples to the store
		ts.addStatement("!ex:a","!ex:p", "!ex:b");
		ts.addStatement("!ex:b","!ex:p", "!ex:c");
		ts.addStatement("!ex:p","!rdf:type", "!owl:TransitiveProperty");
		
		// Retrieve some triples 
		TriplesIterator it = ts.getStatements(false,null,null,null);
		AGUtils.showTriples("Showing all triples:",it);

		// Delete all transitive properties
		ts.removeStatements(null, "!rdf:type", "!owl:TransitiveProperty");

		// Retrieve all remaining triples 
		it = ts.getStatements(false,null,null,null);
		System.out.println("Remaining triples:");
		AGUtils.showTriples(it);

		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}