package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGGeonames {

	/**
	 * Demonstrates loading and indexing of the Geonames ontology 
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("geonames", AGPaths.TRIPLE_STORES);

		// Load the Geonames ontology
		AGLoadRDF.loadRDFWithTiming(ts, AGPaths.dataSources("Geonames_v2.0_Lite.rdf"));
		
		// Index the store for querying, wait until indexing is complete.
		ts.indexAllTriples(true);

		// Get some triples and show them.
		TriplesIterator it = ts.getStatements(null, null, null);
		AGUtils.showTriples(it,100);
		
		// Close the triple store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

}
