package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGIndexNewTriples {

	/**
	 * Demonstrates some basics of indexing triples newly added to a store.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// store the chunk size so that it can be reset later
		long chunkSize = ags.getChunkSize();
		System.out.println("Setting index chunk size to 1000.");
		ags.setChunkSize(1000);

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("wilburwine", AGPaths.TRIPLE_STORES);

		// Load the wilburwine dataset
		String ntripleFile = AGPaths.dataSources("wilburwine.ntriples");
		System.out.println("Loading N-Triples " + ntripleFile);
		AGLoadNtriples.loadNTriplesWithTiming(ts,ntripleFile);
		
		// Note that all of the newly added triples are unindexed
		// The unindexed triple count reports 6 times the number 
		// of new triples added here, one for each index flavor 
		System.out.println("Unindexed triples: " + ts.getUnindexedTripleCount());
		System.out.println("Unmerged chunks: " + ts.getUnmergedCount());
		
		// Index only the newly added triples
		ts.indexNewTriples(true);
		
		// The new triples are now indexed -- in a separate chunk
		System.out.println("After calling indexNewTriples:");
		System.out.println("Unindexed triples: " + ts.getUnindexedTripleCount());
		System.out.println("Unmerged chunks: " + ts.getUnmergedCount());

		// Now index all triples -- this merges chunks
		ts.indexAllTriples(true);

		// There should now be one chunk for each index flavor 
		System.out.println("After calling indexAllTriples:");
		System.out.println("Unindexed triples: " + ts.getUnindexedTripleCount());
		System.out.println("Chunks: " + ts.getUnmergedCount());

		// Reset chunk size to its original value
		System.out.println("Setting index chunk size back to its original value.");
		ags.setChunkSize(chunkSize);
		
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
