package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGKennedy {

	/**
	 * Demonstrates loading and indexing of the Kennedy data set 
	 *
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store
		AllegroGraph ts = ags.renew("kennedy", AGPaths.TRIPLE_STORES);

		// Load the Kennedy data
		String ntripleFile = AGPaths.dataSources("kennedy.ntriples");
		System.out.println("Loading N-Triples " + ntripleFile);
		Long n = ts.loadNTriples(ntripleFile);
		System.out.println("Loaded " + n + " triples."); // a pun :)
		
		// Index the store for querying, wait until indexing is complete.
		ts.indexAllTriples(true);

		// Close the triple store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

}
