package com.franz.agbase.examples;

import com.franz.agbase.*;


public class AGLoadWithDatatypeMapping {

	/**
	 * Demonstrates loading a triple store with datatype mappings defined.
	 * 
	 * @param unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple store for this example. 
		AllegroGraph ts = ags.renew("datamapping", AGPaths.TRIPLE_STORES);

		// Add a datatype mapping so that XMLSchema#dateTime typed literals are 
		// loaded as date-time UPI's, enabling more efficient storage and range 
		// querying over dates.
		String[] map = new String[3];
		map[0] = "http://www.w3.org/2000/01/XMLSchema#dateTime";
		map[1] = "date-time";
		map[2] = "datatype";
		ts.addDataMapping(map);
		
		// Load some temporal data
		AGLoadNtriples.loadNTriplesWithTiming(ts, AGPaths.dataSources("temporal.nt"));

		// Index the store for faster querying
		AGIndexAllTriples.indexAllTriplesWithTiming(ts);
		
		// Register any namespaces
		ts.registerNamespace("ex", "http://example.org/");
		ts.registerNamespace("t", "http://franz.com/ns/allegrograph/3.0/temporal/");

		TriplesIterator cc = ts.getStatements(null, "!t:time", null);
		AGUtils.showTriples(cc);
		
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
