package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGPrologFunctorQminus {

	/**
	 * Demonstrates some basics of using functor q- in PrologSelect queries. 
	 * 
	 * @param unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create a fresh triple-store for this example.
		AllegroGraph ts = ags.renew("functorqminus", AGPaths.TRIPLE_STORES);
		
		// Register your namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		// Add some triples to the store
		ts.addStatement("!ex:a","!ex:owned-by","!ex:b");
		ts.addStatement("!ex:c","!ex:owns","!ex:d");
		ts.addStatement("!ex:jans","!ex:owns","!ex:birra");
		ts.addStatement("!ex:owned-by","!owl:inverseOf","!ex:owns");

		// index the store
		ts.indexAllTriples();
		
		// Set up a Prolog query object that does RDFS++ reasoning
		// over the store
		PrologSelectQuery q = new PrologSelectQuery();
		q.setTripleStore(ts);
		q.setIncludeInferred(true);

		// First a query with the q functor.  This will include inferred
		// results because the includeInferred setting is true.
		String[] vars = new String[]{"x","y"};
		String pquery = "(q ?x !ex:owns ?y)";
		q.setVariables(vars);
		q.setQuery(pquery);
		ValueSetIterator it = q.run();
		System.out.println("Results for " + pquery);
		AGUtils.showResults(it);

		// Now a query with the q- functor.  This returns results that don't
		// involve reasoner, overriding any "includeInferred" setting on the
		// the query (but just for this clause).  It allows disabling of
		// reasoning on a clause-by-clause basis for queries involving
		// multiple clauses.
		pquery = "(q- ?x !ex:owns ?y)";
		q.setVariables(vars);
		q.setQuery(pquery);
		it = q.run();
		System.out.println("Results for " + pquery);
		AGUtils.showResults(it);

		// Add some more triples to the store
		ts.addStatement("!ex:A","!rdfs:subClassOf", "!ex:B");
		ts.addStatement("!ex:B","!rdfs:subClassOf", "!ex:C");
		ts.addStatement("!ex:a","!rdf:type", "!ex:A");
		
		// index again
		ts.indexAllTriples();
		
		// Another query without reasoning using functor q- 
		pquery = "(q- ?x !rdf:type ?y)";
		q.setVariables(vars);
		q.setQuery(pquery);
		it = q.run();
		System.out.println("Results for " + pquery);
		AGUtils.showResults(it);

		// Now demonstrate reasoning with functor q
		pquery = "(q ?x !rdf:type ?y)";
		q.setVariables(vars);
		q.setQuery(pquery);
		it = q.run();
		System.out.println("Results for " + pquery);
		AGUtils.showResults(it);
		
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
