package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGReasoningInverseOf {

	/**
	 * Demonstrates reasoning involving owl:inverseOf
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create a fresh triple-store for this example.
		AllegroGraph ts = ags.renew("inverseof", AGPaths.TRIPLE_STORES);
		
		// Register your namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		// Add some triples to the store
		ts.addStatement("!ex:a","!ex:owned-by","!ex:b");
		ts.addStatement("!ex:c","!ex:owns","!ex:d");
		ts.addStatement("!ex:jans","!ex:owns","!ex:birra");
		ts.addStatement("!ex:owned-by","!owl:inverseOf","!ex:owns");

		// Retrieve some triples without reasoning 
		TriplesIterator cc = ts.getStatements(false, null, null, null);
		System.out.println("Ground triples in the store:");
		AGUtils.showTriples(cc);

		// Now demonstrate reasoning
		TriplesIterator cc2 = ts.getStatements(true,null,"!ex:owned-by",null);
		System.out.println("owned-by triples in the store and inferred:");
		AGUtils.showTriples(cc2);

		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}