package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGReasoningSubClassOf {

	/**
	 * Demonstrates basic reasoning involving rdfs:subClassOf
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("subclassof", AGPaths.TRIPLE_STORES);
		
		// Register your namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		// Add some triples to the store
		ts.addStatement("!ex:A","!rdfs:subClassOf", "!ex:B");
		ts.addStatement("!ex:B","!rdfs:subClassOf", "!ex:C");
		ts.addStatement("!ex:a","!rdf:type", "!ex:A");
		
		// Retrieve some triples without reasoning 
		TriplesIterator cc = ts.getStatements(false,"!ex:A","!rdfs:subClassOf",null);
		System.out.println("Superclasses of ex:A in the store:");
		AGUtils.showTriples(cc);

		// Now with reasoning
		cc = ts.getStatements(true,"!ex:A","!rdfs:subClassOf",null);
		System.out.println("Superclasses of ex:A inferred:");
		AGUtils.showTriples(cc);

		// Confirm that an instance of type ex:A is an instance of its superclasses
		cc = ts.getStatements(true,"!ex:a","!rdf:type",null);
		System.out.println("Types of ex:a inferred:");
		AGUtils.showTriples(cc);

		// Close the store and disconnect from the server
		ts.closeTripleStore();
		ags.disable();
	}

}