package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSNAPaths {

	/**
	 * Demonstrates using search paths in a Social Network.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple-store.
		AllegroGraph ts = ags.renew("snapaths", AGPaths.TRIPLE_STORES);
		
		// Register namespaces
		ts.registerNamespace("ex", "http://example.org/");
		
		// Load a small graph of data
		AGLoadNtriples.loadNTriplesWithTiming(ts, AGPaths.dataSources("sna-doublediamond.nt"));
		
		// Get an SNA extension instance for this store to work with SNA features 
		SNAExtension sna = ts.getSNAExtension();
		
		// Register a generator
		Object[] parts = new Object[2];
		parts[0] = "objects-of";
		parts[1] = "!ex:to";
		sna.registerGenerator("to", parts);
		
		UPI[] bfsPath = sna.breadthFirstSearch("!ex:a", "!ex:h", "to", 0);
		AGUtils.printUPIArray("BFS path: ", ts, bfsPath);
		
		UPI[][] bfsPaths = sna.allBreadthFirstSearchPaths("!ex:a", "!ex:h", "to", 0);
		System.out.println("There are " + bfsPaths.length + " bfs paths");
		
		UPI[] dfsPath = sna.depthFirstSearch("!ex:a", "!ex:h", "to", 0);
		AGUtils.printUPIArray("DFS path: ", ts, dfsPath);
		
		UPI[][] dfsPaths = sna.allDepthFirstSearchPaths("!ex:a", "!ex:h", "to", 0);
		System.out.println("There are " + dfsPaths.length + " dfs paths");

		UPI[] bdsPath = sna.bidirectionalSearch("!ex:a", "!ex:h", "to", 0);
		AGUtils.printUPIArray("BDS path: ", ts, bdsPath);
		
		UPI[][] bdsPaths = sna.allBidirectionalSearchPaths("!ex:a", "!ex:h", "to", 0);
		System.out.println("There are " + bdsPaths.length + " bds paths");

		// Close the store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}
