package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSetTripleStoreParams {
	
	/**
	 * Demonstrates some basics of setting triple store parameters
	 *   
	 * @param args unused
	 * @throws AllegroGraphException
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to a server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}

		// Create a fresh triple-store.
		AllegroGraph ts = ags.renew("tsparams", AGPaths.TRIPLE_STORES);

		ts.setLookAhead(1000);
		ts.setSelectLimit(10000);
		ts.setUnindexedThreshold(1000);
		ts.setUnmergedThreshold(2);
		
		// Show information about this triple store
		showTripleStoreInfo(ts);
		
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

	public static void showTripleStoreInfo(AllegroGraph ts) throws AllegroGraphException {
		System.out.println("Triple store settings:");		
		System.out.println("  Version: " + AllegroGraph.version());
		System.out.println("  NumberOfTriples: " + ts.numberOfTriples());
		System.out.println("  UnindexedTripleCount: " + ts.getUnindexedTripleCount());
		System.out.println("  UnindexedThreshold: " + ts.getUnindexedThreshold());
		System.out.println("  SelectLimit: " + ts.getSelectLimit());
		System.out.println("  LookAhead: " + ts.getLookAhead());
	    System.out.println("  UnmergedCount: " + ts.getUnmergedCount());
	    System.out.println("  UnmergedThreshold: " + ts.getUnmergedThreshold());
	    AGUtils.printStringArray("IndexFlavors: ", ts.getIndexFlavors());
	    AGUtils.printStringArray("DataMapping: ", ts.getDataMapping());
		AGUtils.printStringArray("Namespace Registry:", ts.getNamespaces());
		AGUtils.printStringArray("Freetext Predicates:", ts.getFreetextPredicates());
	}

}
