package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSparqlDescribe {

	/**
	 * Demonstrates some basics of using DESCRIBE in SPARQL
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("sparql", AGPaths.TRIPLE_STORES);
				
		// Register any namespaces
		ts.registerNamespace("foaf", "http://xmlns.com/foaf/0.1/");

		// Define blank nodes
		BlankNode a = (BlankNode)ts.createBNode("_:a");
		BlankNode b = (BlankNode)ts.createBNode("_:b");
		
		// Add some data to the store
		ts.addStatement(a,"!rdf:type","!foaf:Person");
		ts.addStatement(a,"!foaf:name",ts.createLiteral("Alice"));
		ts.addStatement(a,"!foaf:mbox","<mailto:alice@example.com>");
		ts.addStatement(a,"!foaf:mbox","<mailto:alice@work.example>");
		ts.addStatement(b,"!rdf:type","!foaf:Person");
		ts.addStatement(b,"!foaf:name",ts.createLiteral("Bob"));
		ts.addStatement(b,"!foaf:homepage","<http://work.example.org/alice/>");

		// This query requests that an RDF graph be returned containing
		// data describing resources that have the specified foaf:mbox.
		String query = 
		"PREFIX foaf:   <http://xmlns.com/foaf/0.1/> " +
		"DESCRIBE ?x " +
		"WHERE    { ?x foaf:mbox <mailto:alice@example.com> } ";
		
		// Query the store and show the resulting graph
		SPARQLQuery sq = new SPARQLQuery();
		TriplesIterator cc = sq.describe(ts,query);
		AGUtils.showTriples(cc);
		
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}