package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSparqlEngine {

	/**
	 * Demonstrates how to set which SPARQL Engine to use for a query.
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		
		// Create fresh triple-store for this example.
		AllegroGraph ts = ags.renew("sparqlengine", AGPaths.TRIPLE_STORES);
		
		// Load the Kennedy data set
		AGLoadNtriples.loadNTriplesWithTiming(ts, AGPaths.dataSources("kennedy.ntriples"));

		// Index the store
		AGIndexAllTriples.indexAllTriplesWithTiming(ts);
		
		// The query 
		String query =
			"PREFIX ex: <http://example.org/kennedy/> " +
			"PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> " +
			"SELECT ?pfname ?plname ?sfname ?slname " + 
			"WHERE {" +
				"?person ex:first-name 'Arnold' . " +
				"?person ex:first-name ?pfname . " +
				"?person ex:last-name ?plname . " +
				"?person ex:spouse ?spouse . " +
				"?spouse ex:first-name ?sfname . " +
				"?spouse ex:last-name ?slname . " +
			"}";
		
		// Query the store using the (default) AllegroGraph-2 SPARQL Engine
		SPARQLQuery sq = new SPARQLQuery();
		sq.setTripleStore(ts);
		sq.setQuery(query);
		sq.setEngine(SPARQLQuery.ENGINE.AG2);
		AGSparqlSelect.doSparqlSelect(sq);

		// Query the store using the new SPARQL Algebra Engine.
		sq.setEngine(SPARQLQuery.ENGINE.ALGEBRA);
		AGSparqlSelect.doSparqlSelect(sq);

		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}

}