package com.franz.agbase.examples;

import com.franz.agbase.*;

public class AGSparqlReasoning {

	/**
	 * Demonstrates using SPARQL with an RDFS++ entailment regime
	 * 
	 * @param args unused
	 * @throws AllegroGraphException 
	 */
	public static void main(String[] args) throws AllegroGraphException {
		// Connect to server, which must already be running.
		AllegroGraphConnection ags = new AllegroGraphConnection();
		try {
			ags.enable();
		} catch (Exception e) {
			throw new AllegroGraphException("Server connection problem", e);
		}
		// Create a fresh triple-store for this example.
		AllegroGraph ts = ags.renew("sparqlreasoning", AGPaths.TRIPLE_STORES);
		
		// Register your namespaces
		ts.registerNamespace("ex","http://example.org/");
		
		// Add some triples to the store
		ts.addStatement("!ex:a","!ex:owned-by","!ex:b");
		ts.addStatement("!ex:c","!ex:owns","!ex:d");
		ts.addStatement("!ex:jans","!ex:owns","!ex:birra");
		ts.addStatement("!ex:owned-by","!owl:inverseOf","!ex:owns");

		// A SPARQL query to determine what owns what
		String query = 
		"PREFIX ex: <http://example.org/> " +
		"SELECT DISTINCT ?x ?y " +
		"WHERE { ?x ex:owns ?y }";
		
		// First query using SPARQL's standard entailment regime 
		SPARQLQuery sq = new SPARQLQuery();
		sq.setTripleStore(ts);
		sq.setQuery(query);
		sq.setIncludeInferred(false);
		AGSparqlSelect.doSparqlSelect(sq);

		// Now using RDFS++ entailment
		sq.setIncludeInferred(true);
		AGSparqlSelect.doSparqlSelect(sq);

		// Add some more triples to the store
		ts.addStatement("!ex:A","!rdfs:subClassOf", "!ex:B");
		ts.addStatement("!ex:B","!rdfs:subClassOf", "!ex:C");
		ts.addStatement("!ex:a","!rdf:type", "!ex:A");
		
		// A query to determine the types of ex:a 
		query = 
		"PREFIX ex: <http://example.org/> " +
		"PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> " +
		"SELECT DISTINCT ?y " +
		"WHERE { ex:a rdf:type ?y }";

		// Query without RDFS++ reasoning
		sq.setQuery(query);
		sq.setIncludeInferred(false);
		AGSparqlSelect.doSparqlSelect(sq);
		
		// Now with reasoning
		sq.setIncludeInferred(true);
		AGSparqlSelect.doSparqlSelect(sq);
		
		// Close the triple store and disconnect from the server.
		ts.closeTripleStore();
		ags.disable();
	}
}